/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.io;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.io.HprofBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import sun.nio.ch.DirectBuffer;

public class MemoryMappedFileBuffer
implements HprofBuffer {
    private static final int DEFAULT_SIZE = 0x40000000;
    private static final int DEFAULT_PADDING = 1024;
    private final int mBufferSize;
    private final int mPadding;
    @NonNull
    private final ByteBuffer[] mByteBuffers;
    private final long mLength;
    private long mCurrentPosition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MemoryMappedFileBuffer(@NonNull File f, int bufferSize, int padding) throws IOException {
        this.mBufferSize = bufferSize;
        this.mPadding = padding;
        this.mLength = f.length();
        int shards = (int)(this.mLength / (long)this.mBufferSize) + 1;
        this.mByteBuffers = new ByteBuffer[shards];
        FileInputStream inputStream = new FileInputStream(f);
        try {
            long offset = 0L;
            for (int i = 0; i < shards; ++i) {
                long size = Math.min(this.mLength - offset, (long)(this.mBufferSize + this.mPadding));
                this.mByteBuffers[i] = inputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, offset, size);
                this.mByteBuffers[i].order(ByteOrder.BIG_ENDIAN);
                offset += (long)this.mBufferSize;
            }
            this.mCurrentPosition = 0L;
        }
        finally {
            inputStream.close();
        }
    }

    public MemoryMappedFileBuffer(@NonNull File f) throws IOException {
        this(f, 0x40000000, 1024);
    }

    public void dispose() {
        try {
            for (int i = 0; i < this.mByteBuffers.length; ++i) {
                ((DirectBuffer)((Object)this.mByteBuffers[i])).cleaner().clean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public byte readByte() {
        byte result = this.mByteBuffers[this.getIndex()].get(this.getOffset());
        ++this.mCurrentPosition;
        return result;
    }

    @Override
    public void read(@NonNull byte[] b) {
        int index = this.getIndex();
        this.mByteBuffers[index].position(this.getOffset());
        if (b.length <= this.mByteBuffers[index].remaining()) {
            this.mByteBuffers[index].get(b, 0, b.length);
        } else {
            int split = this.mBufferSize - this.mByteBuffers[index].position();
            this.mByteBuffers[index].get(b, 0, split);
            this.mByteBuffers[index + 1].position(0);
            this.mByteBuffers[index + 1].get(b, split, b.length - split);
        }
        this.mCurrentPosition += (long)b.length;
    }

    @Override
    public char readChar() {
        char result = this.mByteBuffers[this.getIndex()].getChar(this.getOffset());
        this.mCurrentPosition += 2L;
        return result;
    }

    @Override
    public short readShort() {
        short result = this.mByteBuffers[this.getIndex()].getShort(this.getOffset());
        this.mCurrentPosition += 2L;
        return result;
    }

    @Override
    public int readInt() {
        int result = this.mByteBuffers[this.getIndex()].getInt(this.getOffset());
        this.mCurrentPosition += 4L;
        return result;
    }

    @Override
    public long readLong() {
        long result = this.mByteBuffers[this.getIndex()].getLong(this.getOffset());
        this.mCurrentPosition += 8L;
        return result;
    }

    @Override
    public float readFloat() {
        float result = this.mByteBuffers[this.getIndex()].getFloat(this.getOffset());
        this.mCurrentPosition += 4L;
        return result;
    }

    @Override
    public double readDouble() {
        double result = this.mByteBuffers[this.getIndex()].getDouble(this.getOffset());
        this.mCurrentPosition += 8L;
        return result;
    }

    @Override
    public void setPosition(long position) {
        this.mCurrentPosition = position;
    }

    @Override
    public long position() {
        return this.mCurrentPosition;
    }

    @Override
    public boolean hasRemaining() {
        return this.mCurrentPosition < this.mLength;
    }

    @Override
    public long remaining() {
        return this.mLength - this.mCurrentPosition;
    }

    private int getIndex() {
        return (int)(this.mCurrentPosition / (long)this.mBufferSize);
    }

    private int getOffset() {
        return (int)(this.mCurrentPosition % (long)this.mBufferSize);
    }
}

