/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ModuleType<T extends ModuleBuilder> {
    public static final ModuleType EMPTY = ModuleType.instantiate("com.intellij.openapi.module.EmptyModuleType");
    @NotNull
    private final String myId;
    private final FrameworkRole myFrameworkRole;

    protected ModuleType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/module/ModuleType", "<init>"));
        }
        this.myId = id;
        this.myFrameworkRole = new FrameworkRole(id);
    }

    @NotNull
    public abstract T createModuleBuilder();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDescription();

    public abstract Icon getBigIcon();

    public Icon getIcon() {
        return this.getNodeIcon(false);
    }

    public abstract Icon getNodeIcon(@Deprecated boolean var1);

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull T moduleBuilder, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/openapi/module/ModuleType", "createWizardSteps"));
        }
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/openapi/module/ModuleType", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/openapi/module/ModuleType", "createWizardSteps"));
        }
        if (ModuleWizardStep.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleType", "createWizardSteps"));
        }
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/openapi/module/ModuleType", "modifySettingsStep"));
        }
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/openapi/module/ModuleType", "modifySettingsStep"));
        }
        return null;
    }

    @Nullable
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/openapi/module/ModuleType", "modifyProjectTypeStep"));
        }
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/openapi/module/ModuleType", "modifyProjectTypeStep"));
        }
        return null;
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleType", "getId"));
        }
        return string;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleType)) {
            return false;
        }
        ModuleType moduleType = (ModuleType)o;
        return this.myId.equals(moduleType.myId);
    }

    public final int hashCode() {
        return this.myId.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    private static ModuleType instantiate(String className) {
        ModuleType moduleType;
        try {
            moduleType = (ModuleType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleType", "instantiate"));
        }
        return moduleType;
    }

    public boolean isValidSdk(@NotNull Module module, @Nullable Sdk projectSdk) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleType", "isValidSdk"));
        }
        return true;
    }

    public static ModuleType get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleType", "get"));
        }
        ModuleTypeManager instance = ModuleTypeManager.getInstance();
        if (instance == null) {
            return EMPTY;
        }
        return instance.findByID(module.getOptionValue("type"));
    }

    @NotNull
    public FrameworkRole getDefaultAcceptableRole() {
        FrameworkRole frameworkRole = this.myFrameworkRole;
        if (frameworkRole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleType", "getDefaultAcceptableRole"));
        }
        return frameworkRole;
    }

    public boolean isSupportedRootType(JpsModuleSourceRootType type) {
        return true;
    }
}

