/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.NamedEnum;

public class NamedEnumUtil {
    private static final Function<Enum, String> NAMED_SHOW = new Function<Enum, String>(){

        public String fun(Enum s) {
            return ((NamedEnum)((Object)s)).getValue();
        }
    };
    private static final Function<Enum, String> SIMPLE_SHOW = new Function<Enum, String>(){

        public String fun(Enum s) {
            return s.name();
        }
    };

    public static <T extends Enum> T getEnumElementByValue(Class<T> enumClass, String value, Function<Enum, String> show) {
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            if (!Comparing.equal((String)value, (String)((String)show.fun((Object)t)))) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends Enum> T getEnumElementByValue(Class<T> enumClass, String value) {
        return NamedEnumUtil.getEnumElementByValue(enumClass, value, NamedEnumUtil.getShow(enumClass));
    }

    private static <T extends Enum> Function<Enum, String> getShow(Class<T> enumClass) {
        return ReflectionUtil.isAssignable(NamedEnum.class, enumClass) ? NAMED_SHOW : SIMPLE_SHOW;
    }

    public static <T extends Enum> String getEnumValueByElement(T element) {
        return element == null ? null : (String)NamedEnumUtil.getShow(element.getClass()).fun(element);
    }
}

