/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.BasePathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashSet;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.AbstractEclipseClasspathReader;
import org.jetbrains.idea.eclipse.ConversionException;
import org.jetbrains.idea.eclipse.EclipseModuleManager;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;
import org.jetbrains.idea.eclipse.util.ErrorLog;

public class EclipseClasspathReader
extends AbstractEclipseClasspathReader<ModifiableRootModel> {
    private final Project myProject;
    private ContentEntry myContentEntry;

    public EclipseClasspathReader(@NotNull String rootPath, @NotNull Project project, @Nullable List<String> currentRoots) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "<init>"));
        }
        this(rootPath, project, currentRoots, null);
    }

    public EclipseClasspathReader(@NotNull String rootPath, @NotNull Project project, @Nullable List<String> currentRoots, @Nullable Set<String> moduleNames) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "<init>"));
        }
        super(rootPath, currentRoots, moduleNames);
        this.myProject = project;
    }

    public void init(@NotNull ModifiableRootModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "init"));
        }
        this.myContentEntry = model.addContentEntry(EclipseClasspathReader.pathToUrl((String)this.myRootPath));
    }

    public static void collectVariables(Set<String> usedVariables, Element classpathElement, String rootPath) {
        for (Element element : classpathElement.getChildren("classpathentry")) {
            EclipseProjectFinder.LinkedResource linkedResource;
            String path = element.getAttributeValue("path");
            if (path == null) continue;
            String kind = element.getAttributeValue("kind");
            if (Comparing.strEqual((String)kind, (String)"var")) {
                EclipseClasspathReader.createEPathVariable((String)path, (int)0);
                String srcPath = element.getAttributeValue("sourcepath");
                if (srcPath == null) continue;
                EclipseClasspathReader.createEPathVariable((String)srcPath, (int)EclipseClasspathReader.srcVarStart((String)srcPath));
                continue;
            }
            if (!Comparing.strEqual((String)kind, (String)"src") && !Comparing.strEqual((String)kind, (String)"output") || (linkedResource = EclipseProjectFinder.findLinkedResource((String)rootPath, (String)path)) == null || !linkedResource.containsPathVariable()) continue;
            usedVariables.add(linkedResource.getVariableName());
        }
    }

    public void readClasspath(@NotNull ModifiableRootModel model, @NotNull Element classpathElement) throws IOException, ConversionException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "readClasspath"));
        }
        if (classpathElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classpathElement", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "readClasspath"));
        }
        THashSet sink = new THashSet();
        this.readClasspath(model, (Collection<String>)sink, (Collection<String>)sink, (Set<String>)sink, null, classpathElement);
    }

    public void readClasspath(@NotNull ModifiableRootModel model, @NotNull Collection<String> unknownLibraries, @NotNull Collection<String> unknownJdks, Set<String> refsToModules, String testPattern, Element classpathElement) throws IOException, ConversionException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "readClasspath"));
        }
        if (unknownLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownLibraries", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "readClasspath"));
        }
        if (unknownJdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownJdks", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "readClasspath"));
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (orderEntry instanceof ModuleSourceOrderEntry) continue;
            model.removeOrderEntry(orderEntry);
        }
        int idx = 0;
        EclipseModuleManagerImpl eclipseModuleManager = EclipseModuleManagerImpl.getInstance(model.getModule());
        HashSet libs = new HashSet();
        for (Element o : classpathElement.getChildren("classpathentry")) {
            try {
                this.readClasspathEntry(model, unknownLibraries, unknownJdks, refsToModules, testPattern, o, idx++, eclipseModuleManager, ((BasePathMacroManager)PathMacroManager.getInstance((ComponentManager)model.getModule())).getExpandMacroMap(), (Set)libs);
            }
            catch (ConversionException e) {
                ErrorLog.rethrow(ErrorLog.Level.Warning, null, ".classpath", (Exception)((Object)e));
            }
        }
        if (!model.isSdkInherited() && model.getSdkName() == null) {
            eclipseModuleManager.setForceConfigureJDK();
            model.inheritSdk();
        }
    }

    protected int rearrange(ModifiableRootModel rootModel) {
        return EclipseClasspathReader.rearrangeOrderEntryOfType(rootModel, ModuleSourceOrderEntry.class);
    }

    protected String expandEclipsePath2Url(ModifiableRootModel rootModel, String path) {
        VirtualFile contentRoot = this.myContentEntry.getFile();
        if (contentRoot != null) {
            return EPathUtil.expandEclipsePath2Url(path, rootModel, this.myCurrentRoots, contentRoot);
        }
        return EPathUtil.expandEclipsePath2Url(path, rootModel, this.myCurrentRoots);
    }

    protected Set<String> getDefinedCons() {
        return EclipseNatureImporter.getAllDefinedCons();
    }

    protected void addModuleLibrary(ModifiableRootModel rootModel, Element element, boolean exported, String libName, String url, String srcUrl, ExpandMacroToPathMap macroMap) {
        Library library = rootModel.getModuleLibraryTable().getModifiableModel().createLibrary(libName);
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        modifiableModel.addRoot(url, OrderRootType.CLASSES);
        if (srcUrl != null) {
            modifiableModel.addRoot(srcUrl, OrderRootType.SOURCES);
        }
        EJavadocUtil.appendJavadocRoots(element, (ModuleRootModel)rootModel, this.myCurrentRoots, modifiableModel);
        modifiableModel.commit();
        EclipseClasspathReader.setLibraryEntryExported(rootModel, exported, library);
    }

    protected void addJUnitDefaultLib(ModifiableRootModel rootModel, String junitName, ExpandMacroToPathMap macroMap) {
        Library library = rootModel.getModuleLibraryTable().getModifiableModel().createLibrary(junitName);
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        modifiableModel.addRoot(EclipseClasspathReader.getJunitClsUrl(junitName.contains("4")), OrderRootType.CLASSES);
        modifiableModel.commit();
    }

    protected void addSourceFolderToCurrentContentRoot(ModifiableRootModel rootModel, String srcUrl, boolean testFolder) {
        this.myContentEntry.addSourceFolder(srcUrl, testFolder);
    }

    protected void addSourceFolder(ModifiableRootModel rootModel, String srcUrl, boolean testFolder) {
        rootModel.addContentEntry(srcUrl).addSourceFolder(srcUrl, testFolder);
    }

    protected void setUpModuleJdk(ModifiableRootModel rootModel, Collection<String> unknownJdks, EclipseModuleManager eclipseModuleManager, String jdkName) {
        if (jdkName == null) {
            rootModel.inheritSdk();
        } else {
            Sdk moduleJdk = ProjectJdkTable.getInstance().findJdk(jdkName);
            if (moduleJdk != null) {
                rootModel.setSdk(moduleJdk);
            } else {
                rootModel.setInvalidSdk(jdkName, "JavaSDK");
                eclipseModuleManager.setInvalidJdk(jdkName);
                unknownJdks.add(jdkName);
            }
        }
        EclipseClasspathReader.rearrangeOrderEntryOfType(rootModel, JdkOrderEntry.class);
    }

    protected void addInvalidModuleEntry(ModifiableRootModel rootModel, boolean exported, String moduleName) {
        rootModel.addInvalidModuleEntry(moduleName).setExported(exported);
    }

    private static int rearrangeOrderEntryOfType(ModifiableRootModel rootModel, Class<? extends OrderEntry> orderEntryClass) {
        Object[] orderEntries = rootModel.getOrderEntries();
        int moduleSourcesIdx = 0;
        for (OrderEntry orderEntry : orderEntries) {
            if (orderEntryClass.isAssignableFrom(orderEntry.getClass())) break;
            ++moduleSourcesIdx;
        }
        orderEntries = (OrderEntry[])ArrayUtil.append((Object[])orderEntries, (Object)orderEntries[moduleSourcesIdx]);
        orderEntries = (OrderEntry[])ArrayUtil.remove((Object[])orderEntries, (int)moduleSourcesIdx);
        rootModel.rearrangeOrderEntries((OrderEntry[])orderEntries);
        return orderEntries.length - 1;
    }

    public void setupOutput(ModifiableRootModel rootModel, String path) {
        EclipseClasspathReader.setOutputUrl(rootModel, path);
    }

    public static void setOutputUrl(@NotNull ModifiableRootModel rootModel, @NotNull String path) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "setOutputUrl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader", "setOutputUrl"));
        }
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.setCompilerOutputPath(EclipseClasspathReader.pathToUrl((String)path));
        compilerModuleExtension.inheritCompilerOutputPath(false);
    }

    private static void setLibraryEntryExported(ModifiableRootModel rootModel, boolean exported, Library library) {
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !((LibraryOrderEntry)orderEntry).isModuleLevel() || !Comparing.equal((Object)((LibraryOrderEntry)orderEntry).getLibrary(), (Object)library)) continue;
            ((LibraryOrderEntry)orderEntry).setExported(exported);
            break;
        }
    }

    protected void addNamedLibrary(ModifiableRootModel rootModel, Collection<String> unknownLibraries, boolean exported, String name, boolean applicationLevel) {
        Library lib = EclipseClasspathReader.findLibraryByName(this.myProject, name);
        if (lib != null) {
            rootModel.addLibraryEntry(lib).setExported(exported);
        } else {
            unknownLibraries.add(name);
            rootModel.addInvalidLibrary(name, applicationLevel ? "application" : "project").setExported(exported);
        }
    }

    public static Library findLibraryByName(Project project, String name) {
        Library lib;
        block2: {
            LibraryTable table;
            LibraryTablesRegistrar tablesRegistrar = LibraryTablesRegistrar.getInstance();
            lib = tablesRegistrar.getLibraryTable().getLibraryByName(name);
            if (lib == null) {
                lib = tablesRegistrar.getLibraryTable(project).getLibraryByName(name);
            }
            if (lib != null) break block2;
            Iterator i$ = tablesRegistrar.getCustomLibraryTables().iterator();
            while (i$.hasNext() && (lib = (table = (LibraryTable)i$.next()).getLibraryByName(name)) == null) {
            }
        }
        return lib;
    }

    static String getJunitClsUrl(boolean version4) {
        String url = version4 ? JavaSdkUtil.getJunit4JarPath() : JavaSdkUtil.getJunit3JarPath();
        VirtualFile localFile = VirtualFileManager.getInstance().findFileByUrl(EclipseClasspathReader.pathToUrl((String)url));
        if (localFile != null) {
            VirtualFile jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile);
            url = jarFile != null ? jarFile.getUrl() : localFile.getUrl();
        }
        return url;
    }

    protected String prepareValidUrlInsideJar(String url) {
        VirtualFile jarFile;
        VirtualFile localFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (localFile != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
            return jarFile.getUrl();
        }
        return url;
    }
}

