/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Nullable;

public class DevKitImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            return DevKitImplicitUsageProvider.isDomElementClass(psiClass);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            return DevKitImplicitUsageProvider.isDomElementMethod(psiMethod);
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }

    static boolean isDomElementClass(PsiClass psiClass) {
        if (psiClass.isEnum() || psiClass.isAnnotationType() || psiClass.hasModifierProperty("private")) {
            return false;
        }
        return DevKitImplicitUsageProvider.isDomElementInheritor(psiClass);
    }

    private static boolean isDomElementMethod(PsiMethod psiMethod) {
        if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor() || psiMethod.getParameterList().getParametersCount() > 1) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (!DevKitImplicitUsageProvider.isDomElementClass(containingClass)) {
            return DevKitImplicitUsageProvider.isDomElementVisitorMethod(psiMethod, containingClass);
        }
        PsiType returnType = psiMethod.getReturnType();
        if (!(returnType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType returnClassType = (PsiClassType)returnType;
        PsiClass returnResolved = returnClassType.resolve();
        if (DevKitImplicitUsageProvider.isDomElementInheritor(returnResolved)) {
            return true;
        }
        if (returnClassType.getParameterCount() == 1 && InheritanceUtil.isInheritor((PsiClass)returnResolved, (String)"java.util.List")) {
            PsiType listType = returnClassType.getParameters()[0];
            return DevKitImplicitUsageProvider.isDomElementInheritor(listType);
        }
        return false;
    }

    private static boolean isDomElementVisitorMethod(PsiMethod method, PsiClass containingClass) {
        if (method.getReturnType() != PsiType.VOID || !method.getName().startsWith("visit") || method.getParameterList().getParametersCount() != 1 || !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"com.intellij.util.xml.DomElementVisitor")) {
            return false;
        }
        PsiType psiType = method.getParameterList().getParameters()[0].getType();
        return DevKitImplicitUsageProvider.isDomElementInheritor(psiType);
    }

    private static boolean isDomElementInheritor(@Nullable PsiType psiType) {
        return InheritanceUtil.isInheritor((PsiType)psiType, (String)"com.intellij.util.xml.DomElement");
    }

    private static boolean isDomElementInheritor(@Nullable PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.intellij.util.xml.DomElement");
    }
}

