/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.ConversionException;
import org.jetbrains.idea.eclipse.EclipseModuleManager;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;

public abstract class AbstractEclipseClasspathReader<T> {
    protected final String myRootPath;
    @Nullable
    protected final List<String> myCurrentRoots;
    @Nullable
    protected final Set<String> myModuleNames;

    public AbstractEclipseClasspathReader(@NotNull String rootPath, @Nullable List<String> currentRoots, @Nullable Set<String> moduleNames) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "<init>"));
        }
        this.myRootPath = FileUtil.toSystemIndependentName((String)rootPath);
        this.myCurrentRoots = currentRoots;
        this.myModuleNames = moduleNames;
    }

    protected abstract String prepareValidUrlInsideJar(String var1);

    protected abstract void addNamedLibrary(T var1, Collection<String> var2, boolean var3, String var4, boolean var5);

    protected abstract void addInvalidModuleEntry(T var1, boolean var2, String var3);

    protected abstract void setUpModuleJdk(T var1, Collection<String> var2, EclipseModuleManager var3, String var4);

    public abstract void setupOutput(T var1, String var2);

    protected abstract void addSourceFolder(T var1, String var2, boolean var3);

    protected abstract void addSourceFolderToCurrentContentRoot(T var1, String var2, boolean var3);

    protected abstract void addJUnitDefaultLib(T var1, String var2, ExpandMacroToPathMap var3);

    protected abstract void addModuleLibrary(T var1, Element var2, boolean var3, String var4, String var5, String var6, ExpandMacroToPathMap var7);

    protected abstract String expandEclipsePath2Url(T var1, String var2);

    protected abstract Set<String> getDefinedCons();

    protected abstract int rearrange(T var1);

    protected void readClasspathEntry(T rootModel, Collection<String> unknownLibraries, Collection<String> unknownJdks, Set<String> refsToModules, String testPattern, Element element, int index, @Nullable EclipseModuleManager eclipseModuleManager, ExpandMacroToPathMap macroMap, Set<String> libs) throws ConversionException {
        String kind = element.getAttributeValue("kind");
        if (kind == null) {
            throw new ConversionException("Missing classpathentry/@kind");
        }
        String path = element.getAttributeValue("path");
        if (path == null) {
            throw new ConversionException("Missing classpathentry/@path");
        }
        boolean exported = "true".equals(element.getAttributeValue("exported"));
        if (kind.equals("src")) {
            if (path.startsWith("/")) {
                String moduleName = path.substring(1);
                refsToModules.add(moduleName);
                this.addInvalidModuleEntry(rootModel, exported, moduleName);
            } else {
                boolean isTestFolder;
                String srcUrl = AbstractEclipseClasspathReader.pathToUrl(this.myRootPath + "/" + path);
                try {
                    isTestFolder = !StringUtil.isEmpty((String)testPattern) && path.matches(testPattern);
                }
                catch (PatternSyntaxException e) {
                    isTestFolder = false;
                }
                String linked = this.expandLinkedResourcesPath(macroMap, path);
                if (linked == null) {
                    this.addSourceFolderToCurrentContentRoot(rootModel, srcUrl, isTestFolder);
                } else {
                    srcUrl = this.prepareValidUrlInsideJar(AbstractEclipseClasspathReader.pathToUrl(linked));
                    if (eclipseModuleManager != null) {
                        eclipseModuleManager.registerEclipseLinkedSrcVarPath(srcUrl, path);
                    }
                    this.addSourceFolder(rootModel, srcUrl, isTestFolder);
                }
                if (eclipseModuleManager != null) {
                    eclipseModuleManager.setExpectedModuleSourcePlace(this.rearrange(rootModel));
                    eclipseModuleManager.registerSrcPlace(srcUrl, index);
                }
            }
        } else if (kind.equals("output")) {
            String output = this.myRootPath + "/" + path;
            String linked = this.expandLinkedResourcesPath(macroMap, path);
            if (linked != null) {
                output = linked;
                if (eclipseModuleManager != null) {
                    eclipseModuleManager.registerEclipseLinkedVarPath(AbstractEclipseClasspathReader.pathToUrl(output), path);
                }
            }
            this.setupOutput(rootModel, output);
        } else if (kind.equals("lib")) {
            String url;
            String linked = this.expandLinkedResourcesPath(macroMap, path);
            if (linked != null) {
                url = this.prepareValidUrlInsideJar(AbstractEclipseClasspathReader.pathToUrl(linked));
                if (eclipseModuleManager != null) {
                    eclipseModuleManager.registerEclipseLinkedVarPath(url, path);
                }
            } else {
                url = this.expandEclipsePath2Url(rootModel, path);
            }
            if (eclipseModuleManager != null) {
                eclipseModuleManager.registerEclipseLibUrl(url);
            }
            String sourcePath = element.getAttributeValue("sourcepath");
            String srcUrl = null;
            if (sourcePath != null) {
                String linkedSrc = this.expandLinkedResourcesPath(macroMap, sourcePath);
                if (linkedSrc != null) {
                    srcUrl = this.prepareValidUrlInsideJar(AbstractEclipseClasspathReader.pathToUrl(linkedSrc));
                    if (eclipseModuleManager != null) {
                        eclipseModuleManager.registerEclipseLinkedSrcVarPath(srcUrl, sourcePath);
                    }
                } else {
                    srcUrl = this.expandEclipsePath2Url(rootModel, sourcePath);
                }
            }
            this.addModuleLibrary(rootModel, element, exported, AbstractEclipseClasspathReader.getPresentableName(path, libs), url, srcUrl, macroMap);
        } else if (kind.equals("var")) {
            int slash = path.indexOf("/");
            if (slash == 0) {
                throw new ConversionException("Incorrect 'classpathentry/var@path' format");
            }
            String libName = AbstractEclipseClasspathReader.getPresentableName(path, libs);
            String url = this.eclipseVariabledPath2Url(macroMap, path, 0);
            if (eclipseModuleManager != null) {
                eclipseModuleManager.registerEclipseVariablePath(url, path);
            }
            String srcPathAttr = element.getAttributeValue("sourcepath");
            String srcUrl = null;
            if (srcPathAttr != null) {
                srcUrl = this.eclipseVariabledPath2Url(macroMap, srcPathAttr, AbstractEclipseClasspathReader.srcVarStart(srcPathAttr));
                if (eclipseModuleManager != null) {
                    eclipseModuleManager.registerEclipseSrcVariablePath(srcUrl, srcPathAttr);
                }
            }
            this.addModuleLibrary(rootModel, element, exported, libName, url, srcUrl, macroMap);
        } else if (kind.equals("con")) {
            if (path.equals("org.eclipse.pde.core.requiredPlugins")) {
                this.readRequiredBundles(rootModel, refsToModules);
                this.addNamedLibrary(rootModel, unknownLibraries, exported, "ECLIPSE", true);
            } else if (path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                String jdkName = AbstractEclipseClasspathReader.getLastPathComponent(path);
                this.setUpModuleJdk(rootModel, unknownJdks, eclipseModuleManager, jdkName);
            } else if (path.startsWith("org.eclipse.jdt.USER_LIBRARY")) {
                this.addNamedLibrary(rootModel, unknownLibraries, exported, AbstractEclipseClasspathReader.getPresentableName(path), false);
            } else if (path.startsWith("org.eclipse.jdt.junit.JUNIT_CONTAINER")) {
                String junitName = "junit" + AbstractEclipseClasspathReader.getPresentableName(path);
                this.addJUnitDefaultLib(rootModel, junitName, macroMap);
            } else {
                Set<String> registeredCons = this.getDefinedCons();
                if (registeredCons.contains(path)) {
                    if (eclipseModuleManager != null) {
                        eclipseModuleManager.registerCon(path);
                        eclipseModuleManager.registerSrcPlace(path, index);
                    }
                } else {
                    if (eclipseModuleManager != null) {
                        eclipseModuleManager.registerUnknownCons(path);
                    }
                    this.addNamedLibrary(rootModel, new ArrayList<String>(), exported, path, true);
                }
            }
        } else {
            throw new ConversionException("Unknown classpathentry/@kind: " + kind);
        }
    }

    protected static int srcVarStart(String srcPath) {
        return srcPath.startsWith("/") ? 1 : 0;
    }

    @NotNull
    protected static String getPresentableName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "getPresentableName"));
        }
        String string = AbstractEclipseClasspathReader.getPresentableName(path, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    protected static String getPresentableName(@NotNull String path, Set<String> names) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "getPresentableName"));
        }
        String pathComponent = AbstractEclipseClasspathReader.getLastPathComponent(path);
        if (pathComponent != null && names != null && !names.add(pathComponent)) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "getPresentableName"));
            }
            return string;
        }
        String string = pathComponent == null ? path : pathComponent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public static String getLastPathComponent(String path) {
        int idx = path.lastIndexOf(47);
        return idx < 0 || idx == path.length() - 1 ? null : path.substring(idx + 1);
    }

    protected static String getVariableRelatedPath(String var, String path) {
        return var == null ? null : "$" + var + "$" + (path == null ? "" : "/" + path);
    }

    @NotNull
    protected static String pathToUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "pathToUrl"));
        }
        String string = "file://" + path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/AbstractEclipseClasspathReader", "pathToUrl"));
        }
        return string;
    }

    protected static EPathVariable createEPathVariable(String pathAttr, int varStart) {
        int slash = pathAttr.indexOf("/", varStart);
        if (slash > 0) {
            return new EPathVariable(pathAttr.substring(varStart, slash), pathAttr.substring(slash + 1));
        }
        return new EPathVariable(pathAttr.substring(varStart), null);
    }

    protected String eclipseVariabledPath2Url(ExpandMacroToPathMap pathMap, String path, int varStart) {
        EPathVariable var = AbstractEclipseClasspathReader.createEPathVariable(path, varStart);
        return this.prepareValidUrlInsideJar(pathMap.substitute(AbstractEclipseClasspathReader.pathToUrl(AbstractEclipseClasspathReader.getVariableRelatedPath(var.myVariable, var.myRelatedPath)), SystemInfo.isFileSystemCaseSensitive));
    }

    @Nullable
    protected String expandLinkedResourcesPath(ExpandMacroToPathMap macroMap, String path) {
        EclipseProjectFinder.LinkedResource linkedResource = EclipseProjectFinder.findLinkedResource(this.myRootPath, path);
        if (linkedResource != null) {
            if (linkedResource.containsPathVariable()) {
                String toPathVariableFormat = AbstractEclipseClasspathReader.getVariableRelatedPath(linkedResource.getVariableName(), linkedResource.getRelativeToVariablePath());
                return macroMap.substitute(toPathVariableFormat, SystemInfo.isFileSystemCaseSensitive);
            }
            return linkedResource.getLocation();
        }
        return null;
    }

    protected void readRequiredBundles(T rootModel, Set<String> refsToModules) throws ConversionException {
        if (this.myModuleNames == null) {
            return;
        }
        File manifestFile = new File(this.myRootPath, "META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            return;
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(manifestFile));
            Manifest manifest = new Manifest(in);
            String attributes = manifest.getMainAttributes().getValue("Require-Bundle");
            if (!StringUtil.isEmpty((String)attributes)) {
                StringTokenizer tokenizer = new StringTokenizer(attributes, ",");
                while (tokenizer.hasMoreTokens()) {
                    String bundle = tokenizer.nextToken().trim();
                    if (bundle.isEmpty()) continue;
                    int constraintIndex = bundle.indexOf(59);
                    if (constraintIndex != -1) {
                        bundle = bundle.substring(0, constraintIndex).trim();
                    }
                    if (!this.myModuleNames.contains(bundle)) continue;
                    refsToModules.add(bundle);
                    this.addInvalidModuleEntry(rootModel, false, bundle);
                }
            }
        }
        catch (IOException e) {
            throw new ConversionException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static class EPathVariable {
        private final String myVariable;
        private final String myRelatedPath;

        protected EPathVariable(String variable, String relatedPath) {
            this.myVariable = variable;
            this.myRelatedPath = relatedPath;
        }
    }
}

