/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.NewChildEvent;
import com.intellij.execution.junit2.events.StateChangedEvent;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.Formatters;
import com.intellij.execution.junit2.ui.TestProgress;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.testframework.ui.TestStatusLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.ui.SimpleColoredComponent;

class JUnitStatusLine
extends TestStatusLine {
    private final StateInfo myStateInfo = new StateInfo();
    private boolean myTestsBuilt = false;

    JUnitStatusLine() {
    }

    public void setModel(JUnitRunningModel model) {
        this.myTestsBuilt = true;
        this.myProgressBar.setForeground(ColorProgressBar.GREEN);
        model.addListener(new TestProgressListener(model.getProgress()));
    }

    public void onProcessStarted(final ProcessHandler process) {
        if (this.myTestsBuilt) {
            return;
        }
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                process.removeProcessListener((ProcessListener)this);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JUnitStatusLine.this.myStateInfo.setTerminated(JUnitStatusLine.this.myState);
                        if (!JUnitStatusLine.this.myTestsBuilt && JUnitStatusLine.this.myProgressBar.getValue() == 0) {
                            JUnitStatusLine.this.setStatusColor(ColorProgressBar.RED);
                            JUnitStatusLine.this.setFraction(1.0);
                            JUnitStatusLine.this.myState.append(ExecutionBundle.message((String)"junit.running.info.failed.to.start.error.message", (Object[])new Object[0]));
                        }
                    }
                });
            }
        });
    }

    private class TestProgressListener
    extends JUnitAdapter {
        private TestProgress myProgress;

        public TestProgressListener(TestProgress progress) {
            this.myProgress = progress;
        }

        @Override
        public void onRunnerStateChanged(StateEvent event) {
            if (!event.isRunning()) {
                CompletionEvent completionEvent = (CompletionEvent)event;
                JUnitStatusLine.this.myStateInfo.setDone(completionEvent);
                this.myProgress.setDone(completionEvent);
                if (completionEvent.isTerminated() && !this.myProgress.hasDefects()) {
                    JUnitStatusLine.this.setStatusColor(ColorProgressBar.YELLOW);
                }
                this.updateCounters();
            }
        }

        @Override
        public void onTestChanged(TestEvent event) {
            if (event instanceof StateChangedEvent || event instanceof NewChildEvent) {
                this.updateCounters();
            }
        }

        @Override
        public void doDispose() {
            this.myProgress = null;
        }

        private void updateCounters() {
            JUnitStatusLine.this.myStateInfo.updateCounters(this.myProgress);
            JUnitStatusLine.this.setFraction(JUnitStatusLine.this.myStateInfo.getCompletedPercents());
            if (this.myProgress.hasDefects()) {
                JUnitStatusLine.this.setStatusColor(ColorProgressBar.RED);
            }
            JUnitStatusLine.this.myStateInfo.updateLabel(JUnitStatusLine.this.myState);
        }
    }

    private static class StateInfo {
        private int myTotal = 0;
        private int myCompleted = 0;
        private int myDefects = 0;
        private String myCurrentTestName = "";
        private StateEvent myDoneEvent;
        private boolean myTerminated = false;

        private StateInfo() {
        }

        public void setDone(StateEvent event) {
            this.myDoneEvent = event;
        }

        public void updateCounters(TestProgress progress) {
            this.myTotal = progress.getMaximum();
            this.myCompleted = progress.getValue();
            this.myDefects = progress.countDefects();
            TestProxy currentTest = progress.getCurrentTest();
            this.myCurrentTestName = currentTest == null ? "" : Formatters.printTest(currentTest);
        }

        public double getCompletedPercents() {
            return (double)this.myCompleted / (double)this.myTotal;
        }

        public void updateLabel(SimpleColoredComponent label) {
            StringBuilder buffer = new StringBuilder();
            if (this.myDoneEvent != null && this.myTerminated) {
                String termMessage = this.generateTermMessage(this.getTestCount(0));
                buffer.append(termMessage);
                String comment = this.myDoneEvent.getComment();
                if (comment.length() > 0) {
                    buffer.append(" (").append(comment).append(")");
                }
            } else {
                buffer.append(ExecutionBundle.message((String)"junit.running.info.status.running.number.with.name", (Object[])new Object[]{this.getTestCount(this.myDoneEvent != null ? 0 : 1), this.myCurrentTestName}));
            }
            label.append(buffer.toString());
        }

        private String getTestCount(int offset) {
            String testCount = this.myDefects > 0 ? ExecutionBundle.message((String)"junit.running.info.status.completed.from.total.failed", (Object[])new Object[]{this.myCompleted + offset, this.myTotal, this.myDefects}) : ExecutionBundle.message((String)"junit.running.info.status.completed.from.total", (Object[])new Object[]{this.myCompleted + offset, this.myTotal});
            return testCount;
        }

        private String generateTermMessage(String testCount) {
            switch (this.myDoneEvent.getType()) {
                case DONE: {
                    return ExecutionBundle.message((String)"junit.running.info.status.done.count", (Object[])new Object[]{testCount});
                }
            }
            return ExecutionBundle.message((String)"junit.running.info.status.terminated.count", (Object[])new Object[]{testCount});
        }

        public void setTerminated(SimpleColoredComponent stateLabel) {
            this.myTerminated = true;
            this.updateLabel(stateLabel);
        }
    }
}

