/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.actions;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.ui.actions.LvcsLabeler;
import com.intellij.execution.junit2.ui.actions.RunningTestTracker;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.config.AbstractProperty;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class JUnitToolbarPanel
extends ToolbarPanel {
    @NonNls
    protected static final String TEST_SUITE_CLASS_NAME = "junit.framework.TestSuite";

    public JUnitToolbarPanel(TestConsoleProperties properties, ExecutionEnvironment environment, JComponent parentComponent) {
        super(properties, environment, parentComponent);
    }

    public void setModel(final TestFrameworkRunningModel model) {
        super.setModel(model);
        final JUnitRunningModel jUnitModel = (JUnitRunningModel)model;
        jUnitModel.addListener(new JUnitAdapter(){

            @Override
            public void onRunnerStateChanged(StateEvent event) {
                if (event.isRunning() || !JUnitConsoleProperties.SELECT_FIRST_DEFECT.value((AbstractProperty.AbstractPropertyContainer)jUnitModel.getProperties())) {
                    return;
                }
                AbstractTestProxy firstDefect = Filter.DEFECTIVE_LEAF.detectIn(jUnitModel.getRoot().getAllTests());
                if (firstDefect != null) {
                    jUnitModel.selectAndNotify(firstDefect);
                }
            }
        });
        RunningTestTracker.install(jUnitModel);
        jUnitModel.addListener(new LvcsLabeler(jUnitModel));
        jUnitModel.addListener(new JUnitAdapter(){

            @Override
            public void onTestSelected(TestProxy test) {
                PsiClass aClass;
                if (test == null) {
                    return;
                }
                Project project = jUnitModel.getProject();
                if (!ScrollToTestSourceAction.isScrollEnabled((TestFrameworkRunningModel)model)) {
                    return;
                }
                Location location = test.getInfo().getLocation(project, jUnitModel.getProperties().getScope());
                if (location != null && (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)location.getPsiElement(), PsiClass.class, (boolean)false)) != null && JUnitToolbarPanel.TEST_SUITE_CLASS_NAME.equals(aClass.getQualifiedName())) {
                    return;
                }
                Navigatable descriptor = TestsUIUtil.getOpenFileDescriptor((AbstractTestProxy)test, (TestFrameworkRunningModel)model);
                if (descriptor != null && descriptor.canNavigate()) {
                    descriptor.navigate(false);
                }
            }
        });
    }
}

