/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

@State(name="CoverageViewManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class CoverageViewManager
implements PersistentStateComponent<StateBean> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CoverageViewManager.class.getName()));
    public static final String TOOLWINDOW_ID = "Coverage";
    private Project myProject;
    private final CoverageDataManager myDataManager;
    private ContentManager myContentManager;
    private StateBean myStateBean = new StateBean();
    private Map<String, CoverageView> myViews = new HashMap<String, CoverageView>();
    private boolean myReady;

    public CoverageViewManager(Project project, ToolWindowManager toolWindowManager, CoverageDataManager dataManager) {
        this.myProject = project;
        this.myDataManager = dataManager;
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, true, ToolWindowAnchor.RIGHT, (Disposable)this.myProject);
        toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowCoverage);
        toolWindow.setSplitMode(true, null);
        this.myContentManager = toolWindow.getContentManager();
        new ContentManagerWatcher(toolWindow, this.myContentManager);
    }

    public StateBean getState() {
        return this.myStateBean;
    }

    public void loadState(StateBean state) {
        this.myStateBean = state;
    }

    public CoverageView getToolwindow(CoverageSuitesBundle suitesBundle) {
        return this.myViews.get(CoverageViewManager.getDisplayName(suitesBundle));
    }

    public void activateToolwindow(CoverageView view, boolean requestFocus) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOLWINDOW_ID);
        if (requestFocus) {
            this.myContentManager.setSelectedContent(this.myContentManager.getContent((JComponent)((Object)view)));
            LOG.assertTrue(toolWindow != null);
            toolWindow.activate(null, false);
        }
    }

    public static CoverageViewManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/view/CoverageViewManager", "getInstance"));
        }
        return (CoverageViewManager)ServiceManager.getService((Project)project, CoverageViewManager.class);
    }

    public void createToolWindow(String displayName, boolean defaultFileProvider) {
        this.closeView(displayName);
        CoverageView coverageView = new CoverageView(this.myProject, this.myDataManager, this.myStateBean);
        this.myViews.put(displayName, coverageView);
        Content content = this.myContentManager.getFactory().createContent((JComponent)((Object)coverageView), displayName, true);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        if (CoverageOptionsProvider.getInstance(this.myProject).activateViewOnRun() && defaultFileProvider) {
            this.activateToolwindow(coverageView, true);
        }
    }

    void closeView(String displayName) {
        final CoverageView oldView = this.myViews.get(displayName);
        if (oldView != null) {
            final Content content = this.myContentManager.getContent((JComponent)((Object)oldView));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (content != null) {
                        CoverageViewManager.this.myContentManager.removeContent(content, true);
                    }
                    Disposer.dispose((Disposable)oldView);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable);
        }
        this.setReady(false);
    }

    public boolean isReady() {
        return this.myReady;
    }

    public void setReady(boolean ready) {
        this.myReady = ready;
    }

    public static String getDisplayName(CoverageSuitesBundle suitesBundle) {
        RunConfigurationBase configuration = suitesBundle.getRunConfiguration();
        return configuration != null ? configuration.getName() : suitesBundle.getPresentableName();
    }

    public static class StateBean {
        public boolean myFlattenPackages = false;
        public boolean myAutoScrollToSource = false;
        public boolean myAutoScrollFromSource = false;
    }
}

