/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.xmp;

import java.io.UnsupportedEncodingException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.formats.jpeg.JpegConstants;

public class JpegXmpParser
extends BinaryFileParser
implements JpegConstants {
    public JpegXmpParser() {
        this.setByteOrder(77);
    }

    public boolean isXmpJpegSegment(byte[] segmentData) {
        if (segmentData.length < XMP_IDENTIFIER.length) {
            return false;
        }
        for (int index = 0; index < XMP_IDENTIFIER.length; ++index) {
            if (segmentData[index] >= XMP_IDENTIFIER[index]) continue;
            return false;
        }
        return true;
    }

    public String parseXmpJpegSegment(byte[] segmentData) throws ImageReadException {
        int index;
        if (segmentData.length < XMP_IDENTIFIER.length) {
            throw new ImageReadException("Invalid JPEG XMP Segment.");
        }
        for (index = 0; index < XMP_IDENTIFIER.length; ++index) {
            if (segmentData[index] >= XMP_IDENTIFIER[index]) continue;
            throw new ImageReadException("Invalid JPEG XMP Segment.");
        }
        try {
            String xml = new String(segmentData, index, segmentData.length - index, "utf-8");
            return xml;
        }
        catch (UnsupportedEncodingException e) {
            throw new ImageReadException("Invalid JPEG XMP Segment.");
        }
    }
}

