/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VariableTypeFromCallFix
implements IntentionAction {
    private final PsiType myExpressionType;
    private final PsiVariable myVar;

    private VariableTypeFromCallFix(@NotNull PsiClassType type, @NotNull PsiVariable var) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "<init>"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "<init>"));
        }
        this.myExpressionType = type;
        this.myVar = var;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.variable.type.text", UsageViewUtil.getType((PsiElement)this.myVar), this.myVar.getName(), this.myExpressionType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.variable.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "isAvailable"));
        }
        return this.myExpressionType.isValid() && this.myVar.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "invoke"));
        }
        TypeMigrationRules rules = new TypeMigrationRules(TypeMigrationLabeler.getElementType((PsiElement)this.myVar));
        rules.setMigrationRootType(this.myExpressionType);
        rules.setBoundScope(PsiSearchHelper.SERVICE.getInstance((Project)project).getUseScope((PsiElement)this.myVar));
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, (PsiElement)this.myVar);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public static List<IntentionAction> getQuickFixActions(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList list) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getQuickFixActions"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getQuickFixActions"));
        }
        JavaResolveResult result = methodCall.getMethodExpression().advancedResolve(false);
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions = list.getExpressions();
        if (method == null || method.getParameterList().getParametersCount() != expressions.length) {
            List<IntentionAction> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getQuickFixActions"));
            }
            return list2;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (int i = 0; i < expressions.length; ++i) {
            PsiElement resolved;
            PsiParameter parameter;
            PsiType formalParamType;
            PsiType parameterType;
            PsiExpression expression = expressions[i];
            PsiType expressionType = expression.getType();
            if (expressionType instanceof PsiPrimitiveType) {
                expressionType = ((PsiPrimitiveType)expressionType).getBoxedType((PsiElement)expression);
            }
            if (expressionType == null || (parameterType = substitutor.substitute(formalParamType = (parameter = parameters[i]).getType())).isAssignableFrom(expressionType)) continue;
            PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiVariable) {
                PsiType varType = ((PsiVariable)resolved).getType();
                PsiClass varClass = PsiUtil.resolveClassInType((PsiType)varType);
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
                if (varClass != null) {
                    PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(varClass.getTypeParameters(), parameters, expressions, PsiSubstitutor.EMPTY, resolved, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                    PsiClassType appropriateVarType = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createType(varClass, psiSubstitutor);
                    if (varType.equals(appropriateVarType)) break;
                    actions.add(new VariableTypeFromCallFix(appropriateVarType, (PsiVariable)resolved));
                    break;
                }
            }
            actions.addAll(VariableTypeFromCallFix.getParameterTypeChangeFixes(method, expression, parameterType));
        }
        ArrayList<IntentionAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getQuickFixActions"));
        }
        return arrayList;
    }

    private static List<IntentionAction> getParameterTypeChangeFixes(@NotNull PsiMethod method, @NotNull PsiExpression expression, PsiType parameterType) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getParameterTypeChangeFixes"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFromCallFix", "getParameterTypeChangeFixes"));
        }
        if (!(expression instanceof PsiReferenceExpression)) {
            return Collections.emptyList();
        }
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        PsiManager manager = method.getManager();
        if (manager.isInProject((PsiElement)method)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method.findDeepestSuperMethods()) {
                if (manager.isInProject((PsiElement)superMethod)) continue;
                return Collections.emptyList();
            }
            PsiElement resolve = ((PsiReferenceExpression)expression).resolve();
            if (resolve instanceof PsiVariable) {
                result.addAll(HighlightUtil.getChangeVariableTypeFixes((PsiVariable)resolve, parameterType));
            }
        }
        return result;
    }
}

