/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private boolean needToInsertQuotes = false;

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (c == '=' && WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && (file.getLanguage() instanceof XMLLanguage || file.getViewProvider().getBaseLanguage() instanceof XMLLanguage)) {
            PsiElement atParent;
            TypedHandler.commitDocumentIfCurrentCaretIsNotTheFirstOne(editor, project);
            PsiElement at = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            PsiElement psiElement = atParent = at != null ? at.getParent() : null;
            if (atParent instanceof XmlAttribute && ((XmlAttribute)atParent).getValueElement() == null) {
                this.needToInsertQuotes = ((XmlAttribute)atParent).getValueElement() == null;
            }
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "charTyped"));
        }
        if (this.needToInsertQuotes) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement fileContext = file.getContext();
            String toInsert = "\"\"";
            if (fileContext != null && fileContext.getText().startsWith("\"")) {
                toInsert = "''";
            }
            editor.getDocument().insertString(offset, (CharSequence)toInsert);
            editor.getCaretModel().moveToOffset(offset + 1);
            AutoPopupController.getInstance(project).scheduleAutoPopup(editor);
        }
        this.needToInsertQuotes = false;
        return super.charTyped(c, project, editor, file);
    }
}

