/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class TemplateBuilderImpl
implements TemplateBuilder {
    private final RangeMarker myContainerElement;
    private final Map<RangeMarker, Expression> myExpressions;
    private final Map<RangeMarker, String> myVariableExpressions;
    private final Map<RangeMarker, Boolean> myAlwaysStopAtMap;
    private final Map<RangeMarker, Boolean> mySkipOnStartMap;
    private final Map<RangeMarker, String> myVariableNamesMap;
    private final Set<RangeMarker> myElements;
    private RangeMarker myEndElement;
    private RangeMarker mySelection;
    private final Document myDocument;
    private final PsiFile myFile;
    private static final Logger LOG = Logger.getInstance((String)("#" + TemplateBuilderImpl.class.getName()));

    public TemplateBuilderImpl(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/TemplateBuilderImpl", "<init>"));
        }
        this.myExpressions = new HashMap<RangeMarker, Expression>();
        this.myVariableExpressions = new HashMap<RangeMarker, String>();
        this.myAlwaysStopAtMap = new HashMap<RangeMarker, Boolean>();
        this.mySkipOnStartMap = new HashMap<RangeMarker, Boolean>();
        this.myVariableNamesMap = new HashMap<RangeMarker, String>();
        this.myElements = new TreeSet<RangeMarker>(RangeMarker.BY_START_OFFSET);
        this.myFile = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element);
        this.myDocument = this.myFile.getViewProvider().getDocument();
        this.myContainerElement = this.wrapElement(element);
    }

    public void replaceElement(PsiElement element, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.replaceElement(key, expression);
    }

    private RangeMarker wrapElement(PsiElement element) {
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        return this.myDocument.createRangeMarker(range);
    }

    private RangeMarker wrapReference(PsiReference ref) {
        PsiElement element = ref.getElement();
        return this.myDocument.createRangeMarker(ref.getRangeInElement().shiftRight(InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).injectedToHost(element, element.getTextRange().getStartOffset())));
    }

    public void replaceElement(PsiElement element, String varName, Expression expression, boolean alwaysStopAt) {
        this.replaceElement(element, varName, expression, alwaysStopAt, false);
    }

    public void replaceElement(PsiReference ref, String varName, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.replaceElement(key, expression);
    }

    private void replaceElement(RangeMarker key, Expression expression) {
        this.myExpressions.put(key, expression);
        this.myElements.add(key);
    }

    public void replaceElement(PsiElement element, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.myVariableExpressions.put(key, dependantVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(PsiReference ref, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.myVariableExpressions.put(key, dependantVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(PsiElement element, TextRange textRange, String primaryVariableName, String otherVariableName, boolean alwaysStopAt) {
        TextRange elementTextRange = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        RangeMarker key = this.myDocument.createRangeMarker(textRange.shiftRight(elementTextRange.getStartOffset()));
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, primaryVariableName);
        this.myVariableExpressions.put(key, otherVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(@NotNull PsiElement element, Expression expression) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/TemplateBuilderImpl", "replaceElement"));
        }
        RangeMarker key = this.wrapElement(element);
        this.replaceElement(key, expression);
    }

    public void replaceElement(@NotNull PsiElement element, TextRange rangeWithinElement, Expression expression) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/TemplateBuilderImpl", "replaceElement"));
        }
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(element.getTextRange().getStartOffset()));
        this.replaceElement(key, expression);
    }

    public void replaceRange(TextRange rangeWithinElement, String replacementText) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        ConstantNode value = new ConstantNode(replacementText);
        this.replaceElement(key, (Expression)value);
    }

    public void replaceRange(TextRange rangeWithinElement, Expression expression) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement);
        this.replaceElement(key, expression);
    }

    public void setEndVariableAfter(PsiElement element) {
        element = element.getNextSibling();
        this.setEndVariableBefore(element);
    }

    public void setEndVariableBefore(PsiElement element) {
        if (this.myEndElement != null) {
            this.myElements.remove(this.myEndElement);
        }
        this.myEndElement = this.wrapElement(element);
        this.myElements.add(this.myEndElement);
    }

    public void setSelection(PsiElement element) {
        this.mySelection = this.wrapElement(element);
        this.myElements.add(this.mySelection);
    }

    public Template buildInlineTemplate() {
        Template template = this.buildTemplate();
        template.setInline(true);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (RangeMarker element : this.myElements) {
            if (element == this.myEndElement) continue;
            this.myDocument.deleteString(element.getStartOffset(), element.getEndOffset());
        }
        return template;
    }

    public Template buildTemplate() {
        String variableName;
        Expression expression;
        boolean alwaysStopAt;
        Boolean stop;
        TemplateManager manager = TemplateManager.getInstance(this.myFile.getProject());
        Template template = manager.createTemplate("", "");
        String text = this.getDocumentTextFragment(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset());
        int containerStart = this.myContainerElement.getStartOffset();
        int start = 0;
        for (RangeMarker element : this.myElements) {
            int offset = element.getStartOffset() - containerStart;
            if (start > offset) {
                LOG.error("file: " + this.myFile + " container: " + this.myContainerElement + " markers: " + StringUtil.join(this.myElements, (Function)new Function<RangeMarker, String>(){

                    public String fun(RangeMarker rangeMarker) {
                        String docString = TemplateBuilderImpl.this.myDocument.getText(new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
                        return "[[" + docString + "]" + rangeMarker.getStartOffset() + ", " + rangeMarker.getEndOffset() + "]";
                    }
                }, (String)", "));
            }
            template.addTextSegment(text.substring(start, offset));
            if (element == this.mySelection) {
                template.addSelectionStartVariable();
                template.addTextSegment(this.getDocumentTextFragment(this.mySelection.getStartOffset(), this.mySelection.getEndOffset()));
                template.addSelectionEndVariable();
            } else {
                if (element == this.myEndElement) {
                    template.addEndVariable();
                    start = offset;
                    continue;
                }
                stop = this.myAlwaysStopAtMap.get(element);
                alwaysStopAt = stop == null || stop != false;
                expression = this.myExpressions.get(element);
                String string = variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression.hashCode()) : this.myVariableNamesMap.get(element);
                if (expression != null) {
                    Boolean skipOnStart = this.mySkipOnStartMap.get(element);
                    template.addVariable(variableName, expression, expression, alwaysStopAt, skipOnStart != null && skipOnStart != false);
                } else {
                    template.addVariableSegment(variableName);
                }
            }
            start = element.getEndOffset() - containerStart;
        }
        template.addTextSegment(text.substring(start));
        for (RangeMarker element : this.myElements) {
            String dependantVariable = this.myVariableExpressions.get(element);
            if (dependantVariable == null) continue;
            stop = this.myAlwaysStopAtMap.get(element);
            alwaysStopAt = stop == null || stop != false;
            expression = this.myExpressions.get(element);
            variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression.hashCode()) : this.myVariableNamesMap.get(element);
            template.addVariable(variableName, dependantVariable, dependantVariable, alwaysStopAt);
        }
        template.setToIndent(false);
        template.setToReformat(false);
        return template;
    }

    private String getDocumentTextFragment(int startOffset, int endOffset) {
        return this.myDocument.getCharsSequence().subSequence(startOffset, endOffset).toString();
    }

    public void replaceElement(@NotNull PsiElement element, String replacementText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/TemplateBuilderImpl", "replaceElement"));
        }
        this.replaceElement(element, (Expression)new ConstantNode(replacementText));
    }

    public void replaceElement(@NotNull PsiElement element, TextRange rangeWithinElement, String replacementText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/TemplateBuilderImpl", "replaceElement"));
        }
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(element.getTextRange().getStartOffset()));
        ConstantNode value = new ConstantNode(replacementText);
        this.replaceElement(key, (Expression)value);
    }

    public void run() {
        Project project = this.myFile.getProject();
        VirtualFile file = this.myFile.getVirtualFile();
        assert (file != null) : "Virtual file is null for " + this.myFile;
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file);
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        assert (editor != null) : "Editor is null";
        this.run(editor, false);
    }

    public void run(@NotNull Editor editor, boolean inline) {
        Template template;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/TemplateBuilderImpl", "run"));
        }
        if (inline) {
            template = this.buildInlineTemplate();
        } else {
            template = this.buildTemplate();
            editor.getDocument().replaceString(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset(), (CharSequence)"");
        }
        editor.getCaretModel().moveToOffset(this.myContainerElement.getStartOffset());
        TemplateManager.getInstance(this.myFile.getProject()).startTemplate(editor, template);
    }

    public void replaceElement(PsiElement element, String varName, Expression expression, boolean alwaysStopAt, boolean skipOnStart) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.mySkipOnStartMap.put(key, skipOnStart);
        this.replaceElement(key, expression);
    }
}

