/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StandardDataFlowRunner
extends DataFlowRunner {
    private final Set<Instruction> myCCEInstructions = new HashSet<Instruction>();

    public StandardDataFlowRunner() {
        this(false, true);
    }

    public StandardDataFlowRunner(boolean unknownMembersAreNullable, boolean honorFieldInitializers) {
        super(unknownMembersAreNullable, honorFieldInitializers);
    }

    public void onInstructionProducesCCE(Instruction instruction) {
        this.myCCEInstructions.add(instruction);
    }

    @NotNull
    public Set<Instruction> getCCEInstructions() {
        Set<Instruction> set = this.myCCEInstructions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardDataFlowRunner", "getCCEInstructions"));
        }
        return set;
    }

    @NotNull
    public static Set<Instruction> getRedundantInstanceofs(DataFlowRunner runner, StandardInstructionVisitor visitor) {
        HashSet<Instruction> result = new HashSet<Instruction>(1);
        for (Instruction instruction : runner.getInstructions()) {
            if (!(instruction instanceof InstanceofInstruction) || !visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) continue;
            result.add(instruction);
        }
        HashSet<Instruction> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardDataFlowRunner", "getRedundantInstanceofs"));
        }
        return hashSet;
    }
}

