/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefDirectoryImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefManagerImpl
extends RefManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.reference.RefManager");
    private long myLastUsedMask;
    @NotNull
    private final Project myProject;
    private AnalysisScope myScope;
    private RefProject myRefProject;
    private final Map<PsiAnchor, RefElement> myRefTable;
    private final ConcurrentMap<Module, RefModule> myModules;
    private final ProjectIterator myProjectIterator;
    private volatile boolean myDeclarationsFound;
    private final PsiManager myPsiManager;
    private volatile boolean myIsInProcess;
    private final List<RefGraphAnnotator> myGraphAnnotators;
    private GlobalInspectionContext myContext;
    private final Map<Key, RefManagerExtension> myExtensions;
    private final Map<Language, RefManagerExtension> myLanguageExtensions;

    public RefManagerImpl(@NotNull Project project, @Nullable AnalysisScope scope, @NotNull GlobalInspectionContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/reference/RefManagerImpl", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/reference/RefManagerImpl", "<init>"));
        }
        this.myLastUsedMask = 0x8000000L;
        this.myRefTable = new THashMap();
        this.myModules = ContainerUtil.newConcurrentMap();
        this.myProjectIterator = new ProjectIterator();
        this.myGraphAnnotators = new ArrayList<RefGraphAnnotator>();
        this.myExtensions = new THashMap();
        this.myLanguageExtensions = new HashMap<Language, RefManagerExtension>();
        this.myProject = project;
        this.myScope = scope;
        this.myContext = context;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myRefProject = new RefProjectImpl(this);
        for (InspectionExtensionsFactory inspectionExtensionsFactory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            RefManagerExtension extension = inspectionExtensionsFactory.createRefManagerExtension((RefManager)this);
            if (extension == null) continue;
            this.myExtensions.put(extension.getID(), extension);
            this.myLanguageExtensions.put(extension.getLanguage(), extension);
        }
        if (scope != null) {
            for (InspectionExtensionsFactory inspectionExtensionsFactory : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                this.getRefModule((Module)inspectionExtensionsFactory);
            }
        }
    }

    @NotNull
    public GlobalInspectionContext getContext() {
        GlobalInspectionContext globalInspectionContext = this.myContext;
        if (globalInspectionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefManagerImpl", "getContext"));
        }
        return globalInspectionContext;
    }

    public void iterate(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefManagerImpl", "iterate"));
        }
        for (RefElement refElement : this.getSortedElements()) {
            refElement.accept(visitor);
        }
        if (this.myModules != null) {
            for (RefModule refModule : this.myModules.values()) {
                refModule.accept(visitor);
            }
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.iterate(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.myScope = null;
        this.myRefProject = null;
        Map<PsiAnchor, RefElement> map = this.myRefTable;
        synchronized (map) {
            this.myRefTable.clear();
        }
        this.myModules.clear();
        this.myContext = null;
        this.myGraphAnnotators.clear();
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
    }

    @Nullable
    public AnalysisScope getScope() {
        return this.myScope;
    }

    public void fireNodeInitialized(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onInitialize(refElement);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting);
        }
    }

    public void fireNodeMarkedReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(what, from, referencedFromClassInitializer);
        }
    }

    public void fireBuildReferences(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onReferencesBuild(refElement);
        }
    }

    public void registerGraphAnnotator(@NotNull RefGraphAnnotator annotator) {
        if (annotator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/codeInspection/reference/RefManagerImpl", "registerGraphAnnotator"));
        }
        this.myGraphAnnotators.add(annotator);
    }

    public long getLastUsedMask() {
        this.myLastUsedMask *= 2L;
        return this.myLastUsedMask;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/reference/RefManagerImpl", "getExtension"));
        }
        return (T)this.myExtensions.get(key);
    }

    @Nullable
    public String getType(RefEntity ref) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String type = extension.getType(ref);
            if (type == null) continue;
            return type;
        }
        if (ref instanceof RefFile) {
            return "file";
        }
        if (ref instanceof RefModule) {
            return "module";
        }
        if (ref instanceof RefProject) {
            return "project";
        }
        if (ref instanceof RefDirectory) {
            return "dir";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInspection/reference/RefManagerImpl", "getRefinedElement"));
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            ref = extension.getRefinedElement(ref);
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefManagerImpl", "getRefinedElement"));
        }
        return refEntity;
    }

    public Element export(@NotNull RefEntity refEntity, @NotNull Element element, int actualLine) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/reference/RefManagerImpl", "export"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reference/RefManagerImpl", "export"));
        }
        refEntity = this.getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            SmartPsiElementPointer pointer = refElement.getPointer();
            PsiFile psiFile = pointer.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            Element fileElement = new Element("file");
            Element lineElement = new Element("line");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance((Project)pointer.getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                Segment range = pointer.getRange();
                lineElement.addContent(String.valueOf(range != null ? document.getLineNumber(range.getStartOffset()) + 1 : -1));
            } else {
                lineElement.addContent(String.valueOf(actualLine));
            }
            problem.addContent(fileElement);
            problem.addContent(lineElement);
            RefManagerImpl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            RefManagerImpl.appendModule(problem, refModule);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.export(refEntity, problem);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        element.addContent(problem);
        return problem;
    }

    @Nullable
    public String getGroupName(RefElement entity) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String groupName = extension.getGroupName((RefEntity)entity);
            if (groupName == null) continue;
            return groupName;
        }
        return null;
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    public void findAllDeclarations() {
        if (!this.myDeclarationsFound) {
            long before = System.currentTimeMillis();
            AnalysisScope scope = this.getScope();
            if (scope != null) {
                scope.accept((PsiElementVisitor)this.myProjectIterator);
            }
            this.myDeclarationsFound = true;
            LOG.info("Total duration of processing project usages:" + (System.currentTimeMillis() - before));
        }
    }

    public boolean isDeclarationsFound() {
        return this.myDeclarationsFound;
    }

    public void inspectionReadActionStarted() {
        this.myIsInProcess = true;
    }

    public void inspectionReadActionFinished() {
        this.myIsInProcess = false;
    }

    public boolean isInProcess() {
        return this.myIsInProcess;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefManagerImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public RefProject getRefProject() {
        RefProject refProject = this.myRefProject;
        if (refProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefManagerImpl", "getRefProject"));
        }
        return refProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RefElement> getSortedElements() {
        ArrayList<RefElement> answer;
        Map<PsiAnchor, RefElement> map = this.myRefTable;
        synchronized (map) {
            answer = new ArrayList<RefElement>(this.myRefTable.values());
        }
        ContainerUtil.quickSort(answer, (Comparator)new Comparator<RefElement>(){

            @Override
            public int compare(RefElement o1, RefElement o2) {
                VirtualFile v1 = ((RefElementImpl)o1).getVirtualFile();
                VirtualFile v2 = ((RefElementImpl)o2).getVirtualFile();
                return (v1 != null ? v1.hashCode() : 0) - (v2 != null ? v2.hashCode() : 0);
            }
        });
        ArrayList<RefElement> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefManagerImpl", "getSortedElements"));
        }
        return arrayList;
    }

    @NotNull
    public PsiManager getPsiManager() {
        PsiManager psiManager = this.myPsiManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefManagerImpl", "getPsiManager"));
        }
        return psiManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReference(@NotNull RefElement refElem) {
        RefManagerExtension extension;
        if (refElem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElem", "com/intellij/codeInspection/reference/RefManagerImpl", "removeReference"));
        }
        PsiElement element = refElem.getElement();
        RefManagerExtension refManagerExtension = extension = element != null ? this.getExtension(element.getLanguage()) : null;
        if (extension != null) {
            extension.removeReference(refElem);
        }
        Map<PsiAnchor, RefElement> map = this.myRefTable;
        synchronized (map) {
            if (element != null && this.myRefTable.remove(RefManagerImpl.createAnchor(element)) != null) {
                return;
            }
            for (Map.Entry<PsiAnchor, RefElement> entry : this.myRefTable.entrySet()) {
                RefElement value = entry.getValue();
                PsiAnchor anchor = entry.getKey();
                if (value != refElem) continue;
                this.myRefTable.remove(anchor);
                break;
            }
        }
    }

    @NotNull
    private static PsiAnchor createAnchor(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reference/RefManagerImpl", "createAnchor"));
        }
        PsiAnchor psiAnchor = (PsiAnchor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnchor>(){

            public PsiAnchor compute() {
                return PsiAnchor.create(element);
            }
        });
        if (psiAnchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefManagerImpl", "createAnchor"));
        }
        return psiAnchor;
    }

    public void initializeAnnotators() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.refGraphAnnotator");
        RefGraphAnnotator[] graphAnnotators = (RefGraphAnnotator[])point.getExtensions();
        for (RefGraphAnnotator annotator : graphAnnotators) {
            this.registerGraphAnnotator(annotator);
        }
        for (RefGraphAnnotator graphAnnotator : this.myGraphAnnotators) {
            if (!(graphAnnotator instanceof RefGraphAnnotatorEx)) continue;
            ((RefGraphAnnotatorEx)graphAnnotator).initialize((RefManager)this);
        }
    }

    @Nullable
    public RefElement getReference(PsiElement elem) {
        return this.getReference(elem, false);
    }

    @Nullable
    public RefElement getReference(final PsiElement elem, final boolean ignoreScope) {
        if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return elem == null || !elem.isValid() || elem instanceof LightElement || !(elem instanceof PsiDirectory) && !RefManagerImpl.this.belongsToScope(elem, ignoreScope);
            }
        })).booleanValue()) {
            return null;
        }
        return this.getFromRefTableOrCache(elem, new NullableFactory<RefElementImpl>(){

            public RefElementImpl create() {
                return (RefElementImpl)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RefElementImpl>(){

                    @Nullable
                    public RefElementImpl compute() {
                        RefElement refElement;
                        RefManagerExtension extension = RefManagerImpl.this.getExtension(elem.getLanguage());
                        if (extension != null && (refElement = extension.createRefElement(elem)) != null) {
                            return (RefElementImpl)refElement;
                        }
                        if (elem instanceof PsiFile) {
                            return new RefFileImpl((PsiFile)elem, (RefManager)RefManagerImpl.this);
                        }
                        if (elem instanceof PsiDirectory) {
                            return new RefDirectoryImpl((PsiDirectory)elem, (RefManager)RefManagerImpl.this);
                        }
                        return null;
                    }
                });
            }
        }, new Consumer<RefElementImpl>(){

            public void consume(RefElementImpl element) {
                element.initialize();
                for (RefManagerExtension each : RefManagerImpl.this.myExtensions.values()) {
                    each.onEntityInitialized((RefElement)element, elem);
                }
                RefManagerImpl.this.fireNodeInitialized(element);
            }
        });
    }

    private RefManagerExtension getExtension(Language language) {
        return this.myLanguageExtensions.get(language);
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            RefEntity refEntity = extension.getReference(type, fqName);
            if (refEntity == null) continue;
            return refEntity;
        }
        if ("file".equals(type)) {
            return RefFileImpl.fileFromExternalName(this, fqName);
        }
        if ("module".equals(type)) {
            return RefModuleImpl.moduleFromName(this, fqName);
        }
        if ("project".equals(type)) {
            return this.getRefProject();
        }
        if ("dir".equals(type)) {
            String url = VfsUtilCore.pathToUrl((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(fqName));
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile != null) {
                PsiDirectory dir = PsiManager.getInstance((Project)this.getProject()).findDirectory(vFile);
                return this.getReference((PsiElement)dir);
            }
        }
        return null;
    }

    @Nullable
    protected <T extends RefElement> T getFromRefTableOrCache(PsiElement element, @NotNull NullableFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInspection/reference/RefManagerImpl", "getFromRefTableOrCache"));
        }
        return this.getFromRefTableOrCache(element, factory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T extends RefElement> T getFromRefTableOrCache(PsiElement element, @NotNull NullableFactory<T> factory, @Nullable Consumer<T> whenCached) {
        RefElement result;
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInspection/reference/RefManagerImpl", "getFromRefTableOrCache"));
        }
        PsiAnchor psiAnchor = RefManagerImpl.createAnchor(element);
        Map<PsiAnchor, RefElement> map = this.myRefTable;
        synchronized (map) {
            result = this.myRefTable.get(psiAnchor);
            if (result != null) {
                return (T)result;
            }
            if (!this.isValidPointForReference()) {
                return null;
            }
            result = (RefElement)factory.create();
            if (result == null) {
                return null;
            }
            this.myRefTable.put(psiAnchor, result);
        }
        if (whenCached != null) {
            whenCached.consume((Object)result);
        }
        return (T)result;
    }

    public RefModule getRefModule(Module module) {
        if (module == null) {
            return null;
        }
        RefModule refModule = (RefModule)this.myModules.get(module);
        if (refModule == null) {
            refModule = (RefModule)ConcurrencyUtil.cacheOrGet(this.myModules, (Object)module, (Object)new RefModuleImpl(module, (RefManager)this));
        }
        return refModule;
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return this.belongsToScope(psiElement, false);
    }

    private boolean belongsToScope(final PsiElement psiElement, boolean ignoreScope) {
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return false;
        }
        PsiFile containingFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return psiElement.getContainingFile();
            }
        });
        if (containingFile == null) {
            return false;
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            if (extension.belongsToScope(psiElement)) continue;
            return false;
        }
        Boolean inProject = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return psiElement.getManager().isInProject(psiElement);
            }
        });
        return inProject != false && (ignoreScope || this.getScope() == null || this.getScope().contains(psiElement));
    }

    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity == null || refEntity instanceof RefElementImpl && !refEntity.isValid()) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return refEntity.getQualifiedName();
    }

    public void removeRefElement(@NotNull RefElement refElement, @NotNull List<RefElement> deletedRefs) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/reference/RefManagerImpl", "removeRefElement"));
        }
        if (deletedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deletedRefs", "com/intellij/codeInspection/reference/RefManagerImpl", "removeRefElement"));
        }
        List children = refElement.getChildren();
        if (children != null) {
            RefElement[] refElements;
            for (RefElement refChild : refElements = children.toArray(new RefElement[children.size()])) {
                this.removeRefElement(refChild, deletedRefs);
            }
        }
        ((RefManagerImpl)refElement.getRefManager()).removeReference(refElement);
        ((RefElementImpl)refElement).referenceRemoved();
        if (!deletedRefs.contains(refElement)) {
            deletedRefs.add(refElement);
        }
    }

    protected boolean isValidPointForReference() {
        return this.myIsInProcess || ApplicationManager.getApplication().isUnitTestMode();
    }

    private class ProjectIterator
    extends PsiElementVisitor {
        private ProjectIterator() {
        }

        public void visitElement(PsiElement element) {
            RefManagerExtension extension = RefManagerImpl.this.getExtension(element.getLanguage());
            if (extension != null) {
                extension.visitElement(element);
            }
            for (PsiElement aChildren : element.getChildren()) {
                aChildren.accept((PsiElementVisitor)this);
            }
        }

        public void visitFile(PsiFile file) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                String relative = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)RefManagerImpl.this.myProject, (boolean)true, (boolean)false);
                RefManagerImpl.this.myContext.incrementJobDoneAmount(((RefManagerImpl)RefManagerImpl.this).myContext.getStdJobDescriptors().BUILD_GRAPH, relative);
            }
            FileViewProvider viewProvider = file.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                this.visitElement((PsiElement)viewProvider.getPsi(language));
            }
            RefManagerImpl.this.myPsiManager.dropResolveCaches();
            InjectedLanguageManager.getInstance((Project)RefManagerImpl.this.myProject).dropFileCaches(file);
        }
    }
}

