/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.BinaryContentPanel;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryDiffViewer
extends ListenerDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(BinaryDiffViewer.class);
    @NotNull
    private final SimpleDiffPanel myPanel;
    @NotNull
    private final BinaryContentPanel myContentPanel;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @Nullable
    private final FileEditor myEditor1;
    @Nullable
    private final FileEditor myEditor2;
    @Nullable
    private final FileEditorProvider myEditorProvider1;
    @Nullable
    private final FileEditorProvider myEditorProvider2;
    @NotNull
    private final FocusTrackerSupport.TwosideFocusTrackerSupport myFocusTrackerSupport;

    public BinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/BinaryDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        List<JComponent> titlePanel = DiffUtil.createSimpleTitles(this.myRequest);
        Couple<Pair<FileEditor, FileEditorProvider>> editors = this.createEditors();
        this.myEditor1 = (FileEditor)((Pair)editors.first).first;
        this.myEditorProvider1 = (FileEditorProvider)((Pair)editors.first).second;
        this.myEditor2 = (FileEditor)((Pair)editors.second).first;
        this.myEditorProvider2 = (FileEditorProvider)((Pair)editors.second).second;
        assert (this.myEditor1 != null || this.myEditor2 != null);
        this.myFocusTrackerSupport = new FocusTrackerSupport.TwosideFocusTrackerSupport(this.getEditor1(), this.getEditor2());
        this.myContentPanel = new BinaryContentPanel(titlePanel, this.getEditor1(), this.getEditor2());
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
        this.myStatusPanel = new MyStatusPanel();
        new MyFocusOppositePaneAction().setupAction(this.myPanel);
    }

    @Override
    public void onDispose() {
        this.destroyEditors();
        super.onDispose();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @NotNull
    protected Couple<Pair<FileEditor, FileEditorProvider>> createEditors() {
        Couple couple;
        List contents = this.myRequest.getContents();
        try {
            Pair<FileEditor, FileEditorProvider> pair1 = this.createEditor((DiffContent)contents.get(0));
            Pair<FileEditor, FileEditorProvider> pair2 = this.createEditor((DiffContent)contents.get(1));
            couple = Couple.of(pair1, pair2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            Pair empty = Pair.empty();
            Couple couple2 = Couple.of((Object)empty, (Object)empty);
            if (couple2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditors"));
            }
            return couple2;
        }
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditors"));
        }
        return couple;
    }

    @NotNull
    private Pair<FileEditor, FileEditorProvider> createEditor(@NotNull DiffContent content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
        }
        if (content instanceof EmptyContent) {
            Pair pair = Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
            }
            return pair;
        }
        if (content instanceof FileContent) {
            Project project = this.myProject != null ? this.myProject : ProjectManager.getInstance().getDefaultProject();
            VirtualFile file = ((FileContent)content).getFile();
            FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project, file);
            if (providers.length == 0) {
                throw new IOException("Can't find FileEditorProvider");
            }
            FileEditorProvider provider = providers[0];
            FileEditor editor = provider.createEditor(project, file);
            UIUtil.removeScrollBorder((Component)editor.getComponent());
            Pair pair = Pair.create((Object)editor, (Object)provider);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
            }
            return pair;
        }
        if (content instanceof DocumentContent) {
            Document document = ((DocumentContent)content).getDocument();
            final EditorEx editor = DiffUtil.createEditor(document, this.myProject, true);
            TextEditorProvider provider = TextEditorProvider.getInstance();
            TextEditor fileEditor = provider.getTextEditor(editor);
            Disposer.register((Disposable)fileEditor, (Disposable)new Disposable(){

                public void dispose() {
                    EditorFactory.getInstance().releaseEditor(editor);
                }
            });
            Pair pair = Pair.create((Object)fileEditor, (Object)provider);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
            }
            return pair;
        }
        throw new IllegalArgumentException(content.getClass() + " - " + content.toString());
    }

    private void destroyEditors() {
        if (this.getEditor1() != null) {
            assert (this.myEditorProvider1 != null);
            this.myEditorProvider1.disposeEditor(this.getEditor1());
        }
        if (this.getEditor2() != null) {
            assert (this.myEditorProvider2 != null);
            this.myEditorProvider2.disposeEditor(this.getEditor2());
        }
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        VirtualFile file2;
        VirtualFile file1;
        block18: {
            List contents;
            block17: {
                block16: {
                    block15: {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                        }
                        indicator.checkCanceled();
                        contents = this.myRequest.getContents();
                        if (!(contents.get(0) instanceof EmptyContent)) break block15;
                        Runnable runnable2 = this.applyNotification(DiffNotifications.INSERTED_CONTENT);
                        if (runnable2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                        }
                        return runnable2;
                    }
                    if (!(contents.get(1) instanceof EmptyContent)) break block16;
                    Runnable runnable3 = this.applyNotification(DiffNotifications.REMOVED_CONTENT);
                    if (runnable3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                    }
                    return runnable3;
                }
                if (contents.get(0) instanceof FileContent && contents.get(1) instanceof FileContent) break block17;
                Runnable runnable4 = this.applyNotification(null);
                if (runnable4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                }
                return runnable4;
            }
            file1 = ((FileContent)contents.get(0)).getFile();
            file2 = ((FileContent)contents.get(1)).getFile();
            if (file1.isValid() && file2.isValid()) break block18;
            Runnable runnable5 = this.applyNotification(DiffNotifications.ERROR);
            if (runnable5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
            }
            return runnable5;
        }
        try {
            boolean equal = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    try {
                        byte[] bytes1 = file1.contentsToByteArray();
                        byte[] bytes2 = file2.contentsToByteArray();
                        return Arrays.equals(bytes1, bytes2);
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        return false;
                    }
                }
            });
            runnable = this.applyNotification(equal ? DiffNotifications.EQUAL_CONTENTS : null);
        }
        catch (ProcessCanceledException ignore) {
            Runnable runnable6 = this.applyNotification(DiffNotifications.OPERATION_CANCELED);
            if (runnable6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
            }
            return runnable6;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable7 = this.applyNotification(DiffNotifications.ERROR);
            if (runnable7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
            }
            return runnable7;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
        }
        return runnable;
    }

    @NotNull
    private Runnable applyNotification(final @Nullable JComponent notification) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BinaryDiffViewer.this.clearDiffPresentation();
                if (notification != null) {
                    BinaryDiffViewer.this.myPanel.addNotification(notification);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "applyNotification"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "getComponent"));
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getCurrentEditor().getPreferredFocusedComponent();
    }

    @NotNull
    public Side getCurrentSide() {
        Side side = this.myFocusTrackerSupport.getCurrentSide();
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "getCurrentSide"));
        }
        return side;
    }

    public void setCurrentSide(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/binary/BinaryDiffViewer", "setCurrentSide"));
        }
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    @Nullable
    FileEditor getEditor2() {
        return this.myEditor2;
    }

    @Nullable
    FileEditor getEditor1() {
        return this.myEditor1;
    }

    @NotNull
    FileEditor getCurrentEditor() {
        FileEditor fileEditor = (FileEditor)this.getCurrentSide().select((Object)this.getEditor1(), (Object)this.getEditor2());
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "getCurrentEditor"));
        }
        return fileEditor;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "getStatusPanel"));
        }
        return myStatusPanel;
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return ((DiffContent)this.getCurrentSide().selectNotNull(this.getRequest().getContents())).getOpenFileDescriptor();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content : contents) {
            canShow &= BinaryDiffViewer.canShowContent(content, context);
            wantShow |= BinaryDiffViewer.wantShowContent(content, context);
        }
        return canShow && wantShow;
    }

    public static boolean canShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowContent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowContent"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            Project project = context.getProject();
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            VirtualFile file = ((FileContent)content).getFile();
            return FileEditorProviderManager.getInstance().getProviders(project, file).length != 0;
        }
        return false;
    }

    public static boolean wantShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/binary/BinaryDiffViewer", "wantShowContent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "wantShowContent"));
        }
        if (content instanceof EmptyContent) {
            return false;
        }
        if (content instanceof FileContent) {
            if (content.getContentType() == null) {
                return false;
            }
            if (content.getContentType().isBinary()) {
                return true;
            }
            return content.getContentType() instanceof UIBasedFileType;
        }
        return false;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return DiffUtil.getVirtualFile(this.myRequest, this.getCurrentSide());
        }
        return super.getData(dataId);
    }

    private static class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        protected int getChangesCount() {
            return -1;
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/BinaryDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
            }
            assert (BinaryDiffViewer.this.getEditor1() != null && BinaryDiffViewer.this.getEditor2() != null);
            BinaryDiffViewer.this.setCurrentSide(BinaryDiffViewer.this.getCurrentSide().other());
            BinaryDiffViewer.this.myContext.requestFocus();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/BinaryDiffViewer$MyFocusOppositePaneAction", "update"));
            }
            e.getPresentation().setEnabled(BinaryDiffViewer.this.getEditor1() != null && BinaryDiffViewer.this.getEditor2() != null);
        }
    }
}

