/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.util.Side;
import com.intellij.util.SmartList;
import gnu.trove.TIntFunction;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class LineNumberConvertor {
    @NotNull
    private final TreeMap<Integer, Integer> myFragments1;
    @NotNull
    private final TreeMap<Integer, Integer> myFragments2;
    @NotNull
    private final TreeMap<Integer, Integer> myInvertedFragments1;
    @NotNull
    private final TreeMap<Integer, Integer> myInvertedFragments2;
    @NotNull
    private final Corrector myCorrector;

    public LineNumberConvertor(@NotNull TreeMap<Integer, Integer> fragments1, @NotNull TreeMap<Integer, Integer> fragments2, @NotNull TreeMap<Integer, Integer> invertedFragments1, @NotNull TreeMap<Integer, Integer> invertedFragments2) {
        if (fragments1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments1", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        if (fragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments2", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        if (invertedFragments1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invertedFragments1", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        if (invertedFragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invertedFragments2", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "<init>"));
        }
        this.myCorrector = new Corrector();
        this.myFragments1 = fragments1;
        this.myFragments2 = fragments2;
        this.myInvertedFragments1 = invertedFragments1;
        this.myInvertedFragments2 = invertedFragments2;
    }

    public int convert1(int value) {
        return this.convert(value, Side.LEFT, true, false);
    }

    public int convert2(int value) {
        return this.convert(value, Side.RIGHT, true, false);
    }

    public int convertInv1(int value) {
        return this.convert(value, Side.LEFT, false, false);
    }

    public int convertInv2(int value) {
        return this.convert(value, Side.RIGHT, false, false);
    }

    public int convertApproximate1(int value) {
        return this.convert(value, Side.LEFT, true, true);
    }

    public int convertApproximate2(int value) {
        return this.convert(value, Side.RIGHT, true, true);
    }

    public int convertApproximateInv1(int value) {
        return this.convert(value, Side.LEFT, false, true);
    }

    public int convertApproximateInv2(int value) {
        return this.convert(value, Side.RIGHT, false, true);
    }

    @NotNull
    public TIntFunction createConvertor1() {
        TIntFunction tIntFunction = new TIntFunction(){

            public int execute(int value) {
                return LineNumberConvertor.this.convert1(value);
            }
        };
        if (tIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "createConvertor1"));
        }
        return tIntFunction;
    }

    @NotNull
    public TIntFunction createConvertor2() {
        TIntFunction tIntFunction = new TIntFunction(){

            public int execute(int value) {
                return LineNumberConvertor.this.convert2(value);
            }
        };
        if (tIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "createConvertor2"));
        }
        return tIntFunction;
    }

    private int convert(int value, @NotNull Side side, boolean fromOneside, boolean approximate) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "convert"));
        }
        return this.myCorrector.convertCorrected(value, side, fromOneside, approximate);
    }

    public void handleOnesideChange(int startLine, int endLine, int shift, @NotNull Side masterSide) {
        if (masterSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "handleOnesideChange"));
        }
        this.myCorrector.handleOnesideChange(startLine, endLine, shift, masterSide);
    }

    private static int convert(@NotNull TreeMap<Integer, Integer> fragments, int value, boolean approximate) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "convert"));
        }
        return approximate ? LineNumberConvertor.convertApproximate(fragments, value) : LineNumberConvertor.convert(fragments, value);
    }

    private static int convert(@NotNull TreeMap<Integer, Integer> fragments, int value) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "convert"));
        }
        Map.Entry<Integer, Integer> floor = fragments.floorEntry(value);
        if (floor == null || floor.getValue() == -1) {
            return -1;
        }
        return floor.getValue() - floor.getKey() + value;
    }

    private static int convertApproximate(@NotNull TreeMap<Integer, Integer> fragments, int value) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "convertApproximate"));
        }
        Map.Entry<Integer, Integer> floor = fragments.floorEntry(value);
        if (floor == null) {
            return 0;
        }
        if (floor.getValue() != -1) {
            return floor.getValue() - floor.getKey() + value;
        }
        Map.Entry<Integer, Integer> floorHead = fragments.floorEntry(floor.getKey() - 1);
        assert (floorHead != null && floorHead.getValue() != -1);
        return floorHead.getValue() - floorHead.getKey() + floor.getKey();
    }

    @NotNull
    private TreeMap<Integer, Integer> getFragments(@NotNull Side side, boolean fromOneside) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "getFragments"));
        }
        TreeMap treeMap = fromOneside ? (TreeMap)side.select(this.myFragments1, this.myFragments2) : (TreeMap)side.select(this.myInvertedFragments1, this.myInvertedFragments2);
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor", "getFragments"));
        }
        return treeMap;
    }

    private static class CorrectedChange {
        public final int startOneside;
        public final int startTwoside;
        public final int oldLength;
        public final int newLength;
        @NotNull
        public final Side side;

        public CorrectedChange(int startOneside, int startTwoside, int oldLength, int newLength, @NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/LineNumberConvertor$CorrectedChange", "<init>"));
            }
            this.startOneside = startOneside;
            this.startTwoside = startTwoside;
            this.oldLength = oldLength;
            this.newLength = newLength;
            this.side = side;
        }
    }

    private class Corrector {
        private final List<CorrectedChange> myChanges = new SmartList();

        private Corrector() {
        }

        public void handleOnesideChange(int startLine, int endLine, int shift, @NotNull Side masterSide) {
            if (masterSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Corrector", "handleOnesideChange"));
            }
            int oldOnesideStart = startLine;
            int oldTwosideStart = LineNumberConvertor.this.convert(startLine, masterSide, true, false);
            assert (oldTwosideStart != -1);
            int oldLength = endLine - startLine;
            int newLength = oldLength + shift;
            this.myChanges.add(new CorrectedChange(oldOnesideStart, oldTwosideStart, oldLength, newLength, masterSide));
        }

        public int convertCorrected(int value, @NotNull Side side, boolean fromOneside, boolean approximate) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Corrector", "convertCorrected"));
            }
            if (fromOneside) {
                return this.convertFromOneside(value, side, approximate, this.myChanges.size() - 1);
            }
            return this.convertFromTwoside(value, side, approximate, this.myChanges.size() - 1);
        }

        private int convertFromTwoside(int value, @NotNull Side side, boolean approximate, int index) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Corrector", "convertFromTwoside"));
            }
            if (index < 0) {
                return LineNumberConvertor.convert(LineNumberConvertor.this.getFragments(side, false), value, approximate);
            }
            CorrectedChange change = this.myChanges.get(index);
            int shift = change.newLength - change.oldLength;
            if (change.side != side) {
                int converted = this.convertFromTwoside(value, side, approximate, index - 1);
                if (converted < change.startOneside) {
                    return converted;
                }
                if (converted >= change.startOneside + change.oldLength) {
                    return converted + shift;
                }
                if (!approximate) {
                    return -1;
                }
                return this.append(converted, Math.min(change.newLength, converted - change.startOneside));
            }
            if (value < change.startTwoside) {
                return this.convertFromTwoside(value, side, approximate, index - 1);
            }
            if (value >= change.startTwoside + change.newLength) {
                int converted = this.convertFromTwoside(value - shift, side, approximate, index - 1);
                return this.append(converted, shift);
            }
            int convertedStart = this.convertFromTwoside(change.startTwoside, side, approximate, index - 1);
            return this.append(convertedStart, value - change.startTwoside);
        }

        private int convertFromOneside(int value, @NotNull Side side, boolean approximate, int index) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Corrector", "convertFromOneside"));
            }
            if (index < 0) {
                return LineNumberConvertor.convert(LineNumberConvertor.this.getFragments(side, true), value, approximate);
            }
            CorrectedChange change = this.myChanges.get(index);
            int shift = change.newLength - change.oldLength;
            if (value < change.startOneside) {
                return this.convertFromOneside(value, side, approximate, index - 1);
            }
            if (value >= change.startOneside + change.newLength) {
                int converted = this.convertFromOneside(value - shift, side, approximate, index - 1);
                return this.append(converted, side == change.side ? shift : 0);
            }
            if (side != change.side) {
                if (!approximate) {
                    return -1;
                }
                return this.convertFromOneside(change.startOneside, side, approximate, index - 1);
            }
            int convertedStart = this.convertFromOneside(change.startOneside, side, approximate, index - 1);
            return this.append(convertedStart, value - change.startOneside);
        }

        private int append(int value, int shift) {
            return value == -1 ? -1 : value + shift;
        }
    }

    public static class Builder {
        @NotNull
        private final TreeMap<Integer, Integer> myFragments1 = new TreeMap();
        @NotNull
        private final TreeMap<Integer, Integer> myFragments2 = new TreeMap();
        @NotNull
        private final TreeMap<Integer, Integer> myInvertedFragments1 = new TreeMap();
        @NotNull
        private final TreeMap<Integer, Integer> myInvertedFragments2 = new TreeMap();

        public void put1(int start, int newStart, int length) {
            this.myFragments1.put(start, newStart);
            this.myFragments1.put(start + length, -1);
            this.myInvertedFragments1.put(newStart, start);
            this.myInvertedFragments1.put(newStart + length, -1);
        }

        public void put2(int start, int newStart, int length) {
            this.myFragments2.put(start, newStart);
            this.myFragments2.put(start + length, -1);
            this.myInvertedFragments2.put(newStart, start);
            this.myInvertedFragments2.put(newStart + length, -1);
        }

        @NotNull
        public LineNumberConvertor build() {
            LineNumberConvertor lineNumberConvertor = new LineNumberConvertor(this.myFragments1, this.myFragments2, this.myInvertedFragments1, this.myInvertedFragments2);
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Builder", "build"));
            }
            return lineNumberConvertor;
        }

        @NotNull
        public static LineNumberConvertor createLeft(int lines) {
            Builder builder = new Builder();
            builder.put1(0, 0, lines);
            LineNumberConvertor lineNumberConvertor = builder.build();
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Builder", "createLeft"));
            }
            return lineNumberConvertor;
        }

        @NotNull
        public static LineNumberConvertor createRight(int lines) {
            Builder builder = new Builder();
            builder.put2(0, 0, lines);
            LineNumberConvertor lineNumberConvertor = builder.build();
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/LineNumberConvertor$Builder", "createRight"));
            }
            return lineNumberConvertor;
        }
    }
}

