/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChange {
    @NotNull
    private final SimpleDiffViewer myViewer;
    @NotNull
    private final LineFragment myFragment;
    @Nullable
    private final List<DiffFragment> myInnerFragments;
    @Nullable
    private final EditorEx myEditor1;
    @Nullable
    private final EditorEx myEditor2;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final List<MyGutterOperation> myOperations;
    private boolean myIsValid;
    private int[] myLineStartShifts;
    private int[] myLineEndShifts;

    public SimpleDiffChange(@NotNull SimpleDiffViewer viewer, @NotNull LineFragment fragment, @Nullable EditorEx editor1, @Nullable EditorEx editor2, boolean inlineHighlight) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/tools/simple/SimpleDiffChange", "<init>"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleDiffChange", "<init>"));
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myIsValid = true;
        this.myLineStartShifts = new int[2];
        this.myLineEndShifts = new int[2];
        this.myViewer = viewer;
        this.myFragment = fragment;
        this.myInnerFragments = inlineHighlight ? fragment.getInnerFragments() : null;
        this.myEditor1 = editor1;
        this.myEditor2 = editor2;
        this.installHighlighter();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        if (this.myInnerFragments != null) {
            this.doInstallHighlighterWithInner();
        } else {
            this.doInstallHighlighterSimple();
        }
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    private void doInstallHighlighterSimple() {
        this.createHighlighter(Side.LEFT, false);
        this.createHighlighter(Side.RIGHT, false);
    }

    private void doInstallHighlighterWithInner() {
        assert (this.myInnerFragments != null);
        this.createHighlighter(Side.LEFT, true);
        this.createHighlighter(Side.RIGHT, true);
        for (DiffFragment fragment : this.myInnerFragments) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
    }

    private void doInstallActionHighlighters() {
        if (this.myEditor1 != null && this.myEditor2 != null) {
            this.myOperations.add(this.createOperation(Side.LEFT));
            this.myOperations.add(this.createOperation(Side.RIGHT));
        }
    }

    private void createHighlighter(@NotNull Side side, boolean ignored) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createHighlighter"));
        }
        Editor editor = (Editor)side.select((Object)this.myEditor1, (Object)this.myEditor2);
        if (editor == null) {
            return;
        }
        int start = side.getStartOffset((DiffFragment)this.myFragment);
        int end = side.getEndOffset((DiffFragment)this.myFragment);
        TextDiffType type = DiffUtil.getLineDiffType(this.myFragment);
        this.myHighlighters.add(DiffDrawUtil.createHighlighter(editor, start, end, type, ignored));
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        if (startLine == endLine) {
            if (startLine != 0) {
                this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM, true));
            }
        } else {
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, startLine, type, SeparatorPlacement.TOP));
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM));
        }
    }

    private void createInlineHighlighter(@NotNull DiffFragment fragment, @NotNull Side side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleDiffChange", "createInlineHighlighter"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createInlineHighlighter"));
        }
        Editor editor = (Editor)side.select((Object)this.myEditor1, (Object)this.myEditor2);
        if (editor == null) {
            return;
        }
        int start = side.getStartOffset(fragment);
        int end = side.getEndOffset(fragment);
        TextDiffType type = DiffUtil.getDiffType(fragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myFragment);
        RangeHighlighter highlighter = DiffDrawUtil.createInlineHighlighter(editor, start += startOffset, end += startOffset, type);
        this.myHighlighters.add(highlighter);
    }

    public void updateGutterActions(boolean force) {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public int getStartLine(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "getStartLine"));
        }
        return side.getStartLine(this.myFragment) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "getEndLine"));
        }
        return side.getEndLine(this.myFragment) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getLineDiffType(this.myFragment);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffChange", "getDiffType"));
        }
        return textDiffType;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "processChange"));
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        if (line2 <= oldLine1) {
            return false;
        }
        if (line1 >= oldLine2) {
            int n = side.getIndex();
            this.myLineStartShifts[n] = this.myLineStartShifts[n] + shift;
            int n2 = side.getIndex();
            this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + shift;
            return false;
        }
        if (line1 <= oldLine1 && line2 >= oldLine2) {
            int n = side.getIndex();
            this.myLineEndShifts[n] = this.myLineEndShifts[n] + shift;
            return false;
        }
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
        this.myIsValid = false;
        return true;
    }

    public boolean isSelectedByLine(int line, @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "isSelectedByLine"));
        }
        if (this.myEditor1 == null || this.myEditor2 == null) {
            return false;
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        return DiffUtil.isSelectedByLine(line, line1, line2);
    }

    @NotNull
    private MyGutterOperation createOperation(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createOperation"));
        }
        assert (this.myEditor1 != null && this.myEditor2 != null);
        int offset = side.getStartOffset((DiffFragment)this.myFragment);
        EditorEx editor = (EditorEx)side.select((Object)this.myEditor1, (Object)this.myEditor2);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        MyGutterOperation myGutterOperation = new MyGutterOperation(side, highlighter);
        if (myGutterOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffChange", "createOperation"));
        }
        return myGutterOperation;
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(final @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createApplyRenderer"));
        }
        return this.createIconRenderer(side, "Replace", AllIcons.Diff.Arrow, new Runnable(){

            @Override
            public void run() {
                SimpleDiffChange.this.myViewer.replaceChange(SimpleDiffChange.this, side);
            }
        });
    }

    @Nullable
    private GutterIconRenderer createAppendRenderer(final @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createAppendRenderer"));
        }
        return this.createIconRenderer(side, "Insert", AllIcons.Diff.ArrowLeftDown, new Runnable(){

            @Override
            public void run() {
                SimpleDiffChange.this.myViewer.appendChange(SimpleDiffChange.this, side);
            }
        });
    }

    @Nullable
    private GutterIconRenderer createRevertRenderer(final @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createRevertRenderer"));
        }
        return this.createIconRenderer(side.other(), "Revert", AllIcons.Diff.Remove, new Runnable(){

            @Override
            public void run() {
                SimpleDiffChange.this.myViewer.replaceChange(SimpleDiffChange.this, side.other());
            }
        });
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, final @NotNull String tooltipText, final @NotNull Icon icon, final @NotNull Runnable perform) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/simple/SimpleDiffChange", "createIconRenderer"));
        }
        if (tooltipText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipText", "com/intellij/diff/tools/simple/SimpleDiffChange", "createIconRenderer"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/diff/tools/simple/SimpleDiffChange", "createIconRenderer"));
        }
        if (perform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "perform", "com/intellij/diff/tools/simple/SimpleDiffChange", "createIconRenderer"));
        }
        assert (this.myEditor1 != null && this.myEditor2 != null);
        if (!DiffUtil.isEditable((Editor)sourceSide.other().select((Object)this.myEditor1, (Object)this.myEditor2))) {
            return null;
        }
        return new GutterIconRenderer(){

            @NotNull
            public Icon getIcon() {
                Icon icon2 = icon;
                if (icon2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffChange$4", "getIcon"));
                }
                return icon2;
            }

            public boolean isNavigateAction() {
                return true;
            }

            @Nullable
            public AnAction getClickAction() {
                return new DumbAwareAction(){

                    public void actionPerformed(AnActionEvent e) {
                        Project project = e.getProject();
                        DocumentEx document1 = SimpleDiffChange.this.myEditor1.getDocument();
                        DocumentEx document2 = SimpleDiffChange.this.myEditor2.getDocument();
                        if (!SimpleDiffChange.this.myIsValid) {
                            return;
                        }
                        DiffUtil.executeWriteCommand((Document)sourceSide.other().select((Object)document1, (Object)document2), project, "Replace change", new Runnable(){

                            @Override
                            public void run() {
                                perform.run();
                            }
                        });
                    }
                };
            }

            public boolean equals(Object obj) {
                return obj == this;
            }

            public int hashCode() {
                return System.identityHashCode((Object)this);
            }

            @Nullable
            public String getTooltipText() {
                return tooltipText;
            }
        };
    }

    private class MyGutterOperation {
        @NotNull
        private final Side mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;
        private boolean myCtrlPressed;
        private boolean myShiftPressed;

        private MyGutterOperation(@NotNull Side side, RangeHighlighter highlighter) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange$MyGutterOperation", "<init>"));
            }
            if (highlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/tools/simple/SimpleDiffChange$MyGutterOperation", "<init>"));
            }
            this.mySide = side;
            this.myHighlighter = highlighter;
            this.update(true);
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update(boolean force) {
            if (!force && !this.areModifiersChanged()) {
                return;
            }
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        private boolean areModifiersChanged() {
            return this.myCtrlPressed != SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed() || this.myShiftPressed != SimpleDiffChange.this.myViewer.getModifierProvider().isShiftPressed();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            boolean isAppendable;
            assert (SimpleDiffChange.this.myEditor1 != null && SimpleDiffChange.this.myEditor2 != null);
            this.myCtrlPressed = SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed();
            this.myShiftPressed = SimpleDiffChange.this.myViewer.getModifierProvider().isShiftPressed();
            boolean isEditable = DiffUtil.isEditable((Editor)this.mySide.select((Object)SimpleDiffChange.this.myEditor1, (Object)SimpleDiffChange.this.myEditor2));
            boolean isOtherEditable = DiffUtil.isEditable((Editor)this.mySide.other().select((Object)SimpleDiffChange.this.myEditor1, (Object)SimpleDiffChange.this.myEditor2));
            boolean bl = isAppendable = SimpleDiffChange.this.myFragment.getStartLine1() != SimpleDiffChange.this.myFragment.getEndLine1() && SimpleDiffChange.this.myFragment.getStartLine2() != SimpleDiffChange.this.myFragment.getEndLine2();
            if ((this.myShiftPressed || !isOtherEditable) && isEditable) {
                return SimpleDiffChange.this.createRevertRenderer(this.mySide);
            }
            if (this.myCtrlPressed && isAppendable) {
                return SimpleDiffChange.this.createAppendRenderer(this.mySide);
            }
            return SimpleDiffChange.this.createApplyRenderer(this.mySide);
        }
    }
}

