/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusTrackerSupport<T> {
    @Nullable
    private static JComponent getComponent(@Nullable Editor editor) {
        return editor != null ? editor.getContentComponent() : null;
    }

    @Nullable
    private static JComponent getComponent(@Nullable FileEditor editor) {
        return editor != null ? editor.getComponent() : null;
    }

    public static class ThreesideFocusTrackerSupport {
        @NotNull
        private ThreeSide myCurrentSide;
        private final boolean myDumbMode;
        @Nullable
        private final MyFocusListener myListener1;
        @Nullable
        private final MyFocusListener myListener2;
        @Nullable
        private final MyFocusListener myListener3;

        public ThreesideFocusTrackerSupport(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "<init>"));
            }
            this(editors.get(0), editors.get(1), editors.get(2));
        }

        public ThreesideFocusTrackerSupport(@Nullable Editor editor1, @Nullable Editor editor2, @Nullable Editor editor3) {
            this(FocusTrackerSupport.getComponent(editor1), FocusTrackerSupport.getComponent(editor2), FocusTrackerSupport.getComponent(editor3));
        }

        public ThreesideFocusTrackerSupport(@Nullable FileEditor editor1, @Nullable FileEditor editor2, @Nullable FileEditor editor3) {
            this(FocusTrackerSupport.getComponent(editor1), FocusTrackerSupport.getComponent(editor2), FocusTrackerSupport.getComponent(editor3));
        }

        public ThreesideFocusTrackerSupport(@Nullable JComponent component1, @Nullable JComponent component2, @Nullable JComponent component3) {
            assert (component1 != null || component2 != null || component3 != null);
            this.myCurrentSide = component2 != null ? ThreeSide.BASE : (component1 != null ? ThreeSide.LEFT : ThreeSide.RIGHT);
            boolean c1 = component1 != null;
            boolean c2 = component2 != null;
            boolean c3 = component3 != null;
            boolean bl = this.myDumbMode = !c1 && !c2 || !c1 && !c3 || !c2 && !c3;
            if (!this.myDumbMode) {
                MyFocusListener myFocusListener = this.myListener1 = component1 != null ? new MyFocusListener(ThreeSide.LEFT) : null;
                if (component1 != null) {
                    component1.addFocusListener(this.myListener1);
                }
                MyFocusListener myFocusListener2 = this.myListener2 = component2 != null ? new MyFocusListener(ThreeSide.BASE) : null;
                if (component2 != null) {
                    component2.addFocusListener(this.myListener2);
                }
                MyFocusListener myFocusListener3 = this.myListener3 = component3 != null ? new MyFocusListener(ThreeSide.RIGHT) : null;
                if (component3 != null) {
                    component3.addFocusListener(this.myListener3);
                }
            } else {
                this.myListener1 = null;
                this.myListener2 = null;
                this.myListener3 = null;
            }
        }

        @NotNull
        public ThreeSide getCurrentSide() {
            ThreeSide threeSide = this.myCurrentSide;
            if (threeSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "getCurrentSide"));
            }
            return threeSide;
        }

        public void setCurrentSide(@NotNull ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "setCurrentSide"));
            }
            if (this.myDumbMode || side.select((Object)this.myListener1, (Object)this.myListener2, (Object)this.myListener3) == null) {
                return;
            }
            this.myCurrentSide = side;
        }

        public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "processContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "processContextHints"));
            }
            ThreeSide side = (ThreeSide)context.getUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "updateContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "updateContextHints"));
            }
            if (this.myDumbMode) {
                return;
            }
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE, (Object)this.myCurrentSide);
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final ThreeSide mySide;

            private MyFocusListener(ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport$MyFocusListener", "<init>"));
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                ThreesideFocusTrackerSupport.this.myCurrentSide = this.mySide;
            }
        }
    }

    public static class TwosideFocusTrackerSupport {
        @NotNull
        private Side myCurrentSide;
        private final boolean myDumbMode;
        @Nullable
        private final MyFocusListener myListener1;
        @Nullable
        private final MyFocusListener myListener2;

        public TwosideFocusTrackerSupport(@Nullable Editor editor1, @Nullable Editor editor2) {
            this(FocusTrackerSupport.getComponent(editor1), FocusTrackerSupport.getComponent(editor2));
        }

        public TwosideFocusTrackerSupport(@Nullable FileEditor editor1, @Nullable FileEditor editor2) {
            this(FocusTrackerSupport.getComponent(editor1), FocusTrackerSupport.getComponent(editor2));
        }

        public TwosideFocusTrackerSupport(@Nullable JComponent component1, @Nullable JComponent component2) {
            assert (component1 != null || component2 != null);
            this.myCurrentSide = component2 != null ? Side.RIGHT : Side.LEFT;
            boolean bl = this.myDumbMode = component1 == null || component2 == null;
            if (!this.myDumbMode) {
                this.myListener1 = new MyFocusListener(Side.LEFT);
                component1.addFocusListener(this.myListener1);
                this.myListener2 = new MyFocusListener(Side.RIGHT);
                component2.addFocusListener(this.myListener2);
            } else {
                this.myListener1 = null;
                this.myListener2 = null;
            }
        }

        @NotNull
        public Side getCurrentSide() {
            Side side = this.myCurrentSide;
            if (side == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "getCurrentSide"));
            }
            return side;
        }

        public void setCurrentSide(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "setCurrentSide"));
            }
            if (this.myDumbMode) {
                return;
            }
            this.myCurrentSide = side;
        }

        public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "processContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "processContextHints"));
            }
            Side side = (Side)context.getUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "updateContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "updateContextHints"));
            }
            if (this.myDumbMode) {
                return;
            }
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, (Object)this.myCurrentSide);
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final Side mySide;

            private MyFocusListener(Side side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport$MyFocusListener", "<init>"));
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                TwosideFocusTrackerSupport.this.myCurrentSide = this.mySide;
            }
        }
    }
}

