/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import gnu.trove.TIntFunction;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncScrollSupport {
    private static final Logger LOG = Logger.getInstance(SyncScrollSupport.class);

    @NotNull
    private static MyScrollHelper create(@NotNull Editor master, @NotNull Editor slave, final @NotNull SyncScrollable scrollable, final @NotNull Side side) {
        if (master == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        if (slave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        if (scrollable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        MyScrollHelper myScrollHelper = new MyScrollHelper(master, slave, new TIntFunction(){

            public int execute(int value) {
                return scrollable.transfer(side, value);
            }
        });
        if (myScrollHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        return myScrollHelper;
    }

    private static void doScrollVertically(@NotNull Editor editor, int offset, boolean animated) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/SyncScrollSupport", "doScrollVertically"));
        }
        ScrollingModel model = editor.getScrollingModel();
        if (!animated) {
            model.disableAnimation();
        }
        model.scrollVertically(offset);
        if (!animated) {
            model.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull Editor editor, int offset, boolean animated) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/SyncScrollSupport", "doScrollHorizontally"));
        }
        ScrollingModel model = editor.getScrollingModel();
        if (!animated) {
            model.disableAnimation();
        }
        model.scrollHorizontally(offset);
        if (!animated) {
            model.enableAnimation();
        }
    }

    private static int getHeaderOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/SyncScrollSupport", "getHeaderOffset"));
        }
        JComponent header = editor.getHeaderComponent();
        return header == null ? 0 : header.getHeight();
    }

    @NotNull
    private static IntPair getTargetOffsets(@NotNull Editor editor1, @NotNull Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        int topOffset1 = editor1.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)startLine1, (int)0)).y;
        int bottomOffset1 = editor1.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)(endLine1 + 1), (int)0)).y;
        int topOffset2 = editor2.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)startLine2, (int)0)).y;
        int bottomOffset2 = editor2.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)(endLine2 + 1), (int)0)).y;
        int rangeHeight1 = bottomOffset1 - topOffset1;
        int rangeHeight2 = bottomOffset2 - topOffset2;
        int gapLines1 = 2 * editor1.getLineHeight();
        int gapLines2 = 2 * editor2.getLineHeight();
        int editorHeight1 = editor1.getScrollingModel().getVisibleArea().height;
        int editorHeight2 = editor2.getScrollingModel().getVisibleArea().height;
        int maximumOffset1 = ((EditorEx)editor1).getScrollPane().getVerticalScrollBar().getMaximum() - editorHeight1;
        int maximumOffset2 = ((EditorEx)editor2).getScrollPane().getVerticalScrollBar().getMaximum() - editorHeight2;
        boolean canShow1 = 2 * gapLines1 + rangeHeight1 <= editorHeight1;
        boolean canShow2 = 2 * gapLines2 + rangeHeight2 <= editorHeight2;
        int topShift1 = canShow1 ? Math.min(editorHeight1 - gapLines1 - rangeHeight1, editorHeight1 / 3) : gapLines1;
        int topShift2 = canShow2 ? Math.min(editorHeight2 - gapLines2 - rangeHeight2, editorHeight2 / 3) : gapLines2;
        int topShift = Math.min(topShift1, topShift2);
        topShift = Math.min(topShift, Math.min(topOffset1, topOffset2));
        int offset1 = topOffset1 - topShift;
        int offset2 = topOffset2 - topShift;
        if (maximumOffset1 > offset1 && maximumOffset2 > offset2) {
            IntPair intPair = new IntPair(offset1, offset2);
            if (intPair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
            }
            return intPair;
        }
        topShift = Math.max(topOffset1 - maximumOffset1, topOffset2 - maximumOffset2);
        offset1 = topOffset1 - topShift + Math.max(topShift + rangeHeight1 + gapLines1 - editorHeight1, 0);
        offset2 = topOffset2 - topShift + Math.max(topShift + rangeHeight2 + gapLines2 - editorHeight2, 0);
        offset1 = Math.min(offset1, topOffset1 - gapLines1);
        offset2 = Math.min(offset2, topOffset2 - gapLines2);
        IntPair intPair = new IntPair(offset1, offset2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        return intPair;
    }

    private static class Anchor {
        public final int masterStartOffset;
        public final int masterEndOffset;
        public final int slaveStartOffset;
        public final int slaveEndOffset;

        public Anchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.masterStartOffset = masterStartOffset;
            this.masterEndOffset = masterEndOffset;
            this.slaveStartOffset = slaveStartOffset;
            this.slaveEndOffset = slaveEndOffset;
        }
    }

    private static class MyScrollHelper
    implements VisibleAreaListener {
        @NotNull
        private final Editor myMaster;
        @NotNull
        private final Editor mySlave;
        @NotNull
        private final TIntFunction myConvertor;
        @Nullable
        private Anchor myAnchor;

        public MyScrollHelper(@NotNull Editor master, @NotNull Editor slave, @NotNull TIntFunction convertor) {
            if (master == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "<init>"));
            }
            if (slave == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "<init>"));
            }
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "<init>"));
            }
            this.myMaster = master;
            this.mySlave = slave;
            this.myConvertor = convertor;
        }

        public void setAnchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.myAnchor = new Anchor(masterStartOffset, masterEndOffset, slaveStartOffset, slaveEndOffset);
        }

        public void removeAnchor() {
            this.myAnchor = null;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (oldRectangle == null) {
                return;
            }
            if (newRectangle.x != oldRectangle.x) {
                this.syncHorizontalScroll(false);
            }
            if (newRectangle.y != oldRectangle.y) {
                this.syncVerticalScroll(false);
            }
        }

        private void syncVerticalScroll(boolean animated) {
            int offset;
            if (this.myMaster.getDocument().getTextLength() == 0) {
                return;
            }
            Rectangle viewRect = this.myMaster.getScrollingModel().getVisibleArea();
            int middleY = viewRect.height / 3;
            if (this.myAnchor == null) {
                LogicalPosition masterPos = this.myMaster.xyToLogicalPosition(new Point(viewRect.x, viewRect.y + middleY));
                int masterCenterLine = masterPos.line;
                int convertedCenterLine = this.myConvertor.execute(masterCenterLine);
                Point point = this.mySlave.logicalPositionToXY(new LogicalPosition(convertedCenterLine, masterPos.column));
                int correction = (viewRect.y + middleY) % this.myMaster.getLineHeight();
                offset = point.y - middleY + correction;
            } else {
                double progress = this.myAnchor.masterStartOffset == this.myAnchor.masterEndOffset || viewRect.y == this.myAnchor.masterEndOffset ? 1.0 : (double)(viewRect.y - this.myAnchor.masterStartOffset) / (double)(this.myAnchor.masterEndOffset - this.myAnchor.masterStartOffset);
                offset = this.myAnchor.slaveStartOffset + (int)((double)(this.myAnchor.slaveEndOffset - this.myAnchor.slaveStartOffset) * progress);
            }
            int deltaHeaderOffset = SyncScrollSupport.getHeaderOffset(this.mySlave) - SyncScrollSupport.getHeaderOffset(this.myMaster);
            SyncScrollSupport.doScrollVertically(this.mySlave, offset + deltaHeaderOffset, animated);
        }

        private void syncHorizontalScroll(boolean animated) {
            int offset = this.myMaster.getScrollingModel().getVisibleArea().x;
            SyncScrollSupport.doScrollHorizontally(this.mySlave, offset, animated);
        }
    }

    public static class ThreesideSyncScrollSupport {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable1;
        @NotNull
        private final SyncScrollable myScrollable2;
        @NotNull
        private final MyScrollHelper myHelper11;
        @NotNull
        private final MyScrollHelper myHelper12;
        @NotNull
        private final MyScrollHelper myHelper21;
        @NotNull
        private final MyScrollHelper myHelper22;
        private boolean myDisabled;
        private boolean myDuringSyncScroll;

        public ThreesideSyncScrollSupport(@NotNull List<? extends Editor> editors, @NotNull SyncScrollable scrollable1, @NotNull SyncScrollable scrollable2) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            if (scrollable1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable1", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            if (scrollable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable2", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            this.myDisabled = false;
            this.myDuringSyncScroll = false;
            assert (editors.size() == 3);
            this.myEditors = editors;
            this.myScrollable1 = scrollable1;
            this.myScrollable2 = scrollable2;
            this.myHelper11 = SyncScrollSupport.create(editors.get(0), editors.get(1), this.myScrollable1, Side.LEFT);
            this.myHelper12 = SyncScrollSupport.create(editors.get(1), editors.get(0), this.myScrollable1, Side.RIGHT);
            this.myHelper21 = SyncScrollSupport.create(editors.get(1), editors.get(2), this.myScrollable2, Side.LEFT);
            this.myHelper22 = SyncScrollSupport.create(editors.get(2), editors.get(1), this.myScrollable2, Side.RIGHT);
        }

        public void setDisabled(boolean value) {
            if (this.myDisabled == value) {
                LOG.warn(new Throwable("myDisabled == value: " + this.myDisabled + " - " + value));
            }
            this.myDisabled = value;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (this.myDuringSyncScroll || this.myDisabled) {
                return;
            }
            this.myDuringSyncScroll = true;
            try {
                if (e.getEditor() == this.myEditors.get(0)) {
                    if (this.myScrollable1.isSyncScrollEnabled()) {
                        this.myHelper11.visibleAreaChanged(e);
                    }
                    if (this.myScrollable1.isSyncScrollEnabled() && this.myScrollable2.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                } else if (e.getEditor() == this.myEditors.get(1)) {
                    if (this.myScrollable1.isSyncScrollEnabled()) {
                        this.myHelper12.visibleAreaChanged(e);
                    }
                    if (this.myScrollable2.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                } else if (e.getEditor() == this.myEditors.get(2)) {
                    if (this.myScrollable2.isSyncScrollEnabled()) {
                        this.myHelper22.visibleAreaChanged(e);
                    }
                    if (this.myScrollable2.isSyncScrollEnabled() && this.myScrollable1.isSyncScrollEnabled()) {
                        this.myHelper12.visibleAreaChanged(e);
                    }
                }
            }
            finally {
                this.myDuringSyncScroll = false;
            }
        }
    }

    public static class TwosideSyncScrollSupport {
        @NotNull
        private final Editor myEditor1;
        @NotNull
        private final Editor myEditor2;
        @NotNull
        private final SyncScrollable myScrollable;
        @NotNull
        private final MyScrollHelper myHelper1;
        @NotNull
        private final MyScrollHelper myHelper2;
        private boolean myDisabled;
        private boolean myDuringSyncScroll;

        public TwosideSyncScrollSupport(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull SyncScrollable scrollable) {
            if (editor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            if (editor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            if (scrollable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            this.myDisabled = false;
            this.myDuringSyncScroll = false;
            this.myEditor1 = editor1;
            this.myEditor2 = editor2;
            this.myScrollable = scrollable;
            this.myHelper1 = SyncScrollSupport.create(this.myEditor1, this.myEditor2, this.myScrollable, Side.LEFT);
            this.myHelper2 = SyncScrollSupport.create(this.myEditor2, this.myEditor1, this.myScrollable, Side.RIGHT);
        }

        public boolean isDuringSyncScroll() {
            return this.myDuringSyncScroll;
        }

        public void setDisabled(boolean value) {
            if (this.myDisabled == value) {
                LOG.warn(new Throwable("myDisabled == value: " + this.myDisabled + " - " + value));
            }
            this.myDisabled = value;
        }

        @NotNull
        public SyncScrollable getScrollable() {
            SyncScrollable syncScrollable = this.myScrollable;
            if (syncScrollable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "getScrollable"));
            }
            return syncScrollable;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!this.myScrollable.isSyncScrollEnabled() || this.myDuringSyncScroll || this.myDisabled) {
                return;
            }
            this.myDuringSyncScroll = true;
            try {
                if (e.getEditor() == this.myEditor1) {
                    this.myHelper1.visibleAreaChanged(e);
                } else if (e.getEditor() == this.myEditor2) {
                    this.myHelper2.visibleAreaChanged(e);
                }
            }
            finally {
                this.myDuringSyncScroll = false;
            }
        }

        public void makeVisible(@NotNull Side masterSide, int startLine1, int endLine1, int startLine2, int endLine2, final boolean animate) {
            if (masterSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "makeVisible"));
            }
            Side slaveSide = masterSide.other();
            IntPair offsets = SyncScrollSupport.getTargetOffsets(this.myEditor1, this.myEditor2, startLine1, endLine1, startLine2, endLine2);
            final Editor masterEditor = (Editor)masterSide.select((Object)this.myEditor1, (Object)this.myEditor2);
            final Editor slaveEditor = (Editor)slaveSide.select((Object)this.myEditor1, (Object)this.myEditor2);
            int masterOffset = masterSide.select(offsets.val1, offsets.val2);
            final int slaveOffset = slaveSide.select(offsets.val1, offsets.val2);
            int startOffset1 = this.myEditor1.getScrollingModel().getVisibleArea().y;
            int startOffset2 = this.myEditor2.getScrollingModel().getVisibleArea().y;
            final int masterStartOffset = masterSide.select(startOffset1, startOffset2);
            this.myHelper1.setAnchor(startOffset1, offsets.val1, startOffset2, offsets.val2);
            this.myHelper2.setAnchor(startOffset2, offsets.val2, startOffset1, offsets.val1);
            SyncScrollSupport.doScrollHorizontally(masterEditor, 0, false);
            SyncScrollSupport.doScrollVertically(masterEditor, masterOffset, animate);
            masterEditor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

                @Override
                public void run() {
                    TwosideSyncScrollSupport.this.myHelper1.removeAnchor();
                    TwosideSyncScrollSupport.this.myHelper2.removeAnchor();
                    int masterFinalOffset = masterEditor.getScrollingModel().getVisibleArea().y;
                    int slaveFinalOffset = slaveEditor.getScrollingModel().getVisibleArea().y;
                    if (slaveFinalOffset != slaveOffset) {
                        TwosideSyncScrollSupport.this.myDuringSyncScroll = true;
                        SyncScrollSupport.doScrollVertically(slaveEditor, slaveOffset, animate && masterFinalOffset == masterStartOffset);
                        slaveEditor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

                            @Override
                            public void run() {
                                TwosideSyncScrollSupport.this.myDuringSyncScroll = false;
                            }
                        });
                    }
                }
            });
        }
    }

    public static interface SyncScrollable {
        public boolean isSyncScrollEnabled();

        public int transfer(@NotNull Side var1, int var2);
    }
}

