/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.threeside;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.threeside.ThreesideTextContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewer
extends TextDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(ThreesideTextDiffViewer.class);
    @NotNull
    private final EditorFactory myEditorFactory;
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final ThreesideTextContentPanel myContentPanel;
    @NotNull
    private final List<EditorEx> myEditors;
    @NotNull
    private final List<DocumentContent> myActualContents;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener1;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener2;
    @NotNull
    protected final TextDiffViewerBase.MySetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final FocusTrackerSupport.ThreesideFocusTrackerSupport myFocusTrackerSupport;
    @Nullable
    private SyncScrollSupport.ThreesideSyncScrollSupport mySyncScrollSupport;

    public ThreesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "<init>"));
        }
        super(context, request);
        this.myEditorFactory = EditorFactory.getInstance();
        this.myVisibleAreaListener1 = new MyVisibleAreaListener(Side.LEFT);
        this.myVisibleAreaListener2 = new MyVisibleAreaListener(Side.RIGHT);
        List contents = this.myRequest.getContents();
        this.myActualContents = ContainerUtil.newArrayList((Object[])new DocumentContent[]{(DocumentContent)contents.get(0), (DocumentContent)contents.get(1), (DocumentContent)contents.get(2)});
        this.myEditors = this.createEditors();
        List<JComponent> titlePanel = DiffUtil.createTextTitles(this.myRequest, this.getEditors());
        this.myFocusTrackerSupport = new FocusTrackerSupport.ThreesideFocusTrackerSupport(this.getEditors());
        this.myContentPanel = new ThreesideTextContentPanel((List<? extends Editor>)this.getEditors(), titlePanel);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
        this.myEditorSettingsAction = new TextDiffViewerBase.MySetEditorSettingsAction();
        this.myEditorSettingsAction.applyDefaults();
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.destroyEditors();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @NotNull
    protected List<EditorEx> createEditors() {
        boolean[] forceReadOnly = this.checkForceReadOnly();
        ArrayList<EditorEx> editors = new ArrayList<EditorEx>(3);
        for (int i = 0; i < this.getActualContents().size(); ++i) {
            DocumentContent content = this.getActualContents().get(i);
            EditorEx editor = DiffUtil.createEditor(content.getDocument(), this.myProject, forceReadOnly[i], true);
            DiffUtil.configureEditor(editor, content, this.myProject);
            editors.add(editor);
            if (!Registry.is((String)"diff.divider.repainting.disable.blitting")) continue;
            editor.getScrollPane().getViewport().setScrollMode(0);
        }
        ((EditorEx)editors.get(0)).setVerticalScrollbarOrientation(0);
        ((EditorMarkupModel)((Object)((EditorEx)editors.get(1)).getMarkupModel())).setErrorStripeVisible(false);
        ArrayList<EditorEx> arrayList = editors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "createEditors"));
        }
        return arrayList;
    }

    private void destroyEditors() {
        for (EditorEx editorEx : this.getEditors()) {
            this.myEditorFactory.releaseEditor((Editor)editorEx);
        }
    }

    @Override
    protected void installEditorListeners() {
        super.installEditorListeners();
        this.getEditor(ThreeSide.LEFT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        SyncScrollSupport.SyncScrollable scrollable1 = this.getSyncScrollable(Side.LEFT);
        SyncScrollSupport.SyncScrollable scrollable2 = this.getSyncScrollable(Side.RIGHT);
        if (scrollable1 != null && scrollable2 != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.ThreesideSyncScrollSupport(this.getEditors(), scrollable1, scrollable2);
        }
    }

    @Override
    public void destroyEditorListeners() {
        super.destroyEditorListeners();
        this.getEditor(ThreeSide.LEFT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            this.mySyncScrollSupport.setDisabled(disable);
        }
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDividers();
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getComponent"));
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getCurrentEditor().getContentComponent();
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getEditor(this.getCurrentSide());
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getCurrentEditor"));
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        DocumentContent documentContent = (DocumentContent)this.getCurrentSide().select(this.getActualContents());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getCurrentContent"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List<EditorEx> list = this.myEditors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getEditors"));
        }
        return list;
    }

    @NotNull
    protected EditorEx getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getEditor"));
        }
        EditorEx editorEx = (EditorEx)side.select(this.myEditors);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getEditor"));
        }
        return editorEx;
    }

    @NotNull
    public List<DocumentContent> getActualContents() {
        List<DocumentContent> list = this.myActualContents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getActualContents"));
        }
        return list;
    }

    @NotNull
    public ThreeSide getCurrentSide() {
        ThreeSide threeSide = this.myFocusTrackerSupport.getCurrentSide();
        if (threeSide == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "getCurrentSide"));
        }
        return threeSide;
    }

    public void setCurrentSide(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "setCurrentSide"));
        }
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    protected void scrollToLine(@NotNull ThreeSide side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "scrollToLine"));
        }
        EditorEx editor = this.getEditor(side);
        DiffUtil.scrollEditor(editor, line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side var1);

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        EditorEx editor = this.getCurrentEditor();
        int offset = editor.getCaretModel().getOffset();
        return this.getCurrentContent().getOpenFileDescriptor(offset);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 3) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content : contents) {
            canShow &= ThreesideTextDiffViewer.canShowContent(content);
            wantShow |= ThreesideTextDiffViewer.wantShowContent(content);
        }
        return canShow && wantShow;
    }

    public static boolean canShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "canShowContent"));
        }
        return content instanceof DocumentContent;
    }

    public static boolean wantShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer", "wantShowContent"));
        }
        return content instanceof DocumentContent;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return DiffUtil.getVirtualFile(this.myRequest, this.getCurrentSide());
        }
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getCurrentContent();
        }
        return super.getData(dataId);
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.ThreesideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = ThreesideTextDiffViewer.this.getEditors();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
            ThreesideTextDiffViewer.this.disableSyncScrollSupport(value);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            ThreeSide side = (ThreeSide)this.myScrollToLine.first;
            Integer line = (Integer)this.myScrollToLine.second;
            if (ThreesideTextDiffViewer.this.getEditor(side) == null) {
                return false;
            }
            ThreesideTextDiffViewer.this.scrollToLine(side, line);
            return true;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        @NotNull
        Side mySide;

        public MyVisibleAreaListener(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$MyVisibleAreaListener", "<init>"));
            }
            this.mySide = side;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (ThreesideTextDiffViewer.this.mySyncScrollSupport != null) {
                ThreesideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e);
            }
            if (Registry.is((String)"diff.divider.repainting.fix")) {
                ThreesideTextDiffViewer.this.myContentPanel.repaint();
            } else {
                ThreesideTextDiffViewer.this.myContentPanel.repaintDivider(this.mySide);
            }
        }
    }

    protected class ShowPartialDiffAction
    extends DumbAwareAction {
        @NotNull
        private final ThreeSide mySide1;
        @NotNull
        private final ThreeSide mySide2;

        public ShowPartialDiffAction(@NotNull ThreeSide side1, @NotNull ThreeSide side2, @Nullable String text, @NotNull String description, Icon icon) {
            if (side1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (side2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/diff/tools/util/threeside/ThreesideTextDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            super(text, description, icon);
            this.mySide1 = side1;
            this.mySide2 = side2;
        }

        public void actionPerformed(AnActionEvent e) {
            List contents = ThreesideTextDiffViewer.this.myRequest.getContents();
            List titles = ThreesideTextDiffViewer.this.myRequest.getContentTitles();
            SimpleDiffRequest request = new SimpleDiffRequest(ThreesideTextDiffViewer.this.myRequest.getTitle(), (DiffContent)this.mySide1.select(contents), (DiffContent)this.mySide2.select(contents), (String)this.mySide1.select(titles), (String)this.mySide2.select(titles));
            DiffManager.getInstance().showDiff(ThreesideTextDiffViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ThreesideTextDiffViewer.this.myPanel));
        }
    }

    protected class ShowLeftRightPartialDiffAction
    extends ShowPartialDiffAction {
        public ShowLeftRightPartialDiffAction() {
            super(ThreeSide.LEFT, ThreeSide.RIGHT, DiffBundle.message((String)"merge.partial.diff.action.name", (Object[])new Object[0]), null, AllIcons.Diff.BranchDiff);
        }
    }

    protected class ShowBaseRightPartialDiffAction
    extends ShowPartialDiffAction {
        public ShowBaseRightPartialDiffAction() {
            super(ThreeSide.BASE, ThreeSide.RIGHT, DiffBundle.message((String)"merge.partial.diff.action.name.1.2", (Object[])new Object[0]), null, AllIcons.Diff.RightDiff);
        }
    }

    protected class ShowLeftBasePartialDiffAction
    extends ShowPartialDiffAction {
        public ShowLeftBasePartialDiffAction() {
            super(ThreeSide.LEFT, ThreeSide.BASE, DiffBundle.message((String)"merge.partial.diff.action.name.0.1", (Object[])new Object[0]), null, AllIcons.Diff.LeftDiff);
        }
    }
}

