/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.twoside;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.twoside.TwosideTextContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwosideTextDiffViewer
extends TextDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(TwosideTextDiffViewer.class);
    @NotNull
    private final EditorFactory myEditorFactory;
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final TwosideTextContentPanel myContentPanel;
    @Nullable
    private final EditorEx myEditor1;
    @Nullable
    private final EditorEx myEditor2;
    @Nullable
    private final DocumentContent myActualContent1;
    @Nullable
    private final DocumentContent myActualContent2;
    @NotNull
    protected final TextDiffViewerBase.MySetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener;
    @NotNull
    private final FocusTrackerSupport.TwosideFocusTrackerSupport myFocusTrackerSupport;
    @Nullable
    protected SyncScrollSupport.TwosideSyncScrollSupport mySyncScrollSupport;

    public TwosideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "<init>"));
        }
        super(context, request);
        this.myEditorFactory = EditorFactory.getInstance();
        this.myVisibleAreaListener = new MyVisibleAreaListener();
        List contents = this.myRequest.getContents();
        this.myActualContent1 = contents.get(0) instanceof DocumentContent ? (DocumentContent)contents.get(0) : null;
        DocumentContent documentContent = this.myActualContent2 = contents.get(1) instanceof DocumentContent ? (DocumentContent)contents.get(1) : null;
        assert (this.myActualContent1 != null || this.myActualContent2 != null);
        List<EditorEx> editors = this.createEditors();
        List<JComponent> titlePanel = DiffUtil.createTextTitles(this.myRequest, editors);
        this.myEditor1 = editors.get(0);
        this.myEditor2 = editors.get(1);
        assert (this.myEditor1 != null || this.myEditor2 != null);
        this.myFocusTrackerSupport = new FocusTrackerSupport.TwosideFocusTrackerSupport(this.getEditor1(), this.getEditor2());
        this.myContentPanel = new TwosideTextContentPanel(titlePanel, this.getEditor1(), this.getEditor2());
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
        new MyFocusOppositePaneAction(true).setupAction(this.myPanel);
        new MyFocusOppositePaneAction(false).setupAction(this.myPanel);
        this.myEditorSettingsAction = new TextDiffViewerBase.MySetEditorSettingsAction();
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().register(this.getEditors());
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.destroyEditors();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @NotNull
    protected List<EditorEx> createEditors() {
        boolean[] forceReadOnly = this.checkForceReadOnly();
        EditorEx editor1 = null;
        EditorEx editor2 = null;
        if (this.getActualContent1() != null) {
            editor1 = DiffUtil.createEditor(this.getActualContent1().getDocument(), this.myProject, forceReadOnly[0], true);
            DiffUtil.configureEditor(editor1, this.getActualContent1(), this.myProject);
        }
        if (this.getActualContent2() != null) {
            editor2 = DiffUtil.createEditor(this.getActualContent2().getDocument(), this.myProject, forceReadOnly[1], true);
            DiffUtil.configureEditor(editor2, this.getActualContent2(), this.myProject);
        }
        if (editor1 != null && editor2 != null) {
            editor1.setVerticalScrollbarOrientation(0);
        }
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            if (editor1 != null) {
                editor1.getScrollPane().getViewport().setScrollMode(0);
            }
            if (editor2 != null) {
                editor2.getScrollPane().getViewport().setScrollMode(0);
            }
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new EditorEx[]{editor1, editor2});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "createEditors"));
        }
        return arrayList;
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDivider();
    }

    private void destroyEditors() {
        if (this.getEditor1() != null) {
            this.myEditorFactory.releaseEditor((Editor)this.getEditor1());
        }
        if (this.getEditor2() != null) {
            this.myEditorFactory.releaseEditor((Editor)this.getEditor2());
        }
    }

    @Override
    protected void installEditorListeners() {
        SyncScrollSupport.SyncScrollable scrollable;
        super.installEditorListeners();
        if (this.getEditor1() != null) {
            this.getEditor1().getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        }
        if (this.getEditor2() != null) {
            this.getEditor2().getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        }
        if (this.getEditor1() != null && this.getEditor2() != null && (scrollable = this.getSyncScrollable()) != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.TwosideSyncScrollSupport(this.getEditor1(), this.getEditor2(), scrollable);
        }
    }

    @Override
    protected void destroyEditorListeners() {
        super.destroyEditorListeners();
        if (this.getEditor1() != null) {
            this.getEditor1().getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        }
        if (this.getEditor2() != null) {
            this.getEditor2().getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        }
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            this.mySyncScrollSupport.setDisabled(disable);
        }
    }

    @Override
    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List list = ContainerUtil.list((Object[])new EditorEx[]{this.getEditor1(), this.getEditor2()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getEditors"));
        }
        return list;
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getComponent"));
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getCurrentEditor().getContentComponent();
    }

    @NotNull
    public Side getCurrentSide() {
        Side side = this.myFocusTrackerSupport.getCurrentSide();
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getCurrentSide"));
        }
        return side;
    }

    public void setCurrentSide(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "setCurrentSide"));
        }
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getEditor(this.getCurrentSide());
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getCurrentEditor"));
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        DocumentContent documentContent = this.getActualContent(this.getCurrentSide());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getCurrentContent"));
        }
        return documentContent;
    }

    @Nullable
    protected EditorEx getEditor1() {
        return this.myEditor1;
    }

    @Nullable
    protected EditorEx getEditor2() {
        return this.myEditor2;
    }

    @Nullable
    protected EditorEx getEditor(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getEditor"));
        }
        return (EditorEx)side.select((Object)this.myEditor1, (Object)this.myEditor2);
    }

    @Nullable
    public DocumentContent getActualContent1() {
        return this.myActualContent1;
    }

    @Nullable
    public DocumentContent getActualContent2() {
        return this.myActualContent2;
    }

    @Nullable
    protected DocumentContent getActualContent(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getActualContent"));
        }
        return (DocumentContent)side.select((Object)this.myActualContent1, (Object)this.myActualContent2);
    }

    @NotNull
    protected LogicalPosition transferPosition(@NotNull Side baseSide, @NotNull LogicalPosition position) {
        if (baseSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseSide", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "transferPosition"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "transferPosition"));
        }
        if (this.mySyncScrollSupport == null) {
            LogicalPosition logicalPosition = position;
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "transferPosition"));
            }
            return logicalPosition;
        }
        int line = this.mySyncScrollSupport.getScrollable().transfer(baseSide, position.line);
        LogicalPosition logicalPosition = new LogicalPosition(line, position.column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "transferPosition"));
        }
        return logicalPosition;
    }

    protected void scrollToLine(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "scrollToLine"));
        }
        EditorEx editor = this.getEditor(side);
        if (editor == null) {
            return;
        }
        DiffUtil.scrollEditor(editor, line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable();

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        EditorEx editor = this.getCurrentEditor();
        int offset = editor.getCaretModel().getOffset();
        return this.getCurrentContent().getOpenFileDescriptor(offset);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content : contents) {
            canShow &= TwosideTextDiffViewer.canShowContent(content);
            wantShow |= TwosideTextDiffViewer.wantShowContent(content);
        }
        return canShow && wantShow;
    }

    public static boolean canShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "canShowContent"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        return content instanceof DocumentContent;
    }

    public static boolean wantShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "wantShowContent"));
        }
        return content instanceof DocumentContent;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getCurrentContent();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return DiffUtil.getVirtualFile(this.myRequest, this.getCurrentSide());
        }
        return super.getData(dataId);
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = TwosideTextDiffViewer.this.getEditors();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
            TwosideTextDiffViewer.this.disableSyncScrollSupport(value);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            Side side = (Side)this.myScrollToLine.first;
            Integer line = (Integer)this.myScrollToLine.second;
            if (TwosideTextDiffViewer.this.getEditor(side) == null) {
                return false;
            }
            TwosideTextDiffViewer.this.scrollToLine(side, line);
            return true;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (TwosideTextDiffViewer.this.mySyncScrollSupport != null) {
                TwosideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e);
            }
            if (Registry.is((String)"diff.divider.repainting.fix")) {
                TwosideTextDiffViewer.this.myContentPanel.repaint();
            } else {
                TwosideTextDiffViewer.this.myContentPanel.repaintDivider();
            }
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected OpenFileDescriptor getDescriptor(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$MyOpenInEditorWithMouseAction", "getDescriptor"));
            }
            if (editor != TwosideTextDiffViewer.this.getEditor1() && editor != TwosideTextDiffViewer.this.getEditor2()) {
                return null;
            }
            Side side = Side.fromLeft((editor == TwosideTextDiffViewer.this.getEditor1() ? 1 : 0) != 0);
            DocumentContent content = TwosideTextDiffViewer.this.getActualContent(side);
            if (content == null) {
                return null;
            }
            int offset = editor.logicalPositionToOffset(new LogicalPosition(line, 0));
            return content.getOpenFileDescriptor(offset);
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        public MyFocusOppositePaneAction(boolean scrollToPosition) {
            super(scrollToPosition);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
            }
            if (TwosideTextDiffViewer.this.getEditor1() == null || TwosideTextDiffViewer.this.getEditor2() == null) {
                return;
            }
            if (this.myScrollToPosition) {
                EditorEx currentEditor = (EditorEx)TwosideTextDiffViewer.this.getCurrentSide().select((Object)TwosideTextDiffViewer.this.getEditor1(), (Object)TwosideTextDiffViewer.this.getEditor2());
                EditorEx targetEditor = (EditorEx)TwosideTextDiffViewer.this.getCurrentSide().other().select((Object)TwosideTextDiffViewer.this.getEditor1(), (Object)TwosideTextDiffViewer.this.getEditor2());
                LogicalPosition position = TwosideTextDiffViewer.this.transferPosition(TwosideTextDiffViewer.this.getCurrentSide(), currentEditor.getCaretModel().getLogicalPosition());
                targetEditor.getCaretModel().moveToLogicalPosition(position);
            }
            TwosideTextDiffViewer.this.setCurrentSide(TwosideTextDiffViewer.this.getCurrentSide().other());
            TwosideTextDiffViewer.this.myContext.requestFocus();
            TwosideTextDiffViewer.this.getCurrentEditor().getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }
}

