/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleFoldingSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AddEditDeleteListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleFoldingConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myMainComponent;
    private MyAddDeleteListPanel myPositivePanel;
    private MyAddDeleteListPanel myNegativePanel;
    private final ConsoleFoldingSettings mySettings = ConsoleFoldingSettings.getSettings();

    public JComponent createComponent() {
        if (this.myMainComponent == null) {
            this.myMainComponent = new JPanel(new BorderLayout());
            Splitter splitter = new Splitter(true);
            this.myMainComponent.add((Component)splitter);
            this.myPositivePanel = new MyAddDeleteListPanel("Fold console lines that contain", "Enter a substring of a console line you'd like to see folded:");
            this.myNegativePanel = new MyAddDeleteListPanel("Exceptions", "Enter a substring of a console line you don't want to fold:");
            splitter.setFirstComponent((JComponent)((Object)this.myPositivePanel));
            splitter.setSecondComponent((JComponent)((Object)this.myNegativePanel));
            this.myPositivePanel.getEmptyText().setText("Fold nothing");
            this.myNegativePanel.getEmptyText().setText("No exceptions");
        }
        return this.myMainComponent;
    }

    public void addRule(@NotNull String rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/execution/console/ConsoleFoldingConfigurable", "addRule"));
        }
        this.myPositivePanel.addRule(rule);
    }

    public boolean isModified() {
        return !Arrays.asList(this.myNegativePanel.getListItems()).equals(this.mySettings.getNegativePatterns()) || !Arrays.asList(this.myPositivePanel.getListItems()).equals(this.mySettings.getPositivePatterns());
    }

    public void apply() throws ConfigurationException {
        this.myNegativePanel.applyTo(this.mySettings.getNegativePatterns());
        this.myPositivePanel.applyTo(this.mySettings.getPositivePatterns());
    }

    public void reset() {
        this.myNegativePanel.resetFrom(this.mySettings.getNegativePatterns());
        this.myPositivePanel.resetFrom(this.mySettings.getPositivePatterns());
    }

    public void disposeUIResources() {
        this.myMainComponent = null;
        this.myNegativePanel = null;
        this.myPositivePanel = null;
    }

    @NotNull
    public String getId() {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleFoldingConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Console Folding";
    }

    public String getHelpTopic() {
        return "reference.idesettings.console.folding";
    }

    private static class MyAddDeleteListPanel
    extends AddEditDeleteListPanel<String> {
        private final String myQuery;

        public MyAddDeleteListPanel(String title, String query) {
            super(title, new ArrayList());
            this.myQuery = query;
        }

        @Nullable
        protected String findItemToAdd() {
            return this.showEditDialog("");
        }

        @Nullable
        private String showEditDialog(String initialValue) {
            return Messages.showInputDialog((Component)((Object)this), (String)this.myQuery, (String)"Folding Pattern", (Icon)Messages.getQuestionIcon(), (String)initialValue, (InputValidator)new InputValidatorEx(){

                public boolean checkInput(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                public boolean canClose(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                @Nullable
                public String getErrorText(String inputString) {
                    if (!this.checkInput(inputString)) {
                        return "Console folding rule string cannot be empty";
                    }
                    return null;
                }
            });
        }

        void resetFrom(List<String> patterns) {
            this.myListModel.clear();
            for (String pattern : patterns) {
                this.myListModel.addElement(pattern);
            }
        }

        void applyTo(List<String> patterns) {
            patterns.clear();
            for (Object o : this.getListItems()) {
                patterns.add((String)o);
            }
        }

        public void addRule(String rule) {
            this.addElement(rule);
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
        }

        protected String editSelectedItem(String item) {
            return this.showEditDialog(item);
        }
    }
}

