/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectRunConfigurationManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/runConfigurations/", scheme=StorageScheme.DIRECTORY_BASED, stateSplitter=RunConfigurationStateSplitter.class)})
public class ProjectRunConfigurationManager
implements PersistentStateComponent<Element> {
    private final RunManagerImpl myManager;
    private List<Element> myUnloadedElements;

    public ProjectRunConfigurationManager(@NotNull RunManagerImpl manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/execution/impl/ProjectRunConfigurationManager", "<init>"));
        }
        this.myManager = manager;
    }

    public Element getState() {
        Element state = new Element("state");
        for (RunnerAndConfigurationSettings configuration : this.myManager.getStableConfigurations(true)) {
            this.myManager.addConfigurationElement(state, configuration);
        }
        if (!ContainerUtil.isEmpty(this.myUnloadedElements)) {
            for (Element unloadedElement : this.myUnloadedElements) {
                state.addContent(unloadedElement.clone());
            }
        }
        return state;
    }

    public void loadState(Element state) {
        if (this.myUnloadedElements != null) {
            this.myUnloadedElements.clear();
        }
        THashSet existing = new THashSet();
        Iterator iterator = state.getChildren().iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.myManager.loadConfiguration(child, true);
            if (runnerAndConfigurationSettings != null) {
                existing.add(runnerAndConfigurationSettings.getUniqueID());
                continue;
            }
            if (!child.getName().equals("configuration")) continue;
            if (this.myUnloadedElements == null) {
                this.myUnloadedElements = new SmartList();
            }
            iterator.remove();
            this.myUnloadedElements.add(child);
        }
        this.myManager.removeNotExistingSharedConfigurations((Set<String>)existing);
        if (this.myManager.getSelectedConfiguration() == null) {
            List<RunConfiguration> allConfigurations = this.myManager.getAllConfigurationsList();
            for (RunConfiguration runConfiguration : allConfigurations) {
                RunnerAndConfigurationSettings settings = this.myManager.getSettings(allConfigurations.get(0));
                if (runConfiguration instanceof UnknownRunConfiguration) continue;
                this.myManager.setSelectedConfiguration(settings);
                break;
            }
        }
        this.myManager.setOrdered(false);
        this.myManager.getSortedConfigurations();
    }

    static class RunConfigurationStateSplitter
    extends StateSplitterEx {
        RunConfigurationStateSplitter() {
        }

        public List<Pair<Element, String>> splitState(@NotNull Element state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/impl/ProjectRunConfigurationManager$RunConfigurationStateSplitter", "splitState"));
            }
            return RunConfigurationStateSplitter.splitState((Element)state, (String)"name");
        }
    }
}

