/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerInfo
extends LineMarkerInfo<PsiElement> {
    private final PsiElement myElement;

    public RunLineMarkerInfo(PsiElement element, Icon icon, Function<? super PsiElement, String> tooltipProvider) {
        super(element, element.getTextOffset(), icon, 4, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER);
        this.myElement = element;
    }

    @Nullable
    public GutterIconRenderer createGutterRenderer() {
        return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

            public boolean isNavigateAction() {
                return true;
            }

            @NotNull
            public ActionGroup getPopupMenuActions() {
                ArrayList<Separator> actions = new ArrayList<Separator>();
                Object[] executors = ExecutorRegistry.getInstance().getRegisteredExecutors();
                actions.addAll(ContainerUtil.mapNotNull((Object[])executors, (Function)new Function<Executor, AnAction>(){

                    public AnAction fun(Executor executor) {
                        return ActionManager.getInstance().getAction(executor.getContextActionId());
                    }
                }));
                actions.add(Separator.getInstance());
                actions.addAll(ContainerUtil.mapNotNull((Collection)RunLineMarkerContributor.EXTENSION.allForLanguage(RunLineMarkerInfo.this.myElement.getLanguage()), (Function)new NullableFunction<RunLineMarkerContributor, AnAction>(){

                    @Nullable
                    public AnAction fun(RunLineMarkerContributor contributor) {
                        return contributor.getAdditionalAction(RunLineMarkerInfo.this.myElement);
                    }
                }));
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(actions);
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/RunLineMarkerInfo$1", "getPopupMenuActions"));
                }
                return defaultActionGroup;
            }

            public AnAction getClickAction() {
                return null;
            }
        };
    }
}

