/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectInContextImpl
implements SelectInContext {
    protected final PsiFile myPsiFile;

    protected SelectInContextImpl(PsiFile psiFile) {
        this.myPsiFile = psiFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPsiFile.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInContextImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInContextImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    public Object getSelectorInFile() {
        return this.myPsiFile;
    }

    @Nullable
    public static SelectInContext createContext(AnActionEvent event) {
        VirtualFile file;
        Navigatable descriptor;
        DataContext dataContext = event.getDataContext();
        SelectInContext result = SelectInContextImpl.createEditorContext(dataContext);
        if (result != null) {
            return result;
        }
        JComponent sourceComponent = SelectInContextImpl.getEventComponent(event);
        if (sourceComponent == null) {
            return null;
        }
        SelectInContext selectInContext = (SelectInContext)SelectInContext.DATA_KEY.getData(dataContext);
        if (selectInContext == null) {
            selectInContext = SelectInContextImpl.createPsiContext(event);
        }
        if (selectInContext == null && (descriptor = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(dataContext)) instanceof OpenFileDescriptor && (file = ((OpenFileDescriptor)descriptor).getFile()).isValid()) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            selectInContext = OpenFileDescriptorContext.create(project, file);
        }
        if (selectInContext == null) {
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (virtualFile != null && project != null) {
                return new VirtualFileSelectInContext(project, virtualFile);
            }
        }
        return selectInContext;
    }

    @Nullable
    private static SelectInContext createEditorContext(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        return SelectInContextImpl.doCreateEditorContext(project, editor, dataContext);
    }

    public static SelectInContext createEditorContext(Project project, FileEditor editor) {
        return SelectInContextImpl.doCreateEditorContext(project, editor, null);
    }

    private static SelectInContext doCreateEditorContext(Project project, FileEditor editor, @Nullable DataContext dataContext) {
        Object selectorInFile;
        PsiFile psiFile;
        if (project == null || editor == null) {
            return null;
        }
        VirtualFile file = FileEditorManagerEx.getInstanceEx(project).getFile(editor);
        if (file == null) {
            VirtualFile virtualFile = file = dataContext == null ? null : (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
            if (file == null) {
                return null;
            }
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) {
            return null;
        }
        if (editor instanceof TextEditor) {
            return new TextEditorContext((TextEditor)editor, psiFile);
        }
        StructureViewBuilder builder = editor.getStructureViewBuilder();
        StructureView structureView = builder != null ? builder.createStructureView(editor, project) : null;
        Object object = selectorInFile = structureView != null ? structureView.getTreeModel().getCurrentEditorElement() : null;
        if (structureView != null) {
            Disposer.dispose((Disposable)structureView);
        }
        return new SimpleSelectInContext(psiFile, ObjectUtils.chooseNotNull((Object)selectorInFile, (Object)psiFile));
    }

    @Nullable
    private static SelectInContext createPsiContext(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return new SimpleSelectInContext(psiFile, psiElement);
    }

    @Nullable
    private static JComponent getEventComponent(AnActionEvent event) {
        Object source;
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent != null && (source = inputEvent.getSource()) instanceof JComponent) {
            return (JComponent)source;
        }
        return SelectInContextImpl.safeCast(PlatformDataKeys.CONTEXT_COMPONENT.getData(event.getDataContext()), JComponent.class);
    }

    @Nullable
    private static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    private static class VirtualFileSelectInContext
    implements SelectInContext {
        private final Project myProject;
        private final VirtualFile myVirtualFile;

        public VirtualFileSelectInContext(Project project, VirtualFile virtualFile) {
            this.myProject = project;
            this.myVirtualFile = virtualFile;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInContextImpl$VirtualFileSelectInContext", "getProject"));
            }
            return project;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInContextImpl$VirtualFileSelectInContext", "getVirtualFile"));
            }
            return virtualFile;
        }

        @Nullable
        public Object getSelectorInFile() {
            return this.myVirtualFile;
        }

        @Nullable
        public FileEditorProvider getFileEditorProvider() {
            return null;
        }
    }

    private static class SimpleSelectInContext
    extends SelectInContextImpl {
        private final Object mySelector;

        public SimpleSelectInContext(PsiFile psiFile, Object selector) {
            super(psiFile);
            this.mySelector = selector;
        }

        @Override
        public Object getSelectorInFile() {
            return this.mySelector;
        }

        public FileEditorProvider getFileEditorProvider() {
            return new FileEditorProvider(){

                public FileEditor openFileEditor() {
                    VirtualFile file = SimpleSelectInContext.this.myPsiFile.getVirtualFile();
                    if (file == null) {
                        return null;
                    }
                    return (FileEditor)ArrayUtil.getFirstElement((Object[])FileEditorManager.getInstance((Project)SimpleSelectInContext.this.getProject()).openFile(file, false));
                }
            };
        }
    }

    private static class OpenFileDescriptorContext
    extends SelectInContextImpl {
        public OpenFileDescriptorContext(PsiFile psiFile) {
            super(psiFile);
        }

        public FileEditorProvider getFileEditorProvider() {
            return new FileEditorProvider(){

                public FileEditor openFileEditor() {
                    return FileEditorManager.getInstance((Project)OpenFileDescriptorContext.this.getProject()).openFile(OpenFileDescriptorContext.this.getVirtualFile(), false)[0];
                }
            };
        }

        @Nullable
        public static SelectInContext create(Project project, VirtualFile file) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return null;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return null;
            }
            return new OpenFileDescriptorContext(psiFile);
        }
    }

    private static class TextEditorContext
    extends SelectInContextImpl {
        private final TextEditor myEditor;

        public TextEditorContext(TextEditor editor, PsiFile psiFile) {
            super(psiFile);
            this.myEditor = editor;
        }

        public FileEditorProvider getFileEditorProvider() {
            return new FileEditorProvider(){

                public FileEditor openFileEditor() {
                    return TextEditorContext.this.myEditor;
                }
            };
        }

        @Override
        public Object getSelectorInFile() {
            if (this.myPsiFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                return super.getSelectorInFile();
            }
            Editor editor = this.myEditor.getEditor();
            int offset = TargetElementUtil.adjustOffset(this.myPsiFile, editor.getDocument(), editor.getCaretModel().getOffset());
            PsiElement element = this.myPsiFile.findElementAt(offset);
            return element != null ? element : super.getSelectorInFile();
        }
    }
}

