/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.ClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

public class MnemonicChooser
extends JPanel {
    private static final Color OCCUPIED_CELL_COLOR = new JBColor(new Color(250, 250, 139), new Color(103, 81, 51));
    private static final Color FREE_CELL_COLOR = new JBColor(LightColors.SLIGHTLY_GRAY, (Color)Gray._80);

    public MnemonicChooser() {
        super((LayoutManager)new VerticalFlowLayout());
        NonOpaquePanel numbers = new NonOpaquePanel((LayoutManager)new GridLayout(2, 5, 2, 2));
        for (char i = '1'; i <= '9'; i = (char)(i + '\u0001')) {
            numbers.add(new MnemonicLabel(i));
        }
        numbers.add(new MnemonicLabel('0'));
        NonOpaquePanel letters = new NonOpaquePanel((LayoutManager)new GridLayout(5, 6, 2, 2));
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            letters.add(new MnemonicLabel(c));
        }
        this.add((Component)numbers);
        this.add(new JSeparator());
        this.add((Component)letters);
        this.setBackground(UIUtil.getListBackground());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char typed;
                if (e.getKeyCode() == 27) {
                    MnemonicChooser.this.onCancelled();
                } else if (e.getModifiersEx() == 0 && ((typed = Character.toUpperCase(e.getKeyChar())) >= '0' && typed <= '9' || typed >= 'A' && typed <= 'Z')) {
                    MnemonicChooser.this.onMnemonicChosen(typed);
                }
            }
        });
        this.setFocusable(true);
    }

    protected boolean isOccupied(char c) {
        return false;
    }

    protected void onMnemonicChosen(char c) {
    }

    protected void onCancelled() {
    }

    private Color backgroundForMnemonic(char c) {
        return this.isOccupied(c) ? OCCUPIED_CELL_COLOR : FREE_CELL_COLOR;
    }

    private class MnemonicLabel
    extends JLabel {
        private MnemonicLabel(final char c) {
            this.setOpaque(true);
            this.setText(Character.toString(c));
            this.setBorder(new LineBorder((Color)new JBColor((Color)Gray._192, (Color)Gray._150), 1));
            this.setHorizontalAlignment(0);
            this.setBackground(MnemonicChooser.this.backgroundForMnemonic(c));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    MnemonicLabel.this.setForeground(UIUtil.getListSelectionForeground());
                    MnemonicLabel.this.setBackground(UIUtil.getListSelectionBackground());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MnemonicLabel.this.setForeground(UIUtil.getListForeground());
                    MnemonicLabel.this.setBackground(MnemonicChooser.this.backgroundForMnemonic(c));
                }
            });
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/actions/MnemonicChooser$MnemonicLabel$2", "onClick"));
                    }
                    MnemonicChooser.this.onMnemonicChosen(c);
                    return true;
                }
            }.installOn((Component)this);
        }
    }
}

