/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewSelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FavoritesProjectViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Favorites";
    private FavoritesTreeViewPanel myViewPanel;
    private final ProjectView myProjectView;
    private final FavoritesManager myFavoritesManager;
    private static final Logger LOG = Logger.getInstance((String)("#" + FavoritesProjectViewPane.class.getName()));

    protected FavoritesProjectViewPane(Project project, ProjectView projectView, FavoritesManager favoritesManager) {
        super(project);
        this.myProjectView = projectView;
        this.myFavoritesManager = favoritesManager;
        FavoritesListener favoritesListener = new FavoritesListener(){
            private boolean enabled = true;

            @Override
            public void rootsChanged() {
            }

            @Override
            public void listAdded(String listName) {
                this.refreshMySubIdsAndSelect(listName);
            }

            @Override
            public void listRemoved(String listName) {
                String selectedSubId = FavoritesProjectViewPane.this.getSubId();
                this.refreshMySubIdsAndSelect(selectedSubId);
            }

            private void refreshMySubIdsAndSelect(String listName) {
                if (this.enabled) {
                    try {
                        this.enabled = false;
                        FavoritesProjectViewPane.this.myProjectView.removeProjectPane(FavoritesProjectViewPane.this);
                        FavoritesProjectViewPane.this.myProjectView.addProjectPane(FavoritesProjectViewPane.this);
                        if (!FavoritesProjectViewPane.this.myFavoritesManager.getAvailableFavoritesListNames().contains(listName)) {
                            listName = null;
                        }
                        FavoritesProjectViewPane.this.myProjectView.changeView(FavoritesProjectViewPane.ID, listName);
                    }
                    finally {
                        this.enabled = true;
                    }
                }
            }
        };
        this.myFavoritesManager.addFavoritesListener(favoritesListener, this);
    }

    @Override
    public String getTitle() {
        return ID;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Toolwindows.ToolWindowFavorites;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane", "getId"));
        }
        return ID;
    }

    @Override
    public JComponent createComponent() {
        String subId = this.getSubId();
        LOG.assertTrue(subId != null, (Object)this.getSubIds());
        this.myViewPanel = new FavoritesTreeViewPanel(this.myProject);
        this.myTree = this.myViewPanel.getTree();
        this.setTreeBuilder(this.myViewPanel.getBuilder());
        this.myTreeStructure = this.myViewPanel.getFavoritesTreeStructure();
        this.installComparator();
        this.enableDnD();
        return this.myViewPanel;
    }

    @Override
    public void dispose() {
        this.myViewPanel = null;
        super.dispose();
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        String[] stringArray = ArrayUtil.toStringArray(this.myFavoritesManager.getAvailableFavoritesListNames());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane", "getSubIds"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subId", "com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane", "getPresentableSubIdName"));
        }
        String string = subId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane", "getPresentableSubIdName"));
        }
        return string;
    }

    @Override
    @NotNull
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        ActionCallback actionCallback = ((FavoritesViewTreeBuilder)this.getTreeBuilder()).updateFromRootCB();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane", "updateFromRoot"));
        }
        return actionCallback;
    }

    @Override
    public void select(Object object, VirtualFile file, boolean requestFocus) {
        if (!(object instanceof PsiElement)) {
            return;
        }
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((PsiElement)object));
        String list = FavoritesViewSelectInTarget.findSuitableFavoritesList(virtualFile, this.myProject, this.getSubId());
        if (list == null) {
            return;
        }
        if (!list.equals(this.getSubId())) {
            ProjectView.getInstance(this.myProject).changeView(ID, list);
        }
        this.myViewPanel.selectElement(object, virtualFile, requestFocus);
    }

    @Override
    public int getWeight() {
        return 4;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new FavoritesViewSelectInTarget(this.myProject);
    }

    @Override
    public void addToolbarActions(DefaultActionGroup group) {
        group.add(ActionManager.getInstance().getAction("RenameFavoritesList"));
    }
}

