/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.actions.SaveFileAsTemplateHandler;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.Nullable;

public class SaveJavaAsTemplateHandler
implements SaveFileAsTemplateHandler {
    @Override
    @Nullable
    public String getTemplateText(PsiFile psiFile, String fileText, String nameWithoutExtension) {
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            String packageName = javaFile.getPackageName();
            if (packageName.length() > 0) {
                fileText = StringUtil.replace((String)fileText, (String)packageName, (String)"${PACKAGE_NAME}");
            }
            PsiClass[] classes = javaFile.getClasses();
            PsiClass psiClass = null;
            if (classes.length > 0) {
                for (PsiClass aClass : classes) {
                    if (!nameWithoutExtension.equals(aClass.getName())) continue;
                    psiClass = aClass;
                    break;
                }
            }
            if (psiClass != null) {
                return StringUtil.replace((String)fileText, (String)nameWithoutExtension, (String)"${NAME}");
            }
        }
        return null;
    }
}

