/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList hosts = ContainerUtil.newArrayList(UpdateSettings.getInstance().getPluginHosts());
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.add(null);
        ArrayList arrayList = hosts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "getPluginHosts"));
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPluginsFromAllRepositories(@Nullable ProgressIndicator indicator) throws IOException {
        ArrayList<IdeaPluginDescriptor> result = new ArrayList<IdeaPluginDescriptor>();
        HashSet<String> addedPluginIds = new HashSet<String>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            List<IdeaPluginDescriptor> plugins = RepositoryHelper.loadPlugins(host, null, indicator);
            for (IdeaPluginDescriptor plugin : plugins) {
                if (!addedPluginIds.add(plugin.getPluginId().getIdString())) continue;
                result.add(plugin);
            }
        }
        ArrayList<IdeaPluginDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPluginsFromAllRepositories"));
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable ProgressIndicator indicator) throws IOException {
        List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(null, null, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber buildnumber, @Nullable ProgressIndicator indicator) throws IOException {
        boolean forceHttps = repositoryUrl == null && IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(repositoryUrl, buildnumber, forceHttps, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber buildnumber, boolean forceHttps, final @Nullable ProgressIndicator indicator) throws IOException {
        File pluginListFile;
        URIBuilder uriBuilder;
        try {
            if (repositoryUrl == null) {
                uriBuilder = new URIBuilder(ApplicationInfoImpl.getShadowInstance().getPluginsListUrl());
                pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
                if (pluginListFile.length() > 0L) {
                    uriBuilder.addParameter("crc32", Files.hash((File)pluginListFile, (HashFunction)Hashing.crc32()).toString());
                }
            } else {
                uriBuilder = new URIBuilder(repositoryUrl);
                pluginListFile = null;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (!"file".equals(uriBuilder.getScheme())) {
            uriBuilder.addParameter("build", buildnumber != null ? buildnumber.asString() : ApplicationInfoImpl.getShadowInstance().getApiVersion());
        }
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{uriBuilder.getHost()}));
        }
        RequestBuilder request = HttpRequests.request((String)uriBuilder.toString()).forceHttps(forceHttps);
        List<IdeaPluginDescriptor> list = RepositoryHelper.process(repositoryUrl, (List)request.connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<IdeaPluginDescriptor>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<IdeaPluginDescriptor> process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/plugins/RepositoryHelper$1", "process"));
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                URLConnection connection = request.getConnection();
                if (pluginListFile != null && pluginListFile.length() > 0L && connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                    return RepositoryHelper.loadPluginList(pluginListFile);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{uriBuilder.getHost()}));
                }
                if (pluginListFile != null) {
                    Class<RepositoryHelper> clazz = RepositoryHelper.class;
                    synchronized (RepositoryHelper.class) {
                        FileUtil.ensureExists((File)pluginListFile.getParentFile());
                        request.saveToFile(pluginListFile, indicator);
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return RepositoryHelper.loadPluginList(pluginListFile);
                    }
                }
                return RepositoryHelper.parsePluginList(request.getReader());
            }
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    @Nullable
    public static List<IdeaPluginDescriptor> loadCachedPlugins() throws IOException {
        File file = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        return file.length() == 0L ? null : RepositoryHelper.loadPluginList(file);
    }

    private static List<IdeaPluginDescriptor> loadPluginList(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/RepositoryHelper", "loadPluginList"));
        }
        return RepositoryHelper.parsePluginList(new InputStreamReader((InputStream)new FileInputStream(file), CharsetToolkit.UTF8_CHARSET));
    }

    private static List<IdeaPluginDescriptor> parsePluginList(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/ide/plugins/RepositoryHelper", "parsePluginList"));
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            RepositoryContentHandler handler = new RepositoryContentHandler();
            parser.parse(new InputSource(reader), (DefaultHandler)handler);
            List<IdeaPluginDescriptor> list = handler.getPluginsList();
            return list;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            reader.close();
        }
    }

    private static List<IdeaPluginDescriptor> process(@Nullable String repositoryUrl, List<IdeaPluginDescriptor> list) {
        Iterator<IdeaPluginDescriptor> i = list.iterator();
        while (i.hasNext()) {
            PluginNode node = (PluginNode)i.next();
            if (node.getPluginId() == null || repositoryUrl != null && node.getDownloadUrl() == null) {
                LOG.warn("Malformed plugin record (id:" + node.getPluginId() + " repository:" + repositoryUrl + ")");
                i.remove();
                continue;
            }
            if (repositoryUrl != null) {
                node.setRepositoryName(repositoryUrl);
            }
            if (node.getName() != null) continue;
            String url = node.getDownloadUrl();
            String name = FileUtil.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1));
            node.setName(name);
        }
        return list;
    }
}

