/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewScratchFileAction
extends DumbAwareAction {
    private static final int MAX_VISIBLE_SIZE = 20;
    static Key<Boolean> IS_NEW_SCRATCH = Key.create((String)"IS_NEW_SCRATCH");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "update"));
        }
        e.getPresentation().setEnabledAndVisible(NewScratchFileAction.isEnabled(e));
    }

    public static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "isEnabled"));
        }
        return e.getProject() != null && Registry.is((String)"ide.scratch.enabled");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        String text = StringUtil.notNullize((String)this.getSelectionText(editor));
        Language language = (Language)ObjectUtils.notNull(text.isEmpty() ? null : this.getLanguageFromCaret(project, editor, file), (Object)StdLanguages.TEXT);
        NewScratchFileAction.openNewFile(project, language, text);
    }

    @Nullable
    public String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    public Language getLanguageFromCaret(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "getLanguageFromCaret"));
        }
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile, offset);
        PsiFile file = element != null ? element.getContainingFile() : psiFile;
        return file.getLanguage();
    }

    public static VirtualFile openNewFile(@NotNull Project project, @NotNull Language language, @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "openNewFile"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/NewScratchFileAction", "openNewFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/scratch/NewScratchFileAction", "openNewFile"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        NewScratchFileAction.storeLRULanguages(project, language);
        VirtualFile file = ScratchRootType.getInstance().createScratchFile(project, "scratch", language, text);
        if (file != null) {
            FileEditorManager.getInstance((Project)project).openFile(file, true);
            file.putUserData(IS_NEW_SCRATCH, (Object)Boolean.TRUE);
        }
        return file;
    }

    private static void storeLRULanguages(@NotNull Project project, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "storeLRULanguages"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/NewScratchFileAction", "storeLRULanguages"));
        }
        String[] values = PropertiesComponent.getInstance((Project)project).getValues(NewScratchFileAction.getLRUStoreKey());
        ArrayList lastUsed = ContainerUtil.newArrayListWithCapacity((int)5);
        lastUsed.add(language.getID());
        if (values != null) {
            for (String value : values) {
                if (!lastUsed.contains(value)) {
                    lastUsed.add(value);
                }
                if (lastUsed.size() == 5) break;
            }
        }
        PropertiesComponent.getInstance((Project)project).setValues(NewScratchFileAction.getLRUStoreKey(), ArrayUtil.toStringArray((Collection)lastUsed));
    }

    @NotNull
    private static List<String> restoreLRULanguages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "restoreLRULanguages"));
        }
        Object[] values = PropertiesComponent.getInstance((Project)project).getValues(NewScratchFileAction.getLRUStoreKey());
        List list = values == null ? ContainerUtil.emptyList() : ContainerUtil.list((Object[])values);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "restoreLRULanguages"));
        }
        return list;
    }

    private static String getLRUStoreKey() {
        return NewScratchFileAction.class.getName();
    }

    @NotNull
    public static ListPopup buildLanguageSelectionPopup(@NotNull Project project, @NotNull String title, @Nullable Language context, @NotNull Consumer<Language> onChosen) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        if (onChosen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        ListPopup listPopup = NewScratchFileAction.buildLanguageSelectionPopup(project, title, context, LanguageUtil.getFileLanguages(), onChosen);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        return listPopup;
    }

    @NotNull
    public static ListPopup buildLanguageSelectionPopup(@NotNull Project project, @NotNull String title, @Nullable Language context, @NotNull List<Language> languages, final @NotNull Consumer<Language> onChosen) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        if (languages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languages", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        if (onChosen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        final ArrayList ids = ContainerUtil.newArrayList(NewScratchFileAction.restoreLRULanguages(project));
        if (context != null) {
            ids.add(context.getID());
        }
        if (ids.isEmpty()) {
            ids.add(StdLanguages.TEXT.getID());
        }
        ContainerUtil.sort(languages, (Comparator)new Comparator<Language>(){

            @Override
            public int compare(@NotNull Language o1, @NotNull Language o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/scratch/NewScratchFileAction$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/scratch/NewScratchFileAction$1", "compare"));
                }
                int ind1 = ids.indexOf(o1.getID());
                int ind2 = ids.indexOf(o2.getID());
                if (ind1 == -1) {
                    ind1 = 666;
                }
                if (ind2 == -1) {
                    ind2 = 666;
                }
                return ind1 - ind2;
            }
        });
        BaseListPopupStep<Language> step = new BaseListPopupStep<Language>(title, languages){

            @NotNull
            public String getTextFor(@NotNull Language value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/scratch/NewScratchFileAction$2", "getTextFor"));
                }
                String string = value.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction$2", "getTextFor"));
                }
                return string;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(Language selectedValue, boolean finalChoice) {
                onChosen.consume((Object)selectedValue);
                return null;
            }

            public Icon getIconFor(@NotNull Language language) {
                if (language == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/NewScratchFileAction$2", "getIconFor"));
                }
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }
        };
        step.setDefaultOptionIndex(0);
        ListPopup listPopup = NewScratchFileAction.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguageSelectionPopup"));
        }
        return listPopup;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/scratch/NewScratchFileAction", "tweakSizeToPreferred"));
        }
        int nameLen = 0;
        ListPopupStep step = popup.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup.setSize(size);
        }
        ListPopup listPopup = popup;
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "tweakSizeToPreferred"));
        }
        return listPopup;
    }
}

