/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarculaTextBorder
implements Border,
UIResource {
    @Override
    public Insets getBorderInsets(Component c) {
        int vOffset;
        int n = vOffset = DarculaTextFieldUI.isSearchField(c) ? 6 : 4;
        if (DarculaTextFieldUI.isSearchFieldWithHistoryPopup(c)) {
            return JBUI.insets((int)vOffset, (int)26, (int)vOffset, (int)23).asUIResource();
        }
        if (DarculaTextFieldUI.isSearchField(c)) {
            return JBUI.insets((int)vOffset, (int)23, (int)vOffset, (int)23).asUIResource();
        }
        return JBUI.insets((int)vOffset, (int)7, (int)vOffset, (int)7).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (DarculaTextFieldUI.isSearchField(c)) {
            return;
        }
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        g.translate(x, y);
        if (c.hasFocus()) {
            DarculaUIUtil.paintFocusRing(g, 2, 2, width - 4, height - 4);
        } else {
            boolean editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
            g.setColor(DarculaTextBorder.getBorderColor(c.isEnabled() && editable));
            g.drawRect(1, 1, width - 2, height - 2);
        }
        g.translate(-x, -y);
        config.restore();
    }

    private static Color getBorderColor(boolean enabled) {
        if (UIUtil.isUnderDarcula()) {
            return enabled ? Gray._100 : Gray._83;
        }
        return Gray._150;
    }
}

