/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TreeElementWrapper
extends CachingChildrenTreeNode<TreeElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.smartTree.TreeElementWrapper");

    public TreeElementWrapper(Project project, TreeElement value, TreeModel treeModel) {
        super(project, value, treeModel);
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode oldInstance) {
        if (oldInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInstance", "com/intellij/ide/util/treeView/smartTree/TreeElementWrapper", "copyFromNewInstance"));
        }
    }

    public void update(PresentationData presentation) {
        if (((StructureViewTreeElement)this.getValue()).getValue() != null) {
            presentation.updateFrom(((TreeElement)this.getValue()).getPresentation());
        }
    }

    @Override
    public void initChildren() {
        Object[] children;
        this.clearChildren();
        TreeElement value = (TreeElement)this.getValue();
        for (TreeElement treeElement : children = value.getChildren()) {
            if (treeElement == null) {
                LOG.error(value + " returned null child: " + Arrays.toString(children));
            }
            this.addSubElement(this.createChildNode(treeElement));
        }
        if (this.myTreeModel instanceof ProvidingTreeModel) {
            Collection providers = ((ProvidingTreeModel)this.myTreeModel).getNodeProviders();
            for (NodeProvider provider : providers) {
                if (!((ProvidingTreeModel)this.myTreeModel).isEnabled(provider)) continue;
                Collection collection = provider.provideNodes(value);
                for (TreeElement node : collection) {
                    if (node == null) {
                        LOG.error(provider + " returned null node: " + collection);
                    }
                    this.addSubElement(this.createChildNode(node));
                }
            }
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }
}

