/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startupWizard.StartupWizard;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.SocketLock;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jna.Native;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.Nullable;

public class StartupUtil {
    public static final String NO_SPLASH = "nosplash";
    private static SocketLock ourLock;
    private static final String JAVA_IO_TEMP_DIR = "java.io.tmpdir";

    private StartupUtil() {
    }

    public static boolean shouldShowSplash(String[] args) {
        return !Arrays.asList(args).contains(NO_SPLASH);
    }

    public static synchronized void addExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        ourLock.setExternalInstanceListener(consumer);
    }

    public static synchronized int getAcquiredPort() {
        return ourLock.getAcquiredPort();
    }

    static void prepareAndStart(String[] args, AppStarter appStarter) {
        boolean newConfigFolder = false;
        if (!Main.isHeadless()) {
            AppUIUtil.updateFrameClass();
            boolean bl = newConfigFolder = !new File(PathManager.getConfigPath()).exists();
        }
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        if (!StartupUtil.checkSystemFolders()) {
            System.exit(5);
        }
        if (!StartupUtil.lockSystemFolders(args)) {
            System.exit(6);
        }
        if (newConfigFolder) {
            ConfigImportHelper.importConfigsTo(PathManager.getConfigPath());
        }
        Logger.setFactory(LoggerFactory.class);
        Logger log = Logger.getInstance(Main.class);
        StartupUtil.startLogging(log);
        StartupUtil.loadSystemLibraries(log);
        StartupUtil.fixProcessEnvironment(log);
        if (!Main.isHeadless()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
            AppUIUtil.registerBundledFonts();
        }
        appStarter.start(newConfigFolder);
    }

    private static boolean checkJdkVersion() {
        if (!"true".equals(System.getProperty("idea.no.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String message = "'tools.jar' seems to be not in " + ApplicationNamesInfo.getInstance().getProductName() + " classpath.\n" + "Please ensure JAVA_HOME points to JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            catch (LinkageError e) {
                String message = "Cannot load a class from 'tools.jar': " + e.getMessage() + "\n" + "Please ensure JAVA_HOME points to JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK") && !SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                String message = "OpenJDK 6 is not supported. Please use Oracle Java or newer OpenJDK.";
                Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
                return false;
            }
        }
        if (!"true".equals(System.getProperty("idea.no.64bit.check")) && PlatformUtils.isCidr() && !SystemInfo.is64Bit) {
            String message = "32-bit JVM is not supported. Please install 64-bit version.";
            Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    private static synchronized boolean checkSystemFolders() {
        String configPath = PathManager.getConfigPath();
        PathManager.ensureConfigFolderExists();
        if (!new File(configPath).isDirectory()) {
            String message = "Config path '" + configPath + "' is invalid.\n" + "If you have modified the '" + "idea.config.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config Path", (String)message, (boolean)true);
            return false;
        }
        String systemPath = PathManager.getSystemPath();
        if (!new File(systemPath).isDirectory()) {
            String message = "System path '" + systemPath + "' is invalid.\n" + "If you have modified the '" + "idea.system.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        File logDir = new File(PathManager.getLogPath());
        boolean logOk = false;
        if (logDir.isDirectory() || logDir.mkdirs()) {
            try {
                File ideTempFile = new File(logDir, "idea_log_check.txt");
                StartupUtil.write(ideTempFile, "log check");
                StartupUtil.delete(ideTempFile);
                logOk = true;
            }
            catch (IOException ideTempFile) {
                // empty catch block
            }
        }
        if (!logOk) {
            String message = "Log path '" + logDir.getPath() + "' is inaccessible.\n" + "If you have modified the '" + "idea.log.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Log Path", (String)message, (boolean)true);
            return false;
        }
        File ideTempDir = new File(PathManager.getTempPath());
        String tempInaccessible = null;
        if (!ideTempDir.isDirectory() && !ideTempDir.mkdirs()) {
            tempInaccessible = "unable to create the directory";
        } else {
            try {
                File ideTempFile = new File(ideTempDir, "idea_tmp_check.sh");
                StartupUtil.write(ideTempFile, "#!/bin/sh\nexit 0");
                if (SystemInfo.isWindows || SystemInfo.isMac) {
                    tempInaccessible = null;
                } else if (!ideTempFile.setExecutable(true, true)) {
                    tempInaccessible = "cannot set executable permission";
                } else if (new ProcessBuilder(ideTempFile.getAbsolutePath()).start().waitFor() != 0) {
                    tempInaccessible = "cannot execute test script";
                }
                StartupUtil.delete(ideTempFile);
            }
            catch (Exception e) {
                tempInaccessible = e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
        if (tempInaccessible != null) {
            String message = "Temp directory '" + ideTempDir + "' is inaccessible.\n" + "If you have modified the '" + "idea.system.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.\n\nDetails: " + tempInaccessible;
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    private static void write(File file, String content) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(content);
        }
        finally {
            writer.close();
        }
    }

    private static void delete(File ideTempFile) {
        if (!FileUtilRt.delete((File)ideTempFile)) {
            ideTempFile.deleteOnExit();
        }
    }

    private static synchronized boolean lockSystemFolders(String[] args) {
        if (Main.isHeadless()) {
            return true;
        }
        assert (ourLock == null);
        ourLock = new SocketLock();
        if (ourLock.getAcquiredPort() == -1) {
            return false;
        }
        SocketLock.ActivateStatus activateStatus = ourLock.lock(PathManager.getConfigPath(), PathManager.getSystemPath(), args);
        if (activateStatus != SocketLock.ActivateStatus.NO_INSTANCE) {
            if (Main.isHeadless() || activateStatus == SocketLock.ActivateStatus.CANNOT_ACTIVATE) {
                String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getFullProductName() + " can be run at a time.";
                Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
            }
            return false;
        }
        return true;
    }

    private static void fixProcessEnvironment(Logger log) {
        boolean envReady;
        if (!Main.isCommandLine()) {
            System.setProperty("__idea.mac.env.lock", "unlocked");
        }
        if (!(envReady = EnvironmentUtil.isEnvironmentReady())) {
            log.info("initializing environment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSystemLibraries(Logger log) {
        File ideTempDir = new File(PathManager.getTempPath());
        if (!ideTempDir.mkdirs() && !ideTempDir.exists()) {
            throw new RuntimeException("Unable to create temp directory '" + ideTempDir + "'");
        }
        String javaTempDir = System.getProperty(JAVA_IO_TEMP_DIR);
        try {
            System.setProperty(JAVA_IO_TEMP_DIR, ideTempDir.getPath());
            if (System.getProperty("jna.nosys") == null && System.getProperty("jna.nounpack") == null) {
                System.setProperty("jna.nosys", "true");
                System.setProperty("jna.nounpack", "false");
            }
            try {
                long t = System.currentTimeMillis();
                log.info("JNA library loaded (" + Native.POINTER_SIZE * 8 + "-bit) in " + (System.currentTimeMillis() - t) + " ms");
            }
            catch (Throwable t) {
                StartupUtil.logError(log, "Unable to load JNA library", t);
            }
        }
        finally {
            System.setProperty(JAVA_IO_TEMP_DIR, javaTempDir);
        }
        if (SystemInfo.isWin2kOrNewer) {
            IdeaWin32.isAvailable();
        }
        if (SystemInfo.isWin2kOrNewer && !Main.isHeadless()) {
            try {
                UrlClassLoader.loadPlatformLibrary((String)"focusKiller");
                log.info("Using \"FocusKiller\" library to prevent focus stealing.");
            }
            catch (Throwable t) {
                log.info("\"FocusKiller\" library not found or there were problems loading it.", t);
            }
        }
        if (SystemInfo.isWindows) {
            System.setProperty("winp.unpack.dll.to.parent.dir", "false");
        }
    }

    private static void logError(Logger log, String message, Throwable t) {
        message = message + " (OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + ")";
        log.error(message, t);
    }

    private static void startLogging(final Logger log) {
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook - logging"){

            @Override
            public void run() {
                log.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------");
            }
        });
        log.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:ss", Locale.US).format(appInfo.getBuildDate().getTime());
        log.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asStringWithAllDetails() + ", " + buildDate + ")");
        log.info("OS: " + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log.info("JVM Args: " + StringUtil.join(arguments, (String)" "));
        }
    }

    static void runStartupWizard() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String stepsProvider = appInfo.getCustomizeIDEWizardStepsProvider();
        if (stepsProvider != null) {
            CustomizeIDEWizardDialog.showCustomSteps(stepsProvider);
            PluginManagerCore.invalidatePlugins();
            return;
        }
        if (PlatformUtils.isIntelliJ()) {
            new CustomizeIDEWizardDialog().show();
            PluginManagerCore.invalidatePlugins();
            return;
        }
        List<ApplicationInfoEx.PluginChooserPage> pages = appInfo.getPluginChooserPages();
        if (!pages.isEmpty()) {
            StartupWizard startupWizard = new StartupWizard(pages);
            startupWizard.setCancelText("Skip");
            startupWizard.show();
            PluginManagerCore.invalidatePlugins();
        }
    }

    static interface AppStarter {
        public void start(boolean var1);
    }
}

