/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseFileConfigurableStoreImpl
extends ComponentStoreImpl {
    @NonNls
    protected static final String VERSION_OPTION = "version";
    @NonNls
    public static final String ATTRIBUTE_NAME = "name";
    private static final List<String> ourConversionProblemsStorage = new SmartList();
    private StateStorageManager myStateStorageManager;
    protected final PathMacroManager myPathMacroManager;

    protected BaseFileConfigurableStoreImpl(@NotNull PathMacroManager pathMacroManager) {
        if (pathMacroManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMacroManager", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl", "<init>"));
        }
        this.myPathMacroManager = pathMacroManager;
    }

    @NotNull
    protected abstract XmlElementStorage getMainStorage();

    @Nullable
    static List<String> getConversionProblemsStorage() {
        return ourConversionProblemsStorage;
    }

    @Override
    public void load() {
        this.getMainStorageData();
    }

    public BaseStorageData getMainStorageData() {
        return (BaseStorageData)this.getMainStorage().getStorageData();
    }

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        PathMacroManager pathMacroManager = this.myPathMacroManager;
        if (pathMacroManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl", "getPathMacroManagerForDefaults"));
        }
        return pathMacroManager;
    }

    @Override
    @NotNull
    public final StateStorageManager getStateStorageManager() {
        if (this.myStateStorageManager == null) {
            this.myStateStorageManager = this.createStateStorageManager();
        }
        StateStorageManager stateStorageManager = this.myStateStorageManager;
        if (stateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl", "getStateStorageManager"));
        }
        return stateStorageManager;
    }

    @NotNull
    protected abstract StateStorageManager createStateStorageManager();

    protected static class BaseStorageData
    extends StorageData {
        private int myVersion;

        public BaseStorageData(@NotNull String rootElementName) {
            if (rootElementName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "<init>"));
            }
            super(rootElementName);
            this.myVersion = 4;
        }

        protected BaseStorageData(BaseStorageData storageData) {
            super(storageData);
            this.myVersion = 4;
        }

        @Override
        public void load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "load"));
            }
            super.load(rootElement, pathMacroSubstitutor, intern);
            String v = rootElement.getAttributeValue(BaseFileConfigurableStoreImpl.VERSION_OPTION);
            this.myVersion = v == null ? 4 : Integer.parseInt(v);
        }

        @Override
        @NotNull
        protected final Element save(@NotNull Map<String, Element> newLiveStates) {
            if (newLiveStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "save"));
            }
            Element root = super.save(newLiveStates);
            if (root == null) {
                root = new Element(this.myRootElementName);
            }
            this.writeOptions(root, Integer.toString(this.myVersion));
            Element element = root;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "save"));
            }
            return element;
        }

        protected void writeOptions(@NotNull Element root, @NotNull String versionString) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "writeOptions"));
            }
            if (versionString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "writeOptions"));
            }
            root.setAttribute(BaseFileConfigurableStoreImpl.VERSION_OPTION, versionString);
        }

        @Override
        public StorageData clone() {
            return new BaseStorageData(this);
        }

        @Override
        @Nullable
        public Set<String> getChangedComponentNames(@NotNull StorageData newStorageData, @Nullable PathMacroSubstitutor substitutor) {
            if (newStorageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStorageData", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "getChangedComponentNames"));
            }
            BaseStorageData data = (BaseStorageData)newStorageData;
            if (this.myVersion != data.myVersion) {
                return null;
            }
            return super.getChangedComponentNames(newStorageData, substitutor);
        }
    }
}

