/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectWithModulesStoreImpl
extends ProjectStoreImpl {
    public ProjectWithModulesStoreImpl(@NotNull ProjectImpl project, @NotNull PathMacroManager pathMacroManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "<init>"));
        }
        if (pathMacroManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMacroManager", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "<init>"));
        }
        super(project, pathMacroManager);
    }

    @Override
    protected boolean reinitComponent(@NotNull String componentName, @NotNull Set<StateStorage> changedStorages) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "reinitComponent"));
        }
        if (changedStorages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedStorages", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "reinitComponent"));
        }
        if (super.reinitComponent(componentName, changedStorages)) {
            return true;
        }
        for (Module module : this.getPersistentModules()) {
            ((ModuleImpl)module).getStateStore().reinitComponent(componentName, changedStorages);
        }
        return true;
    }

    @Override
    @NotNull
    public TrackingPathMacroSubstitutor[] getSubstitutors() {
        SmartList result = new SmartList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)this.getStateStorageManager().getMacroSubstitutor());
        for (Module module : this.getPersistentModules()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((ModuleImpl)module).getStateStore().getStateStorageManager().getMacroSubstitutor());
        }
        TrackingPathMacroSubstitutor[] trackingPathMacroSubstitutorArray = result.toArray(new TrackingPathMacroSubstitutor[result.size()]);
        if (trackingPathMacroSubstitutorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "getSubstitutors"));
        }
        return trackingPathMacroSubstitutorArray;
    }

    @Override
    public boolean isReloadPossible(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "isReloadPossible"));
        }
        if (!super.isReloadPossible(componentNames)) {
            return false;
        }
        for (Module module : this.getPersistentModules()) {
            if (((ModuleImpl)module).getStateStore().isReloadPossible(componentNames)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected Module[] getPersistentModules() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] moduleArray = moduleManager == null ? Module.EMPTY_ARRAY : moduleManager.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "getPersistentModules"));
        }
        return moduleArray;
    }

    @Override
    protected void beforeSave(@NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "beforeSave"));
        }
        super.beforeSave(readonlyFiles);
        for (Module module : this.getPersistentModules()) {
            ((ModuleImpl)module).getStateStore().save(readonlyFiles);
        }
    }
}

