/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StoreUtil {
    private static final Logger LOG = Logger.getInstance(StoreUtil.class);

    private StoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(@NotNull IComponentStore stateStore, @Nullable Project project) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/intellij/openapi/components/impl/stores/StoreUtil", "save"));
        }
        ShutDownTracker.getInstance().registerStopperThread(Thread.currentThread());
        try {
            stateStore.save((List<Pair<StateStorage.SaveSession, VirtualFile>>)new SmartList());
        }
        catch (IComponentStore.SaveCancelledException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Save settings failed", e);
            } else {
                LOG.warn("Save settings failed", e);
            }
            String messagePostfix = " Please restart " + ApplicationNamesInfo.getInstance().getFullProductName() + "</p>" + (ApplicationManagerEx.getApplicationEx().isInternal() ? "<p>" + StringUtil.getThrowableText((Throwable)e) + "</p>" : "");
            PluginId pluginId = IdeErrorsDialog.findPluginId(e);
            if (pluginId == null) {
                new Notification("Settings Error", "Unable to save settings", "<p>Failed to save settings." + messagePostfix, NotificationType.ERROR).notify(project);
            } else {
                PluginManagerCore.disablePlugin(pluginId.getIdString());
                new Notification("Settings Error", "Unable to save plugin settings", "<p>The plugin <i>" + pluginId + "</i> failed to save settings and has been disabled." + messagePostfix, NotificationType.ERROR).notify(project);
            }
        }
        finally {
            ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
        }
    }

    @NotNull
    public static <T> State getStateSpec(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/StoreUtil", "getStateSpec"));
        }
        Class<?> componentClass = persistentStateComponent.getClass();
        State spec = StoreUtil.getStateSpec(componentClass);
        if (spec != null) {
            State state = spec;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StoreUtil", "getStateSpec"));
            }
            return state;
        }
        PluginId pluginId = PluginManagerCore.getPluginByClassName(componentClass.getName());
        if (pluginId == null) {
            throw new RuntimeException("No @State annotation found in " + componentClass);
        }
        throw new PluginException("No @State annotation found in " + componentClass, pluginId);
    }

    @Nullable
    public static State getStateSpec(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/components/impl/stores/StoreUtil", "getStateSpec"));
        }
        do {
            State stateSpec;
            if ((stateSpec = aClass.getAnnotation(State.class)) == null) continue;
            return stateSpec;
        } while ((aClass = aClass.getSuperclass()) != null);
        return null;
    }
}

