/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractColorsScheme
implements EditorColorsScheme {
    private static final String OS_VALUE_PREFIX = SystemInfo.isWindows ? "windows" : (SystemInfo.isMac ? "mac" : "linux");
    private static final int CURR_VERSION = 141;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    protected float myLineSpacing;
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);
    @NotNull
    private final FontPreferences myFontPreferences = new FontPreferences();
    @NotNull
    private final FontPreferences myConsoleFontPreferences = new FontPreferences();
    private String myFallbackFontName;
    private String mySchemeName;
    private float myConsoleLineSpacing = -1.0f;
    private int myVersion = 141;
    protected Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = ContainerUtilRt.newHashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    @Deprecated
    public static final Map<String, Color> DEFAULT_ERROR_STRIPE_COLOR = new THashMap();
    private static final Map<String, Couple<Color>> DEFAULT_STRIPE_COLORS = new THashMap<String, Couple<Color>>(){
        {
            this.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.red, (Object)ColorUtil.fromHex((String)"CF5B56")));
            this.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.yellow, (Object)ColorUtil.fromHex((String)"EBC700")));
            this.put("EXECUTIONPOINT_ATTRIBUTES", Couple.of((Object)Color.blue, (Object)ColorUtil.fromHex((String)"3763b0")));
            this.put(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"CCCFFF"), (Object)ColorUtil.fromHex((String)"BAA8FF")));
            this.put(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"FFCCE5"), (Object)ColorUtil.fromHex((String)"F0ADF0")));
            this.put(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"586E75"), (Object)ColorUtil.fromHex((String)"71B362")));
            this.put(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"268BD2"), (Object)ColorUtil.fromHex((String)"54AAE3")));
        }
    };

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
        this.myFontPreferences.setChangeListener(new Runnable(){

            @Override
            public void run() {
                AbstractColorsScheme.this.initFonts();
            }
        });
    }

    public AbstractColorsScheme() {
    }

    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultBackground"));
        }
        return color;
    }

    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultForeground"));
        }
        return color;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getName"));
        }
        return string;
    }

    public void setFont(EditorFontType key, Font font) {
        this.myFonts.put(key, font);
    }

    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        this.myFontPreferences.copyTo(newScheme.myFontPreferences);
        newScheme.myLineSpacing = this.myLineSpacing;
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        this.myConsoleFontPreferences.copyTo(newScheme.myConsoleFontPreferences);
        newScheme.myConsoleLineSpacing = this.myConsoleLineSpacing;
        Set<EditorFontType> types = this.myFonts.keySet();
        for (EditorFontType type : types) {
            Font font = this.myFonts.get(type);
            newScheme.setFont(type, font);
        }
        newScheme.myAttributesMap = new HashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    public void setEditorFontName(String fontName) {
        int editorFontSize = this.getEditorFontSize();
        this.myFontPreferences.clear();
        this.myFontPreferences.register(fontName, editorFontSize);
        this.initFonts();
    }

    public void setEditorFontSize(int fontSize) {
        this.myFontPreferences.register(this.getEditorFontName(), fontSize);
        this.initFonts();
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setQuickDocFontSize"));
        }
        this.myQuickDocFontSize = fontSize;
    }

    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = lineSpacing;
    }

    public Font getFont(EditorFontType key) {
        if (UISettings.getInstance().PRESENTATION_MODE) {
            Font font = this.myFonts.get(key);
            return new Font(font.getName(), font.getStyle(), UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE);
        }
        return this.myFonts.get(key);
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setName"));
        }
        this.mySchemeName = name;
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFontPreferences"));
        }
        return fontPreferences;
    }

    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setFontPreferences"));
        }
        preferences.copyTo(this.myFontPreferences);
        this.initFonts();
    }

    public String getEditorFontName() {
        if (this.myFallbackFontName != null) {
            return this.myFallbackFontName;
        }
        return this.myFontPreferences.getFontFamily();
    }

    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.getEditorFontName());
    }

    @NotNull
    public FontSize getQuickDocFontSize() {
        FontSize fontSize = this.myQuickDocFontSize;
        if (fontSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getQuickDocFontSize"));
        }
        return fontSize;
    }

    public float getLineSpacing() {
        float spacing = this.myLineSpacing;
        return spacing <= 0.0f ? 1.0f : spacing;
    }

    protected void initFonts() {
        String editorFontName = this.getEditorFontName();
        int editorFontSize = this.getEditorFontSize();
        this.myFallbackFontName = FontPreferences.getFallbackName((String)editorFontName, (int)editorFontSize, (EditorColorsScheme)this.myParentScheme);
        if (this.myFallbackFontName != null) {
            editorFontName = this.myFallbackFontName;
        }
        Font plainFont = new Font(editorFontName, 0, editorFontSize);
        Font boldFont = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        String consoleFontName = this.getConsoleFontName();
        int consoleFontSize = this.getConsoleFontSize();
        Font consolePlainFont = new Font(consoleFontName, 0, consoleFontSize);
        Font consoleBoldFont = new Font(consoleFontName, 1, consoleFontSize);
        Font consoleItalicFont = new Font(consoleFontName, 2, consoleFontSize);
        Font consoleBoldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
        this.myFonts.put(EditorFontType.CONSOLE_PLAIN, consolePlainFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD, consoleBoldFont);
        this.myFonts.put(EditorFontType.CONSOLE_ITALIC, consoleItalicFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD_ITALIC, consoleBoldItalicFont);
    }

    public String toString() {
        return this.getName();
    }

    public void readExternal(Element parentNode) {
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            for (Element element : parentNode.getChildren(SCHEME_ELEMENT)) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 141;
    }

    private void readScheme(Element node) {
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue(NAME_ATTR));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 141) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        if (isDefaultScheme == null || !Boolean.parseBoolean(isDefaultScheme)) {
            this.myParentScheme = DefaultColorSchemesManager.getInstance().getScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Default"));
        }
        for (Object o : node.getChildren()) {
            Element childNode = (Element)o;
            String childName = childNode.getName();
            if (OPTION_ELEMENT.equals(childName)) {
                this.readSettings(childNode);
                continue;
            }
            if (EDITOR_FONT.equals(childName)) {
                AbstractColorsScheme.readFontSettings(childNode, this.myFontPreferences);
                continue;
            }
            if (CONSOLE_FONT.equals(childName)) {
                AbstractColorsScheme.readFontSettings(childNode, this.myConsoleFontPreferences);
                continue;
            }
            if (COLORS_ELEMENT.equals(childName)) {
                this.readColors(childNode);
                continue;
            }
            if (!ATTRIBUTES_ELEMENT.equals(childName)) continue;
            this.readAttributes(childNode);
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readAttributes"));
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            TextAttributesKey name = TextAttributesKey.find((String)e.getAttributeValue(NAME_ATTR));
            TextAttributes attr = new TextAttributes(e.getChild(VALUE_ELEMENT));
            this.myAttributesMap.put(name, attr);
            this.migrateErrorStripeColorFrom14(name, attr);
        }
    }

    private void migrateErrorStripeColorFrom14(@NotNull TextAttributesKey name, @NotNull TextAttributes attr) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (this.myVersion >= 141 || this.myParentScheme == null) {
            return;
        }
        Couple<Color> m = DEFAULT_STRIPE_COLORS.get(name.getExternalName());
        if (m != null && Comparing.equal((Object)m.first, (Object)attr.getErrorStripeColor())) {
            attr.setErrorStripeColor((Color)m.second);
        }
    }

    private void readColors(Element childNode) {
        for (Object o : childNode.getChildren(OPTION_ELEMENT)) {
            Element colorElement = (Element)o;
            Color valueColor = AbstractColorsScheme.readColorValue(colorElement);
            String colorName = colorElement.getAttributeValue(NAME_ATTR);
            if (BACKGROUND_COLOR_NAME.equals(colorName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)colorName);
            this.myColorsMap.put(name, valueColor);
        }
    }

    private static Color readColorValue(Element colorElement) {
        String value = AbstractColorsScheme.getValue(colorElement);
        Color valueColor = null;
        if (value != null && value.trim().length() > 0) {
            try {
                valueColor = new Color(Integer.parseInt(value, 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return valueColor;
    }

    private void readSettings(Element childNode) {
        String name = childNode.getAttributeValue(NAME_ATTR);
        String value = AbstractColorsScheme.getValue(childNode);
        if (LINE_SPACING.equals(name)) {
            this.myLineSpacing = Float.parseFloat(value);
        } else if (EDITOR_FONT_SIZE.equals(name)) {
            this.setEditorFontSize(JBUI.scale((int)Integer.parseInt(value)));
        } else if (EDITOR_FONT_NAME.equals(name)) {
            this.setEditorFontName(value);
        } else if (CONSOLE_LINE_SPACING.equals(name)) {
            this.setConsoleLineSpacing(Float.parseFloat(value));
        } else if (CONSOLE_FONT_SIZE.equals(name)) {
            this.setConsoleFontSize(JBUI.scale((int)Integer.parseInt(value)));
        } else if (CONSOLE_FONT_NAME.equals(name)) {
            this.setConsoleFontName(value);
        } else if (EDITOR_QUICK_JAVADOC_FONT_SIZE.equals(name)) {
            this.myQuickDocFontSize = FontSize.valueOf((String)value);
        }
    }

    private static void readFontSettings(@NotNull Element element, @NotNull FontPreferences preferences) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        List children = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child : children) {
            Element e = (Element)child;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue(NAME_ATTR))) {
                fontFamily = AbstractColorsScheme.getValue(e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue(NAME_ATTR))) continue;
            try {
                size = JBUI.scale((int)Integer.parseInt(AbstractColorsScheme.getValue(e)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    private static String getValue(Element e) {
        String value = e.getAttributeValue(OS_VALUE_PREFIX);
        return value == null ? e.getAttributeValue(VALUE_ELEMENT) : value;
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        boolean useOldFontFormat;
        parentNode.setAttribute(NAME_ATTR, this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (this.myParentScheme != null) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        Element element = new Element(OPTION_ELEMENT);
        element.setAttribute(NAME_ATTR, LINE_SPACING);
        element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getLineSpacing()));
        parentNode.addContent(element);
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (useOldFontFormat) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, EDITOR_FONT_SIZE);
            element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getEditorFontSize() / JBUI.scale((int)1)));
            parentNode.addContent(element);
        } else {
            AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
        }
        if (!this.myFontPreferences.equals((Object)this.myConsoleFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                element = new Element(OPTION_ELEMENT);
                element.setAttribute(NAME_ATTR, CONSOLE_FONT_NAME);
                element.setAttribute(VALUE_ELEMENT, this.getConsoleFontName());
                parentNode.addContent(element);
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    element = new Element(OPTION_ELEMENT);
                    element.setAttribute(NAME_ATTR, CONSOLE_FONT_SIZE);
                    element.setAttribute(VALUE_ELEMENT, Integer.toString(this.getConsoleFontSize() / JBUI.scale((int)1)));
                    parentNode.addContent(element);
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
        }
        if (this.getConsoleLineSpacing() != this.getLineSpacing()) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, CONSOLE_LINE_SPACING);
            element.setAttribute(VALUE_ELEMENT, Float.toString(this.getConsoleLineSpacing()));
            parentNode.addContent(element);
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, EDITOR_QUICK_JAVADOC_FONT_SIZE);
            element.setAttribute(VALUE_ELEMENT, this.getQuickDocFontSize().toString());
            parentNode.addContent(element);
        }
        if (useOldFontFormat) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, EDITOR_FONT_NAME);
            element.setAttribute(VALUE_ELEMENT, this.getEditorFontName());
            parentNode.addContent(element);
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (colorElements.getChildren().size() > 0) {
            parentNode.addContent(colorElements);
        }
        if (attrElements.getChildren().size() > 0) {
            parentNode.addContent(attrElements);
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            Element e = new Element(OPTION_ELEMENT);
            e.setAttribute(NAME_ATTR, EDITOR_FONT_NAME);
            e.setAttribute(VALUE_ELEMENT, fontFamily);
            element.addContent(e);
            e = new Element(OPTION_ELEMENT);
            e.setAttribute(NAME_ATTR, EDITOR_FONT_SIZE);
            e.setAttribute(VALUE_ELEMENT, String.valueOf(preferences.getSize(fontFamily)));
            element.addContent(e);
            parent.addContent(element);
        }
    }

    private static boolean haveToWrite(TextAttributesKey key, TextAttributes value, TextAttributes defaultAttribute) {
        return (key.getFallbackAttributeKey() == null || !value.isFallbackEnabled()) && !value.equals((Object)defaultAttribute);
    }

    private void writeAttributes(Element attrElements) throws WriteExternalException {
        ArrayList<TextAttributesKey> list = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        Collections.sort(list);
        for (TextAttributesKey key : list) {
            TextAttributes defaultAttr = this.myParentScheme != null ? this.myParentScheme.getAttributes(key) : new TextAttributes();
            TextAttributes value = this.myAttributesMap.get(key);
            if (!AbstractColorsScheme.haveToWrite(key, value, defaultAttr)) continue;
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, key.getExternalName());
            Element valueElement = new Element(VALUE_ELEMENT);
            value.writeExternal(valueElement);
            element.addContent(valueElement);
            attrElements.addContent(element);
        }
    }

    protected Color getOwnColor(ColorKey key) {
        return this.myColorsMap.get(key);
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        Collections.sort(list);
        for (ColorKey key : list) {
            if (!this.haveToWrite(key)) continue;
            Color value = this.myColorsMap.get(key);
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, key.getExternalName());
            element.setAttribute(VALUE_ELEMENT, value != null ? Integer.toString(value.getRGB() & 0xFFFFFF, 16) : "");
            colorElements.addContent(element);
        }
    }

    private boolean haveToWrite(ColorKey key) {
        Color value = this.myColorsMap.get(key);
        return this.myParentScheme == null || !(this.myParentScheme instanceof AbstractColorsScheme ? Comparing.equal((Object)((AbstractColorsScheme)this.myParentScheme).getOwnColor(key), (Object)value) && ((AbstractColorsScheme)this.myParentScheme).myColorsMap.containsKey(key) : Comparing.equal((Object)this.myParentScheme.getColor(key), (Object)value));
    }

    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getConsoleFontPreferences"));
        }
        return fontPreferences;
    }

    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setConsoleFontPreferences"));
        }
        preferences.copyTo(this.myConsoleFontPreferences);
        this.initFonts();
    }

    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    public void setConsoleFontName(String fontName) {
        int consoleFontSize = this.getConsoleFontSize();
        this.myConsoleFontPreferences.clear();
        this.myConsoleFontPreferences.register(fontName, consoleFontSize);
    }

    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstance();
        if ((uiSettings == null || !uiSettings.PRESENTATION_MODE) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    public void setConsoleFontSize(int fontSize) {
        this.myConsoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    public float getConsoleLineSpacing() {
        float consoleLineSpacing = this.myConsoleLineSpacing;
        if (consoleLineSpacing == -1.0f) {
            return this.getLineSpacing();
        }
        return consoleLineSpacing;
    }

    public void setConsoleLineSpacing(float lineSpacing) {
        this.myConsoleLineSpacing = lineSpacing;
    }

    protected TextAttributes getFallbackAttributes(TextAttributesKey fallbackKey) {
        TextAttributes fallbackAttributes;
        if (fallbackKey == null) {
            return null;
        }
        if (this.myAttributesMap.containsKey(fallbackKey) && (fallbackAttributes = this.myAttributesMap.get(fallbackKey)) != null && (!fallbackAttributes.isFallbackEnabled() || fallbackKey.getFallbackAttributeKey() == null)) {
            return fallbackAttributes;
        }
        return this.getFallbackAttributes(fallbackKey.getFallbackAttributeKey());
    }
}

