/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextFragment;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineLayout {
    private final BidiRun[] myBidiRunsInLogicalOrder;
    private final BidiRun[] myBidiRunsInVisualOrder;
    private final float myWidth;

    LineLayout(@NotNull EditorView view, int startOffset, int endOffset, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this(LineLayout.createFragments(view, startOffset, endOffset, fontRenderContext), false);
    }

    LineLayout(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this(LineLayout.createFragments(view, text, fontStyle, fontRenderContext), true);
    }

    private LineLayout(@NotNull List<BidiRun> runs, boolean calculateWidth) {
        if (runs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runs", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this.myBidiRunsInLogicalOrder = runs.toArray(new BidiRun[runs.size()]);
        this.myBidiRunsInVisualOrder = (BidiRun[])this.myBidiRunsInLogicalOrder.clone();
        LineLayout.reorderRunsVisually(this.myBidiRunsInVisualOrder);
        this.myWidth = calculateWidth ? this.calculateWidth() : -1.0f;
    }

    private static void reorderRunsVisually(BidiRun[] bidiRunsInLogicalOrder) {
        if (bidiRunsInLogicalOrder.length > 1) {
            byte[] levels = new byte[bidiRunsInLogicalOrder.length];
            for (int i = 0; i < bidiRunsInLogicalOrder.length; ++i) {
                levels[i] = bidiRunsInLogicalOrder[i].level;
            }
            Bidi.reorderVisually(levels, 0, bidiRunsInLogicalOrder, 0, levels.length);
        }
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, int lineStartOffset, int lineEndOffset, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (lineEndOffset <= lineStartOffset) {
            return Collections.emptyList();
        }
        EditorImpl editor = view.getEditor();
        FontPreferences fontPreferences = editor.getColorsScheme().getFontPreferences();
        char[] chars = CharArrayUtil.fromSequence((CharSequence)editor.getDocument().getImmutableCharSequence(), (int)lineStartOffset, (int)lineEndOffset);
        List<BidiRun> runs = LineLayout.createRuns(editor, chars);
        for (BidiRun run : runs) {
            IterationState it = new IterationState(editor, lineStartOffset + run.startOffset, lineStartOffset + run.endOffset, false, false, false, false);
            while (!it.atEnd()) {
                LineLayout.addFragments(run, chars, it.getStartOffset() - lineStartOffset, it.getEndOffset() - lineStartOffset, it.getMergedAttributes().getFontType(), fontPreferences, fontRenderContext, view.getTabFragment());
                it.advance();
            }
            assert (!run.fragments.isEmpty());
        }
        return runs;
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text.length() == 0) {
            return Collections.emptyList();
        }
        EditorImpl editor = view.getEditor();
        FontPreferences fontPreferences = editor.getColorsScheme().getFontPreferences();
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        List<BidiRun> runs = LineLayout.createRuns(editor, chars);
        for (BidiRun run : runs) {
            LineLayout.addFragments(run, chars, run.startOffset, run.endOffset, fontStyle, fontPreferences, fontRenderContext, null);
            assert (!run.fragments.isEmpty());
        }
        return runs;
    }

    private static List<BidiRun> createRuns(EditorImpl editor, char[] text) {
        if (editor.myDisableRtl) {
            return Collections.singletonList(new BidiRun(0, 0, text.length));
        }
        Bidi bidi = new Bidi(text, 0, null, 0, text.length, 0);
        int runCount = bidi.getRunCount();
        ArrayList<BidiRun> runs = new ArrayList<BidiRun>(runCount);
        for (int i = 0; i < runCount; ++i) {
            runs.add(new BidiRun((byte)bidi.getRunLevel(i), bidi.getRunStart(i), bidi.getRunLimit(i)));
        }
        return runs;
    }

    private static void addFragments(BidiRun run, char[] text, int start, int end, int fontStyle, FontPreferences fontPreferences, FontRenderContext fontRenderContext, @Nullable TabFragment tabFragment) {
        Font currentFont = null;
        int currentIndex = start;
        for (int i = start; i < end; ++i) {
            char c = text[i];
            if (c == '\t' && tabFragment != null) {
                assert (run.level == 0);
                LineLayout.addTextFragmentIfNeeded(run, text, currentIndex, i, currentFont, fontRenderContext, run.isRtl());
                run.fragments.add(tabFragment);
                currentFont = null;
                currentIndex = i + 1;
                continue;
            }
            Font font = ComplementaryFontsRegistry.getFontAbleToDisplay(c, fontStyle, fontPreferences).getFont();
            if (font.equals(currentFont)) continue;
            LineLayout.addTextFragmentIfNeeded(run, text, currentIndex, i, currentFont, fontRenderContext, run.isRtl());
            currentFont = font;
            currentIndex = i;
        }
        LineLayout.addTextFragmentIfNeeded(run, text, currentIndex, end, currentFont, fontRenderContext, run.isRtl());
    }

    private static void addTextFragmentIfNeeded(BidiRun run, char[] chars, int from, int to, Font font, FontRenderContext fontRenderContext, boolean isRtl) {
        if (to > from) {
            assert (font != null);
            run.fragments.add(new TextFragment(chars, from, to, isRtl, font, fontRenderContext));
        }
    }

    private float calculateWidth() {
        float x = 0.0f;
        for (VisualFragment fragment : this.getFragmentsInVisualOrder(x)) {
            x = fragment.getEndX();
        }
        return x;
    }

    float getWidth() {
        if (this.myWidth < 0.0f) {
            throw new RuntimeException("This LineLayout instance doesn't have precalculated width");
        }
        return this.myWidth;
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final float startX) {
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(startX, 0, LineLayout.this.myBidiRunsInVisualOrder);
            }
        };
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final float startX, final int startVisualColumn, int startOffset, int endOffset) {
        BidiRun[] runs;
        assert (startOffset <= endOffset);
        if (startOffset == endOffset) {
            runs = new BidiRun[]{};
        } else {
            ArrayList<BidiRun> runList = new ArrayList<BidiRun>();
            for (BidiRun run : this.myBidiRunsInLogicalOrder) {
                if (run.endOffset <= startOffset) continue;
                if (run.startOffset >= endOffset) break;
                runList.add(run.subRun(startOffset, endOffset));
            }
            runs = runList.toArray(new BidiRun[runList.size()]);
            LineLayout.reorderRunsVisually(runs);
        }
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(startX, startVisualColumn, runs);
            }
        };
    }

    boolean isLtr() {
        return this.myBidiRunsInLogicalOrder.length == 0 || this.myBidiRunsInLogicalOrder.length == 1 && !this.myBidiRunsInLogicalOrder[0].isRtl();
    }

    boolean isRtlLocation(int offset, boolean leanForward) {
        if (offset == 0 && !leanForward) {
            return false;
        }
        for (BidiRun run : this.myBidiRunsInLogicalOrder) {
            if (offset >= run.endOffset && (offset != run.endOffset || leanForward)) continue;
            return run.isRtl();
        }
        return false;
    }

    boolean isDirectionBoundary(int offset) {
        boolean prevIsRtl = false;
        for (BidiRun run : this.myBidiRunsInLogicalOrder) {
            boolean curIsRtl = run.isRtl();
            if (offset == run.startOffset && curIsRtl != prevIsRtl) {
                return true;
            }
            if (offset < run.endOffset) {
                return false;
            }
            prevIsRtl = curIsRtl;
        }
        return prevIsRtl;
    }

    int findNearestDirectionBoundary(int offset, boolean lookForward) {
        if (lookForward) {
            boolean foundOrigin = false;
            boolean originIsRtl = false;
            for (BidiRun run : this.myBidiRunsInLogicalOrder) {
                if (foundOrigin) {
                    if (run.isRtl() == originIsRtl) continue;
                    return run.startOffset;
                }
                if (run.endOffset <= offset) continue;
                foundOrigin = true;
                originIsRtl = run.isRtl();
            }
            return originIsRtl ? this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endOffset : -1;
        }
        boolean foundOrigin = false;
        boolean originIsRtl = false;
        for (int i = this.myBidiRunsInLogicalOrder.length - 1; i >= 0; --i) {
            BidiRun run = this.myBidiRunsInLogicalOrder[i];
            if (foundOrigin) {
                if (run.isRtl() == originIsRtl) continue;
                return run.endOffset;
            }
            if (run.startOffset >= offset) continue;
            foundOrigin = true;
            originIsRtl = run.isRtl();
        }
        return originIsRtl ? 0 : -1;
    }

    static class VisualFragment {
        private LineFragment delegate;
        private int startOffset;
        private int startLogicalColumn;
        private int startVisualColumn;
        private float startX;
        private boolean isRtl;

        VisualFragment() {
        }

        boolean isRtl() {
            return this.isRtl;
        }

        int getMinOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset;
        }

        int getMaxOffset() {
            return this.isRtl ? this.startOffset : this.startOffset + this.getLength();
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset + this.getLength();
        }

        int getLength() {
            return this.delegate.getLength();
        }

        int getStartLogicalColumn() {
            return this.startLogicalColumn;
        }

        int getEndLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getMinLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn;
        }

        int getMaxLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getStartVisualColumn() {
            return this.startVisualColumn;
        }

        int getEndVisualColumn() {
            return this.startVisualColumn + this.getVisualColumnCount();
        }

        int getLogicalColumnCount() {
            return this.isRtl ? this.getLength() : this.delegate.getLogicalColumnCount(this.getMinLogicalColumn());
        }

        int getVisualColumnCount() {
            return this.delegate.getVisualColumnCount(this.startX);
        }

        float getStartX() {
            return this.startX;
        }

        float getEndX() {
            return this.delegate.offsetToX(this.startX, 0, this.getLength());
        }

        float getWidth() {
            return this.getEndX() - this.getStartX();
        }

        int logicalToVisualColumn(int column) {
            return this.startVisualColumn + this.delegate.logicalToVisualColumn(this.startX, this.getMinLogicalColumn(), this.isRtl ? this.startLogicalColumn - column : column - this.startLogicalColumn);
        }

        int visualToLogicalColumn(int column) {
            int relativeLogicalColumn = this.delegate.visualToLogicalColumn(this.startX, this.getMinLogicalColumn(), column - this.startVisualColumn);
            return this.isRtl ? this.startLogicalColumn - relativeLogicalColumn : this.startLogicalColumn + relativeLogicalColumn;
        }

        float offsetToX(int offset) {
            return this.delegate.offsetToX(this.startX, 0, this.getRelativeOffset(offset));
        }

        float offsetToX(float startX, int startOffset, int offset) {
            return this.delegate.offsetToX(startX, this.getRelativeOffset(startOffset), this.getRelativeOffset(offset));
        }

        int[] xToVisualColumn(float x) {
            int[] column = this.delegate.xToVisualColumn(this.startX, x);
            column[0] = column[0] + this.startVisualColumn;
            return column;
        }

        float visualColumnToX(int column) {
            return this.delegate.visualColumnToX(this.startX, column - this.startVisualColumn);
        }

        void draw(Graphics2D g, float x, float y) {
            this.delegate.draw(g, x, y, 0, this.getLength());
        }

        void draw(Graphics2D g, float x, float y, int startRelativeColumn, int endRelativeColumn) {
            this.delegate.draw(g, x, y, startRelativeColumn, endRelativeColumn);
        }

        private int getRelativeOffset(int offset) {
            return this.isRtl ? this.startOffset - offset : offset - this.startOffset;
        }
    }

    private static class VisualOrderIterator
    implements Iterator<VisualFragment> {
        private BidiRun[] myRuns;
        private int myRunIndex = 0;
        private int myFragmentIndex = 0;
        private int myOffsetInsideRun = 0;
        private VisualFragment myFragment = new VisualFragment();

        public VisualOrderIterator(float startX, int startVisualColumn, BidiRun[] runsInVisualOrder) {
            this.myRuns = runsInVisualOrder;
            this.myFragment.startX = startX;
            this.myFragment.startVisualColumn = startVisualColumn;
        }

        @Override
        public boolean hasNext() {
            return this.myRunIndex < this.myRuns.length && this.myFragmentIndex < this.myRuns[this.myRunIndex].fragments.size();
        }

        @Override
        public VisualFragment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BidiRun run = this.myRuns[this.myRunIndex];
            if (this.myRunIndex > 0 || this.myFragmentIndex > 0) {
                this.myFragment.startLogicalColumn = this.myFragment.getEndLogicalColumn();
                if (this.myFragmentIndex == 0) {
                    VisualFragment visualFragment = this.myFragment;
                    visualFragment.startLogicalColumn = visualFragment.startLogicalColumn + ((run.isRtl() ? run.endOffset : run.startOffset) - this.myFragment.getEndOffset());
                }
                this.myFragment.startVisualColumn = this.myFragment.getEndVisualColumn();
                this.myFragment.startX = this.myFragment.getEndX();
            }
            this.myFragment.isRtl = run.isRtl();
            this.myFragment.delegate = (LineFragment)run.fragments.get(run.isRtl() ? run.fragments.size() - 1 - this.myFragmentIndex : this.myFragmentIndex);
            this.myFragment.startOffset = run.isRtl() ? run.endOffset - this.myOffsetInsideRun : run.startOffset + this.myOffsetInsideRun;
            if (this.myRunIndex == 0 && this.myFragmentIndex == 0) {
                this.myFragment.startLogicalColumn = this.myFragment.startOffset;
            }
            this.myOffsetInsideRun += this.myFragment.getLength();
            ++this.myFragmentIndex;
            if (this.myFragmentIndex >= run.fragments.size()) {
                this.myFragmentIndex = 0;
                this.myOffsetInsideRun = 0;
                ++this.myRunIndex;
            }
            return this.myFragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BidiRun {
        private final byte level;
        private final int startOffset;
        private final int endOffset;
        private final List<LineFragment> fragments = new ArrayList<LineFragment>();

        private BidiRun(byte level, int startOffset, int endOffset) {
            this.level = level;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private boolean isRtl() {
            return (this.level & 1) != 0;
        }

        private BidiRun subRun(int targetStartOffset, int targetEndOffset) {
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            if (targetStartOffset <= this.startOffset && targetEndOffset >= this.endOffset) {
                return this;
            }
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            BidiRun run = new BidiRun(this.level, start, end);
            int offset = this.startOffset;
            for (LineFragment fragment : this.fragments) {
                if (end <= offset) break;
                int endOffset = offset + fragment.getLength();
                if (start < endOffset) {
                    run.fragments.add(fragment.subFragment(Math.max(start, offset) - offset, Math.min(end, endOffset) - offset));
                }
                offset = endOffset;
            }
            return run;
        }
    }
}

