/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.LineFragment;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

class TextFragment
implements LineFragment {
    private static final Point NOWHERE = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    @NotNull
    private final GlyphVector myGlyphVector;
    @NotNull
    private final float[] myCharPositions;

    TextFragment(@NotNull char[] lineChars, int start, int end, boolean isRtl, @NotNull Font font, @NotNull FontRenderContext fontRenderContext) {
        if (lineChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineChars", "com/intellij/openapi/editor/impl/view/TextFragment", "<init>"));
        }
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/openapi/editor/impl/view/TextFragment", "<init>"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/TextFragment", "<init>"));
        }
        assert (start >= 0);
        assert (end <= lineChars.length);
        assert (start < end);
        this.myGlyphVector = FontLayoutService.getInstance().layoutGlyphVector(font, fontRenderContext, lineChars, start, end, isRtl);
        int charCount = end - start;
        this.myCharPositions = new float[charCount];
        int charIndex = 0;
        int numGlyphs = this.myGlyphVector.getNumGlyphs();
        for (int i = 0; i <= numGlyphs; ++i) {
            int newCharIndex;
            int n = i == numGlyphs ? charCount : (newCharIndex = isRtl ? charCount - 1 - this.myGlyphVector.getGlyphCharIndex(i) : this.myGlyphVector.getGlyphCharIndex(i));
            if (newCharIndex <= charIndex) continue;
            float x = (float)this.myGlyphVector.getGlyphPosition(i).getX();
            for (int j = charIndex; j < newCharIndex; ++j) {
                this.myCharPositions[j] = x;
            }
            charIndex = newCharIndex;
        }
    }

    @Override
    public int getLength() {
        return this.myCharPositions.length;
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.myCharPositions.length;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.myCharPositions.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
        assert (startColumn >= 0);
        assert (endColumn <= this.myCharPositions.length);
        assert (startColumn < endColumn);
        if (startColumn == 0 && endColumn == this.myCharPositions.length) {
            g.drawGlyphVector(this.myGlyphVector, x, y);
        } else {
            int i;
            int logicalStartOffset = this.isRtl() ? this.myCharPositions.length - endColumn : startColumn;
            int logicalEndOffset = this.isRtl() ? this.myCharPositions.length - startColumn : endColumn;
            int glyphCount = this.myGlyphVector.getNumGlyphs();
            Point2D[] savedPositions = new Point2D[glyphCount + 1];
            int lastPaintedGlyph = -1;
            for (i = 0; i < glyphCount; ++i) {
                savedPositions[i] = this.myGlyphVector.getGlyphPosition(i);
                int c = this.myGlyphVector.getGlyphCharIndex(i);
                if (c >= logicalStartOffset && c < logicalEndOffset) {
                    lastPaintedGlyph = i;
                    continue;
                }
                this.myGlyphVector.setGlyphPosition(i, NOWHERE);
            }
            savedPositions[glyphCount] = this.myGlyphVector.getGlyphPosition(glyphCount);
            this.myGlyphVector.setGlyphPosition(glyphCount, savedPositions[lastPaintedGlyph + 1]);
            try {
                g.drawGlyphVector(this.myGlyphVector, x - this.getX(startColumn), y);
            }
            finally {
                for (i = 0; i <= glyphCount; ++i) {
                    this.myGlyphVector.setGlyphPosition(i, savedPositions[i]);
                }
            }
        }
    }

    private boolean isRtl() {
        return (this.myGlyphVector.getLayoutFlags() & 4) != 0;
    }

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        assert (startOffset >= 0);
        assert (endOffset <= this.myCharPositions.length);
        assert (startOffset < endOffset);
        if (startOffset == 0 && endOffset == this.myCharPositions.length) {
            TextFragment textFragment = this;
            if (textFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment", "subFragment"));
            }
            return textFragment;
        }
        TextFragmentWindow textFragmentWindow = new TextFragmentWindow(startOffset, endOffset);
        if (textFragmentWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment", "subFragment"));
        }
        return textFragmentWindow;
    }

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return startX + this.getX(offset) - this.getX(startOffset);
    }

    private float getX(int offset) {
        return offset <= 0 ? 0.0f : this.myCharPositions[Math.min(this.myCharPositions.length, offset) - 1];
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        float relX = x - startX;
        float prevPos = 0.0f;
        for (int i = 0; i < this.myCharPositions.length; ++i) {
            float newPos = this.myCharPositions[i];
            if (relX < (newPos + prevPos) / 2.0f) {
                return new int[]{i, relX <= prevPos ? 0 : 1};
            }
            prevPos = newPos;
        }
        return new int[]{this.myCharPositions.length, relX <= this.myCharPositions[this.myCharPositions.length - 1] ? 0 : 1};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return startX + this.getX(column);
    }

    private class TextFragmentWindow
    implements LineFragment {
        private final int myStartOffset;
        private final int myEndOffset;

        private TextFragmentWindow(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        @Override
        public int getLength() {
            return this.myEndOffset - this.myStartOffset;
        }

        @Override
        public int getLogicalColumnCount(int startColumn) {
            return this.getLength();
        }

        @Override
        public int getVisualColumnCount(float startX) {
            return this.getLength();
        }

        @Override
        public int logicalToVisualColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public int visualToLogicalColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public float offsetToX(float startX, int startOffset, int offset) {
            return TextFragment.this.offsetToX(startX, this.visualColumnToParent(startOffset), this.visualColumnToParent(offset));
        }

        @Override
        public float visualColumnToX(float startX, int column) {
            return startX + TextFragment.this.getX(this.visualColumnToParent(column)) - TextFragment.this.getX(this.visualColumnToParent(0));
        }

        @Override
        public int[] xToVisualColumn(float startX, float x) {
            int[] nArray;
            int startColumnInParent = this.visualColumnToParent(0);
            float parentStartX = startX - TextFragment.this.getX(startColumnInParent);
            int[] parentColumn = TextFragment.this.xToVisualColumn(parentStartX, x);
            int column = parentColumn[0] - startColumnInParent;
            int length = this.getLength();
            if (column < 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 0;
            } else if (column > length) {
                int[] nArray3 = new int[2];
                nArray3[0] = length;
                nArray = nArray3;
                nArray3[1] = 1;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = column;
                nArray = nArray4;
                nArray4[1] = parentColumn[1];
            }
            return nArray;
        }

        private int visualColumnToParent(int column) {
            return column + (TextFragment.this.isRtl() ? TextFragment.this.myCharPositions.length - this.myEndOffset : this.myStartOffset);
        }

        @Override
        public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
            TextFragment.this.draw(g, x, y, this.visualColumnToParent(startColumn), this.visualColumnToParent(endColumn));
        }

        @Override
        @NotNull
        public LineFragment subFragment(int startOffset, int endOffset) {
            TextFragmentWindow textFragmentWindow = new TextFragmentWindow(startOffset + this.myStartOffset, endOffset + this.myStartOffset);
            if (textFragmentWindow == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment$TextFragmentWindow", "subFragment"));
            }
            return textFragmentWindow;
        }
    }
}

