/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class EditorEmptyTextPainter {
    public void paintEmptyText(final EditorsSplitters splitters, Graphics g) {
        boolean isDarkBackground = UIUtil.isUnderDarcula();
        UISettings.setupAntialiasing((Graphics)g);
        g.setColor((Color)new JBColor((Color)(isDarkBackground ? Gray._230 : Gray._80), (Color)Gray._160));
        g.setFont((Font)JBUI.Fonts.label((float)(isDarkBackground ? 24.0f : 20.0f)));
        UIUtil.TextPainter painter = new UIUtil.TextPainter().withLineSpacing(1.5f);
        painter.withShadow(true, (Color)new JBColor(Gray._200.withAlpha(100), Gray._0.withAlpha(255)));
        painter.appendLine("No files are open").underlined((Color)new JBColor((Color)Gray._150, (Color)Gray._180));
        this.advertiseActions(splitters, painter);
        painter.draw(g, (PairFunction)new PairFunction<Integer, Integer, Couple<Integer>>(){

            public Couple<Integer> fun(Integer width, Integer height) {
                Dimension s = splitters.getSize();
                return Couple.of((Object)((s.width - width) / 2), (Object)((s.height - height) / 2));
            }
        });
    }

    protected void advertiseActions(EditorsSplitters splitters, UIUtil.TextPainter painter) {
        this.appendSearchEverywhere(painter);
        this.appendToolWindow(painter, "Open Project View", ToolWindowId.PROJECT_VIEW, splitters);
        this.appendAction(painter, "Open a file by name", this.getActionShortcutText("GotoFile"));
        this.appendAction(painter, "Open Recent Files", this.getActionShortcutText("RecentFiles"));
        this.appendAction(painter, "Open Navigation Bar", this.getActionShortcutText("ShowNavBar"));
        this.appendLine(painter, "Drag and Drop file(s) here from " + ShowFilePathAction.getFileManagerName());
    }

    protected void appendSearchEverywhere(UIUtil.TextPainter painter) {
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("SearchEverywhere");
        if (shortcuts.length == 0) {
            this.appendAction(painter, "Search Everywhere", "Double " + (SystemInfo.isMac ? "\u21e7" : "Shift"));
        } else {
            this.appendAction(painter, "Search Everywhere", KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
        }
    }

    protected void appendToolWindow(UIUtil.TextPainter painter, String action, String toolWindowId, EditorsSplitters splitters) {
        if (!EditorEmptyTextPainter.isToolwindowVisible(splitters, toolWindowId)) {
            String activateActionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindowId);
            this.appendAction(painter, action, this.getActionShortcutText(activateActionId));
        }
    }

    protected void appendAction(UIUtil.TextPainter painter, String action, String shortcut) {
        if (StringUtil.isEmpty((String)shortcut)) {
            return;
        }
        this.appendLine(painter, action + " with " + "<shortcut>" + shortcut + "</shortcut>");
    }

    protected void appendLine(UIUtil.TextPainter painter, String line) {
        painter.appendLine(line).smaller().withBullet();
    }

    protected String getActionShortcutText(String actionId) {
        return KeymapUtil.getFirstKeyboardShortcutText((String)actionId);
    }

    protected static boolean isToolwindowVisible(EditorsSplitters splitters, String toolwindowId) {
        Project project;
        Window frame = SwingUtilities.getWindowAncestor((Component)((Object)splitters));
        if (frame instanceof IdeFrameImpl && (project = ((IdeFrameImpl)frame).getProject()) != null) {
            if (!project.isInitialized()) {
                return true;
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
            return toolWindow != null && toolWindow.isVisible();
        }
        return false;
    }
}

