/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl.convertors;

import com.intellij.openapi.project.impl.convertors.Util;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class Convertor01 {
    private static final String VIRTUAL_FILE_MANAGER_CLASS = "com.intellij.vfs.VirtualFileManager";
    private static final String JAR_FILE_SYSTEM_CLASS = "com.intellij.vfs.jar.JarFileSystem";
    private static final String PROJECT_ROOT_CONTAINER_CLASS = "com.intellij.project.ProjectRootContainer";
    private static final String SOURCE_PATH_ENTRY_ATTRIBUTE = "sourcePathEntry";
    private static final String CLASS_PATH_ENTRY_ATTRIBUTE = "classPathEntry";
    private static final String OUTPUT_PATH_ENTRY_ATTRIBUTE = "outputPathEntry";
    private static final String JAVADOC_PATH_ENTRY_ATTRIBUTE = "javadocPathEntry";

    public static void execute(Element root) {
        Element rootContComponent = Util.findComponent(root, PROJECT_ROOT_CONTAINER_CLASS);
        if (rootContComponent != null) {
            for (Element element : rootContComponent.getChildren("root")) {
                String url = element.getAttributeValue("file");
                if (url != null) {
                    boolean isJar = url.indexOf("!/") >= 0;
                    url = isJar ? VirtualFileManager.constructUrl((String)"jar", (String)url) : VirtualFileManager.constructUrl((String)"file", (String)url);
                    element.setAttribute("file", url);
                }
                Element propertyElement = new Element("property");
                element.addContent(propertyElement);
                propertyElement.setAttribute("name", "type");
                propertyElement.setAttribute("value", "projectFiles");
            }
        } else {
            rootContComponent = new Element("component");
            root.addContent(rootContComponent);
            rootContComponent.setAttribute("class", PROJECT_ROOT_CONTAINER_CLASS);
        }
        Element vfManComponent = Util.findComponent(root, VIRTUAL_FILE_MANAGER_CLASS);
        if (vfManComponent != null) {
            for (Element node : vfManComponent.getChildren("fileSystem")) {
                String url;
                String fileSystemClass = node.getAttributeValue("class");
                boolean isJar = JAR_FILE_SYSTEM_CLASS.equals(fileSystemClass);
                String path = null;
                String rootType = null;
                List children = node.getChildren();
                for (Element node1 : children) {
                    if ("root".equals(node1.getName())) {
                        path = node1.getAttributeValue("path");
                        continue;
                    }
                    if (!"attribute".equals(node1.getName())) continue;
                    String name = node1.getAttributeValue("name");
                    if (SOURCE_PATH_ENTRY_ATTRIBUTE.equals(name)) {
                        rootType = SOURCE_PATH_ENTRY_ATTRIBUTE;
                        continue;
                    }
                    if (CLASS_PATH_ENTRY_ATTRIBUTE.equals(name)) {
                        rootType = CLASS_PATH_ENTRY_ATTRIBUTE;
                        continue;
                    }
                    if (OUTPUT_PATH_ENTRY_ATTRIBUTE.equals(name)) {
                        rootType = "outputPath";
                        continue;
                    }
                    if (!JAVADOC_PATH_ENTRY_ATTRIBUTE.equals(name)) continue;
                    rootType = JAVADOC_PATH_ENTRY_ATTRIBUTE;
                }
                if (isJar) {
                    path = path + "!/";
                    url = VirtualFileManager.constructUrl((String)"jar", (String)path);
                } else {
                    url = VirtualFileManager.constructUrl((String)"file", path);
                }
                Element element = new Element("root");
                rootContComponent.addContent(element);
                element.setAttribute("file", url);
                Element propertyElement = new Element("property");
                element.addContent(propertyElement);
                propertyElement.setAttribute("name", "type");
                if (rootType == null) continue;
                propertyElement.setAttribute("value", rootType);
            }
            root.removeContent((Content)vfManComponent);
        }
    }
}

