/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameLibraryHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.actions.RenameModuleHandler");

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Library library = (Library)LangDataKeys.LIBRARY.getData(dataContext);
        return library != null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler", "invoke"));
        }
        LOG.assertTrue(false);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler", "invoke"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler", "invoke"));
        }
        Library library = (Library)LangDataKeys.LIBRARY.getData(dataContext);
        LOG.assertTrue(library != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.library.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)library.getName(), (InputValidator)new MyInputValidator(project, library));
    }

    public String getActionTitle() {
        return IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]);
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final Library myLibrary;

        public MyInputValidator(Project project, Library library) {
            this.myProject = project;
            this.myLibrary = library;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && !inputString.isEmpty() && this.myLibrary.getTable().getLibraryByName(inputString) == null;
        }

        public boolean canClose(final String inputString) {
            final String oldName = this.myLibrary.getName();
            final Library.ModifiableModel modifiableModel = this.renameLibrary(inputString);
            if (modifiableModel == null) {
                return false;
            }
            Ref success = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    BasicUndoableAction action = new BasicUndoableAction(){

                        public void undo() throws UnexpectedUndoException {
                            Library.ModifiableModel modifiableModel = MyInputValidator.this.renameLibrary(oldName);
                            if (modifiableModel != null) {
                                modifiableModel.commit();
                            }
                        }

                        public void redo() throws UnexpectedUndoException {
                            Library.ModifiableModel modifiableModel = MyInputValidator.this.renameLibrary(inputString);
                            if (modifiableModel != null) {
                                modifiableModel.commit();
                            }
                        }
                    };
                    UndoManager.getInstance((Project)MyInputValidator.this.myProject).undoableActionPerformed((UndoableAction)action);
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            modifiableModel.commit();
                        }
                    });
                }
            }, IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{oldName}), null);
            return (Boolean)success.get();
        }

        @Nullable
        private Library.ModifiableModel renameLibrary(String inputString) {
            Library.ModifiableModel modifiableModel = this.myLibrary.getModifiableModel();
            modifiableModel.setName(inputString);
            return modifiableModel;
        }
    }
}

