/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundShelfFileProcessor {
    public static final String SHELF_DIR_NAME = "shelf";
    private final String mySubdirName;
    private final StreamProvider myServerStreamProvider;
    private final String FILE_SPEC;
    private final String myShelfPath;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.CompoundShelfFileProcessor");

    public CompoundShelfFileProcessor() {
        this(PathManager.getConfigPath());
    }

    public CompoundShelfFileProcessor(String shelfBaseDirPath) {
        this(((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProvider(), shelfBaseDirPath + File.separator + SHELF_DIR_NAME);
    }

    public CompoundShelfFileProcessor(@Nullable StreamProvider serverStreamProvider, String shelfPath) {
        this.myServerStreamProvider = serverStreamProvider;
        this.myShelfPath = shelfPath;
        this.mySubdirName = new File(this.myShelfPath).getName();
        this.FILE_SPEC = "$ROOT_CONFIG$/" + this.mySubdirName + "/";
    }

    public List<String> getLocalFiles() {
        ArrayList<String> result = new ArrayList<String>();
        File[] files = new File(this.myShelfPath).listFiles();
        if (files != null) {
            for (File file : files) {
                result.add(file.getName());
            }
        }
        return result;
    }

    public Collection<String> getServerFiles() {
        if (this.myServerStreamProvider == null || !this.myServerStreamProvider.isEnabled()) {
            return Collections.emptyList();
        }
        return this.myServerStreamProvider.listSubFiles(this.FILE_SPEC, RoamingType.PER_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copyFileFromServer(String serverFileName, List<String> localFileNames) {
        block6: {
            if (this.myServerStreamProvider != null && this.myServerStreamProvider.isEnabled()) {
                try {
                    InputStream stream;
                    File file = new File(new File(this.myShelfPath), serverFileName);
                    if (file.exists() || (stream = this.myServerStreamProvider.loadContent(this.FILE_SPEC + serverFileName, RoamingType.PER_USER)) == null) break block6;
                    file.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        FileUtil.copy((InputStream)stream, (OutputStream)out);
                    }
                    finally {
                        out.close();
                        stream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        localFileNames.add(serverFileName);
        return serverFileName;
    }

    public String renameFileOnServer(String serverFileName, Collection<String> serverFileNames, Collection<String> localFileNames) {
        String newName = CompoundShelfFileProcessor.getNewFileName(serverFileName, serverFileNames, localFileNames);
        if (this.myServerStreamProvider != null && this.myServerStreamProvider.isEnabled()) {
            this.renameFileOnProvider(newName, this.FILE_SPEC + serverFileName, this.FILE_SPEC + newName, this.myServerStreamProvider);
        }
        return newName;
    }

    private void renameFileOnProvider(@NotNull String newName, @NotNull String oldFilePath, @NotNull String newFilePath, @NotNull StreamProvider serverStreamProvider) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "renameFileOnProvider"));
        }
        if (oldFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFilePath", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "renameFileOnProvider"));
        }
        if (newFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFilePath", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "renameFileOnProvider"));
        }
        if (serverStreamProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStreamProvider", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "renameFileOnProvider"));
        }
        if (!serverStreamProvider.isEnabled()) {
            return;
        }
        try {
            InputStream stream = serverStreamProvider.loadContent(oldFilePath, RoamingType.PER_USER);
            if (stream != null) {
                File file = new File(this.myShelfPath + "/" + newName);
                CompoundShelfFileProcessor.copyFileToStream(stream, file);
                serverStreamProvider.delete(oldFilePath, RoamingType.PER_USER);
                CompoundShelfFileProcessor.copyFileContentToProviders(newFilePath, serverStreamProvider, file);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static void copyFileContentToProviders(String newFilePath, StreamProvider serverStreamProvider, File file) throws IOException {
        if (serverStreamProvider.isEnabled() && serverStreamProvider.isApplicable(newFilePath, RoamingType.PER_USER)) {
            byte[] content = FileUtil.loadFileBytes((File)file);
            serverStreamProvider.saveContent(newFilePath, content, content.length, RoamingType.PER_USER, true);
        }
    }

    private static void copyFileToStream(InputStream stream, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            FileUtil.copy((InputStream)stream, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    private static String getNewFileName(String serverFileName, Collection<String> serverFileNames, Collection<String> localFileNames) {
        String name = FileUtil.getNameWithoutExtension((String)serverFileName);
        String ext = FileUtilRt.getExtension((String)serverFileName);
        int i = 1;
        while (true) {
            String suggestedName;
            if (!serverFileNames.contains(suggestedName = name + i + "." + ext) && !localFileNames.contains(suggestedName)) {
                serverFileNames.add(suggestedName);
                localFileNames.add(suggestedName);
                return suggestedName;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePathFile(ContentProvider contentProvider, File patchPath, CommitContext commitContext) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(patchPath), CharsetToolkit.UTF8_CHARSET);
        try {
            contentProvider.writeContentTo(writer, commitContext);
        }
        finally {
            writer.close();
        }
        if (this.myServerStreamProvider != null && this.myServerStreamProvider.isEnabled()) {
            CompoundShelfFileProcessor.copyFileContentToProviders(this.FILE_SPEC + patchPath.getName(), this.myServerStreamProvider, patchPath);
        }
    }

    public File getBaseIODir() {
        return new File(this.myShelfPath);
    }

    public void saveFile(File from, File to) throws IOException {
        if (this.myServerStreamProvider != null && this.myServerStreamProvider.isEnabled()) {
            CompoundShelfFileProcessor.copyFileContentToProviders(this.FILE_SPEC + to.getName(), this.myServerStreamProvider, from);
        }
        FileUtil.copy((File)from, (File)to);
    }

    public void delete(String name) {
        FileUtil.delete((File)new File(this.getBaseIODir(), name));
        if (this.myServerStreamProvider != null && this.myServerStreamProvider.isEnabled()) {
            StorageUtil.delete(this.myServerStreamProvider, this.FILE_SPEC + name, RoamingType.PER_USER);
        }
    }

    public static interface ContentProvider {
        public void writeContentTo(Writer var1, CommitContext var2) throws IOException;
    }
}

