/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vcs.checkout.VcsAwareCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class NewProjectCheckoutListener
implements VcsAwareCheckoutListener {
    public boolean processCheckedOutDirectory(Project project, File directory, VcsKey vcsKey) {
        int rc = Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"checkout.create.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), directory.getAbsolutePath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            Project[] projectsAfter;
            ProjectManager pm = ProjectManager.getInstance();
            Project[] projects = pm.getOpenProjects();
            Set<VirtualFile> files = NewProjectCheckoutListener.projectsLocationSet(projects);
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(directory);
            AddModuleWizard wizard = this.createImportWizard(file);
            if (wizard == null) {
                return false;
            }
            if (wizard.showAndGet()) {
                ImportModuleAction.createFromWizard(null, wizard);
            }
            for (Project project1 : projectsAfter = pm.getOpenProjects()) {
                if (project1.getBaseDir() == null || files.contains(project1.getBaseDir())) continue;
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project1);
                vcsManager.setDirectoryMappings(Collections.singletonList(new VcsDirectoryMapping("", vcsKey.getName())));
                break;
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected AddModuleWizard createImportWizard(VirtualFile file) {
        return ImportModuleAction.createImportWizard(null, null, file, (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions());
    }

    private static Set<VirtualFile> projectsLocationSet(Project[] projects) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (Project project1 : projects) {
            if (project1.getBaseDir() == null) continue;
            files.add(project1.getBaseDir());
        }
        return files;
    }
}

