/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.internal.focus.FocusTracesAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.TimedOutCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.KeyEventProcessor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import com.intellij.reference.SoftReference;
import com.intellij.ui.FocusTrackback;
import com.intellij.util.containers.WeakValueHashMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusManagerImpl
extends IdeFocusManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FocusManagerImpl.class);
    private static final UiActivity FOCUS = new UiActivity.Focus(new String[]{"awtFocusRequest"});
    private static final UiActivity TYPEAHEAD = new UiActivity.Focus(new String[]{"typeahead"});
    private final Application myApp;
    private FocusCommand myRequestFocusCmd;
    private final List<FocusCommand> myFocusRequests = new ArrayList<FocusCommand>();
    private final List<KeyEvent> myToDispatchOnDone = new ArrayList<KeyEvent>();
    private Reference<FocusCommand> myLastForcedRequest;
    private FocusCommand myFocusCommandOnAppActivation;
    private ActionCallback myCallbackOnActivation;
    private final boolean isInternalMode = ApplicationManagerEx.getApplicationEx().isInternal();
    private final LinkedList<FocusRequestInfo> myRequests = new LinkedList();
    private final IdeEventQueue myQueue;
    private final KeyProcessorContext myKeyProcessorContext = new KeyProcessorContext();
    private long myCmdTimestamp;
    private long myForcedCmdTimestamp;
    private final EdtAlarm myFocusedComponentAlarm;
    private final EdtAlarm myForcedFocusRequestsAlarm;
    private final SimpleTimer myTimer = SimpleTimer.newInstance((String)"FocusManager timer");
    private final EdtAlarm myIdleAlarm;
    private final Set<Runnable> myIdleRequests = new LinkedHashSet<Runnable>();
    private boolean myFlushWasDelayedToFixFocus;
    private ExpirableRunnable myFocusRevalidator;
    private final Set<FurtherRequestor> myValidFurtherRequestors = new HashSet<FurtherRequestor>();
    private final Set<ActionCallback> myTypeAheadRequestors = new HashSet<ActionCallback>();
    private final UiActivityMonitor myActivityMonitor;
    private boolean myTypeaheadEnabled = true;
    private int myModalityStateForLastForcedRequest;
    private final Map<IdeFrame, Component> myLastFocused = new WeakValueHashMap();
    private final Map<IdeFrame, Component> myLastFocusedAtDeactivation = new WeakValueHashMap();
    private DataContext myRunContext;
    private final TIntIntHashMap myModalityCount2FlushCount = new TIntIntHashMap();
    private IdeFrame myLastFocusedFrame;

    private boolean canFlushIdleRequests() {
        Component focusOwner = this.getFocusOwner();
        return this.isFocusTransferReady() && !this.isIdleQueueEmpty() && !IdeEventQueue.getInstance().isDispatchingFocusEvent() && (focusOwner != null || this.myValidFurtherRequestors.isEmpty() && (this.myFocusRevalidator == null || this.myFocusRevalidator.isExpired()));
    }

    public FocusManagerImpl(ServiceManagerImpl serviceManager, WindowManager wm, UiActivityMonitor monitor) {
        this.myApp = ApplicationManager.getApplication();
        this.myQueue = IdeEventQueue.getInstance();
        this.myActivityMonitor = monitor;
        this.myFocusedComponentAlarm = new EdtAlarm();
        this.myForcedFocusRequestsAlarm = new EdtAlarm();
        this.myIdleAlarm = new EdtAlarm();
        AppListener myAppListener = new AppListener();
        this.myApp.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)myAppListener);
        IdeEventQueue.getInstance().addDispatcher(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent e) {
                if (e instanceof FocusEvent) {
                    FocusEvent fe = (FocusEvent)e;
                    Component c = fe.getComponent();
                    if (c instanceof Window || c == null) {
                        return false;
                    }
                    Component parent = UIUtil.findUltimateParent((Component)c);
                    if (parent instanceof IdeFrame) {
                        FocusManagerImpl.this.myLastFocused.put((IdeFrame)parent, c);
                    }
                } else if (e instanceof WindowEvent) {
                    Window wnd = ((WindowEvent)e).getWindow();
                    if (e.getID() == 202 && wnd instanceof IdeFrame) {
                        FocusManagerImpl.this.myLastFocused.remove(wnd);
                        FocusManagerImpl.this.myLastFocusedAtDeactivation.remove(wnd);
                    }
                }
                return false;
            }
        }, this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof IdeFrame) {
                    FocusManagerImpl.this.myLastFocusedFrame = (IdeFrame)evt.getNewValue();
                }
            }
        });
    }

    public IdeFrame getLastFocusedFrame() {
        return this.myLastFocusedFrame;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/FocusManagerImpl", "requestFocus"));
        }
        ActionCallback actionCallback = this.requestFocus((FocusCommand)new FocusCommand.ByComponent(c, (Throwable)new Exception()), forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback requestFocus(final @NotNull FocusCommand command, final boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/FocusManagerImpl", "requestFocus"));
        }
        FocusManagerImpl.assertDispatchThread();
        if (this.isInternalMode) {
            this.recordCommand(command, new Throwable(), forced);
        }
        final ActionCallback result = new ActionCallback();
        this.myActivityMonitor.addActivity(FOCUS, ModalityState.any());
        if (!forced) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!FocusManagerImpl.this.myFocusRequests.contains(command)) {
                        FocusManagerImpl.this.myFocusRequests.add(command);
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FocusManagerImpl.this.resetUnforcedCommand(command);
                    FocusManagerImpl.this._requestFocus(command, forced, result);
                }
            });
        } else {
            this._requestFocus(command, forced, result);
        }
        result.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                FocusManagerImpl.this.restartIdleAlarm();
            }
        });
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    @NotNull
    public List<FocusRequestInfo> getRequests() {
        LinkedList<FocusRequestInfo> linkedList = this.myRequests;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl", "getRequests"));
        }
        return linkedList;
    }

    public void recordFocusRequest(Component c, boolean forced) {
        this.myRequests.add(new FocusRequestInfo(c, new Throwable(), forced));
        if (this.myRequests.size() > 200) {
            this.myRequests.removeFirst();
        }
    }

    private void recordCommand(@NotNull FocusCommand command, @NotNull Throwable trace, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/FocusManagerImpl", "recordCommand"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/intellij/openapi/wm/impl/FocusManagerImpl", "recordCommand"));
        }
        if (FocusTracesAction.isActive()) {
            this.recordFocusRequest(command.getDominationComponent(), forced);
        }
    }

    private void _requestFocus(final @NotNull FocusCommand command, final boolean forced, final @NotNull ActionCallback result) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/FocusManagerImpl", "_requestFocus"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/wm/impl/FocusManagerImpl", "_requestFocus"));
        }
        result.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                FocusManagerImpl.this.maybeRemoveFocusActivity();
            }
        });
        if (this.checkForRejectOrByPass(command, forced, result)) {
            return;
        }
        this.setCommand(command);
        command.setCallback(result);
        if (forced) {
            this.myForcedFocusRequestsAlarm.cancelAllRequests();
            this.setLastEffectiveForcedRequest(command);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FocusManagerImpl.this.checkForRejectOrByPass(command, forced, result)) {
                    return;
                }
                if (FocusManagerImpl.this.myRequestFocusCmd == command) {
                    TimedOutCallback focusTimeout = new TimedOutCallback(Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Focus command timed out, cmd=" + command, command.getAllocation(), true){

                        protected void onTimeout() {
                            FocusManagerImpl.this.forceFinishFocusSettleDown(command, result);
                        }
                    };
                    if (command.invalidatesRequestors()) {
                        FocusManagerImpl.this.myCmdTimestamp++;
                    }
                    FocusManagerImpl.this.revalidateFurtherRequestors();
                    if (forced) {
                        if (command.invalidatesRequestors()) {
                            FocusManagerImpl.this.myForcedCmdTimestamp++;
                        }
                        FocusManagerImpl.this.revalidateFurtherRequestors();
                    }
                    command.setForced(forced);
                    command.run().doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    FocusManagerImpl.this.resetCommand(command, false);
                                    result.setDone();
                                }
                            });
                        }
                    }).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            result.setRejected();
                            FocusManagerImpl.this.resetCommand(command, true);
                        }
                    }).doWhenProcessed(new Runnable(){

                        @Override
                        public void run() {
                            if (forced) {
                                FocusManagerImpl.this.myForcedFocusRequestsAlarm.addRequest(new SetLastEffectiveRunnable(), 250);
                            }
                        }
                    }).notify((ActionCallback)focusTimeout);
                } else {
                    FocusManagerImpl.this.rejectCommand(command, result);
                }
            }
        });
    }

    private void maybeRemoveFocusActivity() {
        if (this.isFocusTransferReady()) {
            this.myActivityMonitor.removeActivity(FOCUS);
        }
    }

    private boolean checkForRejectOrByPass(@NotNull FocusCommand cmd, boolean forced, @NotNull ActionCallback result) {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/openapi/wm/impl/FocusManagerImpl", "checkForRejectOrByPass"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/wm/impl/FocusManagerImpl", "checkForRejectOrByPass"));
        }
        if (cmd.isExpired()) {
            this.rejectCommand(cmd, result);
            return true;
        }
        FocusCommand lastRequest = this.getLastEffectiveForcedRequest();
        if (!forced && !this.isUnforcedRequestAllowed()) {
            if (cmd.equals((Object)lastRequest)) {
                this.resetCommand(cmd, false);
                result.setDone();
            } else {
                this.rejectCommand(cmd, result);
            }
            return true;
        }
        if (lastRequest != null && lastRequest.dominatesOver(cmd)) {
            this.rejectCommand(cmd, result);
            return true;
        }
        if (!Registry.is((String)"focus.fix.lost.cursor")) {
            boolean doNotExecuteBecauseAppIsInactive;
            boolean bl = doNotExecuteBecauseAppIsInactive = !this.myApp.isActive() && !FocusManagerImpl.canExecuteOnInactiveApplication(cmd) && Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive");
            if (doNotExecuteBecauseAppIsInactive) {
                if (this.myCallbackOnActivation != null) {
                    this.myCallbackOnActivation.setRejected();
                    if (this.myFocusCommandOnAppActivation != null) {
                        this.resetCommand(this.myFocusCommandOnAppActivation, true);
                    }
                }
                this.myFocusCommandOnAppActivation = cmd;
                this.myCallbackOnActivation = result;
                return true;
            }
        }
        return false;
    }

    private void setCommand(final @NotNull FocusCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/FocusManagerImpl", "setCommand"));
        }
        this.myRequestFocusCmd = command;
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!FocusManagerImpl.this.myFocusRequests.contains(command)) {
                    FocusManagerImpl.this.myFocusRequests.add(command);
                }
            }
        });
    }

    private void resetCommand(final @NotNull FocusCommand cmd, boolean reject) {
        ActionCallback cb;
        KeyEventProcessor processor;
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/openapi/wm/impl/FocusManagerImpl", "resetCommand"));
        }
        FocusManagerImpl.assertDispatchThread();
        if (cmd == this.myRequestFocusCmd) {
            this.myRequestFocusCmd = null;
        }
        if ((processor = cmd.getProcessor()) != null) {
            processor.finish((KeyEventProcessor.Context)this.myKeyProcessorContext);
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                FocusManagerImpl.this.myFocusRequests.remove(cmd);
            }
        });
        if (reject && (cb = cmd.getCallback()) != null && !cb.isProcessed()) {
            cmd.getCallback().setRejected();
        }
    }

    private void resetUnforcedCommand(final @NotNull FocusCommand cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/openapi/wm/impl/FocusManagerImpl", "resetUnforcedCommand"));
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                FocusManagerImpl.this.myFocusRequests.remove(cmd);
            }
        });
    }

    private static boolean canExecuteOnInactiveApplication(@NotNull FocusCommand cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/openapi/wm/impl/FocusManagerImpl", "canExecuteOnInactiveApplication"));
        }
        return cmd.canExecuteOnInactiveApp();
    }

    private void setLastEffectiveForcedRequest(@Nullable FocusCommand command) {
        this.myLastForcedRequest = command == null ? null : new WeakReference<FocusCommand>(command);
        this.myModalityStateForLastForcedRequest = this.getCurrentModalityCount();
    }

    @Nullable
    private FocusCommand getLastEffectiveForcedRequest() {
        FocusCommand request = (FocusCommand)SoftReference.dereference(this.myLastForcedRequest);
        return request != null && !request.isExpired() ? request : null;
    }

    boolean isUnforcedRequestAllowed() {
        if (this.getLastEffectiveForcedRequest() == null) {
            return true;
        }
        return this.myModalityStateForLastForcedRequest != this.getCurrentModalityCount();
    }

    public static FocusManagerImpl getInstance() {
        return (FocusManagerImpl)((Object)ApplicationManager.getApplication().getComponent(IdeFocusManager.class));
    }

    public void dispose() {
        this.myForcedFocusRequestsAlarm.cancelAllRequests();
        this.myFocusedComponentAlarm.cancelAllRequests();
    }

    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/FocusManagerImpl", "doWhenFocusSettlesDown"));
        }
        this.doWhenFocusSettlesDown((Runnable)runnable);
    }

    public void doWhenFocusSettlesDown(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/FocusManagerImpl", "doWhenFocusSettlesDown"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FocusManagerImpl.this.isFlushingIdleRequests()) {
                    FocusManagerImpl.this.myIdleRequests.add(runnable);
                    return;
                }
                if (FocusManagerImpl.this.myRunContext != null) {
                    FocusManagerImpl.flushRequest(runnable);
                    return;
                }
                boolean needsRestart = FocusManagerImpl.this.isIdleQueueEmpty();
                if (FocusManagerImpl.this.myIdleRequests.contains(runnable)) {
                    FocusManagerImpl.this.myIdleRequests.remove(runnable);
                    FocusManagerImpl.this.myIdleRequests.add(runnable);
                } else {
                    FocusManagerImpl.this.myIdleRequests.add(runnable);
                }
                if (FocusManagerImpl.this.canFlushIdleRequests()) {
                    FocusManagerImpl.this.flushIdleRequests();
                } else if (needsRestart) {
                    FocusManagerImpl.this.restartIdleAlarm();
                }
            }
        });
    }

    private void restartIdleAlarm() {
        if (!ApplicationManager.getApplication().isActive()) {
            return;
        }
        this.myIdleAlarm.cancelAllRequests();
        this.myIdleAlarm.addRequest(new IdleRunnable(), Registry.intValue((String)"actionSystem.focusIdleTimeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIdleRequests() {
        int currentModalityCount = this.getCurrentModalityCount();
        try {
            this.incFlushingRequests(1, currentModalityCount);
            if (!this.isTypeaheadEnabled()) {
                this.myToDispatchOnDone.clear();
                this.myTypeAheadRequestors.clear();
            }
            if (!this.myToDispatchOnDone.isEmpty() && this.myTypeAheadRequestors.isEmpty()) {
                KeyEvent[] events = this.myToDispatchOnDone.toArray(new KeyEvent[this.myToDispatchOnDone.size()]);
                IdeEventQueue.getInstance().getKeyEventDispatcher().resetState();
                for (int eachIndex = 0; eachIndex < events.length && this.isFocusTransferReady(); ++eachIndex) {
                    KeyEvent each = events[eachIndex];
                    Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (owner == null) {
                        owner = JOptionPane.getRootFrame();
                    }
                    boolean metaKey = each.getKeyCode() == 18 || each.getKeyCode() == 17 || each.getKeyCode() == 16 || each.getKeyCode() == 157;
                    boolean toDispatch = false;
                    if (!(metaKey || each.getID() != 402 && each.getID() != 400)) {
                        for (int i = 0; i < eachIndex; ++i) {
                            KeyEvent prev = events[i];
                            if (prev == null || prev.getID() != 401 || prev.getKeyCode() != each.getKeyCode() && prev.getKeyChar() != each.getKeyChar()) continue;
                            toDispatch = true;
                            events[i] = null;
                            break;
                        }
                    } else {
                        toDispatch = true;
                    }
                    this.myToDispatchOnDone.remove(each);
                    if (!toDispatch) continue;
                    KeyEvent keyEvent = new KeyEvent(owner, each.getID(), each.getWhen(), each.getModifiersEx(), each.getKeyCode(), each.getKeyChar(), each.getKeyLocation());
                    if (owner != null && SwingUtilities.getWindowAncestor(owner) != null) {
                        IdeEventQueue.getInstance().dispatchEvent(keyEvent);
                        continue;
                    }
                    this.myQueue._dispatchEvent(keyEvent, true);
                }
                if (this.myToDispatchOnDone.isEmpty() && this.myTypeAheadRequestors.isEmpty()) {
                    this.myActivityMonitor.removeActivity(TYPEAHEAD);
                }
            }
            if (!this.isFocusBeingTransferred()) {
                boolean focusOk;
                boolean bl = focusOk = this.getFocusOwner() != null;
                if (!focusOk && !this.myFlushWasDelayedToFixFocus) {
                    IdeEventQueue.getInstance().fixStickyFocusedComponents(null);
                    this.myFlushWasDelayedToFixFocus = true;
                } else if (!focusOk) {
                    this.myFlushWasDelayedToFixFocus = false;
                }
                if (this.canFlushIdleRequests() && this.getFlushingIdleRequests() <= 1 && (focusOk || !this.myFlushWasDelayedToFixFocus)) {
                    this.myFlushWasDelayedToFixFocus = false;
                    this.flushNow();
                }
            }
        }
        finally {
            this.incFlushingRequests(-1, currentModalityCount);
            if (!this.isIdleQueueEmpty()) {
                this.restartIdleAlarm();
            }
            this.maybeRemoveFocusActivity();
        }
    }

    private boolean processFocusRevalidation() {
        ExpirableRunnable revalidator = this.myFocusRevalidator;
        this.myFocusRevalidator = null;
        if (revalidator != null && !revalidator.isExpired()) {
            revalidator.run();
            return true;
        }
        return false;
    }

    private void flushNow() {
        Runnable[] all = this.myIdleRequests.toArray(new Runnable[this.myIdleRequests.size()]);
        this.myIdleRequests.clear();
        for (int i = 0; i < all.length; ++i) {
            FocusManagerImpl.flushRequest(all[i]);
            if (!this.isFocusBeingTransferred()) continue;
            for (int j = i + 1; j < all.length; ++j) {
                this.myIdleRequests.add(all[j]);
            }
            break;
        }
        this.maybeRemoveFocusActivity();
    }

    private static void flushRequest(Runnable each) {
        if (each == null) {
            return;
        }
        if (each instanceof Expirable) {
            if (!((Expirable)each).isExpired()) {
                each.run();
            }
        } else {
            each.run();
        }
    }

    public boolean isFocusTransferReady() {
        FocusManagerImpl.assertDispatchThread();
        if (this.myRunContext != null) {
            return true;
        }
        this.invalidateFocusRequestsQueue();
        if (!this.myFocusRequests.isEmpty()) {
            return false;
        }
        if (this.myQueue == null) {
            return true;
        }
        return !this.myQueue.isSuspendMode() && !this.myQueue.hasFocusEventsPending();
    }

    private void invalidateFocusRequestsQueue() {
        FocusManagerImpl.assertDispatchThread();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FocusManagerImpl.this.myFocusRequests.isEmpty()) {
                    return;
                }
                FocusCommand[] requests = FocusManagerImpl.this.myFocusRequests.toArray(new FocusCommand[FocusManagerImpl.this.myFocusRequests.size()]);
                boolean wasChanged = false;
                for (FocusCommand each : requests) {
                    if (!each.isExpired()) continue;
                    FocusManagerImpl.this.resetCommand(each, true);
                    wasChanged = true;
                }
                if (wasChanged && FocusManagerImpl.this.myFocusRequests.isEmpty()) {
                    FocusManagerImpl.this.restartIdleAlarm();
                }
            }
        });
    }

    private boolean isIdleQueueEmpty() {
        return this.isPendingKeyEventsRedispatched() && this.myIdleRequests.isEmpty();
    }

    private boolean isPendingKeyEventsRedispatched() {
        return this.myToDispatchOnDone.isEmpty();
    }

    public boolean dispatch(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/FocusManagerImpl", "dispatch"));
        }
        if (!this.isTypeaheadEnabled()) {
            return false;
        }
        if (this.isFlushingIdleRequests()) {
            return false;
        }
        FocusManagerImpl.assertDispatchThread();
        if (!(this.isFocusTransferReady() && this.isPendingKeyEventsRedispatched() && this.myTypeAheadRequestors.isEmpty())) {
            for (FocusCommand each : this.myFocusRequests) {
                Boolean result;
                KeyEventProcessor processor = each.getProcessor();
                if (processor == null || (result = processor.dispatch(e, (KeyEventProcessor.Context)this.myKeyProcessorContext)) == null) continue;
                if (result.booleanValue()) {
                    this.myActivityMonitor.addActivity(TYPEAHEAD, ModalityState.any());
                    return true;
                }
                return false;
            }
            this.myToDispatchOnDone.add(e);
            this.myActivityMonitor.addActivity(TYPEAHEAD, ModalityState.any());
            this.restartIdleAlarm();
            return true;
        }
        return false;
    }

    public void setTypeaheadEnabled(boolean enabled) {
        this.myTypeaheadEnabled = enabled;
    }

    private boolean isTypeaheadEnabled() {
        return Registry.is((String)"actionSystem.fixLostTyping") && this.myTypeaheadEnabled;
    }

    public void typeAheadUntil(@NotNull ActionCallback callback) {
        ActionCallback done;
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/wm/impl/FocusManagerImpl", "typeAheadUntil"));
        }
        if (!this.isTypeaheadEnabled()) {
            return;
        }
        final long currentTime = System.currentTimeMillis();
        if (!Registry.is((String)"type.ahead.logging.enabled")) {
            done = callback;
        } else {
            final String id = new Exception().getStackTrace()[2].getClassName();
            final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:ss:SSS", Locale.US);
            LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tStarted:  " + id);
            done = new ActionCallback();
            callback.doWhenDone(new Runnable(){

                @Override
                public void run() {
                    done.setDone();
                    LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tDone:     " + id);
                }
            });
            callback.doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    done.setRejected();
                    LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tRejected: " + id);
                }
            });
        }
        FocusManagerImpl.assertDispatchThread();
        this.myTypeAheadRequestors.add(done);
        done.notify(new TimedOutCallback((long)Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Typeahead request blocked", (Throwable)new Exception(){

            @Override
            public String getMessage() {
                return "Time: " + (System.currentTimeMillis() - currentTime);
            }
        }, true).doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                if (FocusManagerImpl.this.myTypeAheadRequestors.remove(done)) {
                    FocusManagerImpl.this.restartIdleAlarm();
                }
            }
        }));
    }

    private boolean isFlushingIdleRequests() {
        return this.getFlushingIdleRequests() > 0;
    }

    private int getFlushingIdleRequests() {
        int currentModalityCount = this.getCurrentModalityCount();
        return this.myModalityCount2FlushCount.get(currentModalityCount);
    }

    private void incFlushingRequests(int delta, int currentModalityCount) {
        if (this.myModalityCount2FlushCount.containsKey(currentModalityCount)) {
            this.myModalityCount2FlushCount.adjustValue(currentModalityCount, delta);
        } else {
            this.myModalityCount2FlushCount.put(currentModalityCount, delta);
        }
    }

    private int getCurrentModalityCount() {
        Window[] windows;
        int modalityCount = 0;
        for (Window each : windows = Window.getWindows()) {
            JRootPane rootPane;
            if (!each.isShowing()) continue;
            if (each instanceof Dialog) {
                Dialog eachDialog = (Dialog)each;
                if (eachDialog.isModal()) {
                    ++modalityCount;
                    continue;
                }
                if (!(each instanceof JDialog) || !FocusManagerImpl.isModalContextPopup(((JDialog)each).getRootPane())) continue;
                ++modalityCount;
                continue;
            }
            if (!(each instanceof JWindow) || !FocusManagerImpl.isModalContextPopup(rootPane = ((JWindow)each).getRootPane())) continue;
            ++modalityCount;
        }
        final int finalModalityCount = modalityCount;
        this.myModalityCount2FlushCount.retainEntries(new TIntIntProcedure(){

            public boolean execute(int eachModalityCount, int flushCount) {
                return eachModalityCount <= finalModalityCount;
            }
        });
        return modalityCount;
    }

    private static boolean isModalContextPopup(@NotNull JRootPane rootPane) {
        if (rootPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPane", "com/intellij/openapi/wm/impl/FocusManagerImpl", "isModalContextPopup"));
        }
        JBPopup popup = (JBPopup)rootPane.getClientProperty("JBPopup");
        return popup != null && popup.isModalContext();
    }

    @NotNull
    public Expirable getTimestamp(final boolean trackOnlyForcedCommands) {
        FocusManagerImpl.assertDispatchThread();
        Expirable expirable = new Expirable(){
            long myOwnStamp;
            {
                this.myOwnStamp = trackOnlyForcedCommands ? FocusManagerImpl.this.myForcedCmdTimestamp : FocusManagerImpl.this.myCmdTimestamp;
            }

            public boolean isExpired() {
                return this.myOwnStamp < (trackOnlyForcedCommands ? FocusManagerImpl.this.myForcedCmdTimestamp : FocusManagerImpl.this.myCmdTimestamp);
            }
        };
        if (expirable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl", "getTimestamp"));
        }
        return expirable;
    }

    @NotNull
    public FocusRequestor getFurtherRequestor() {
        FocusManagerImpl.assertDispatchThread();
        FurtherRequestor requestor = new FurtherRequestor(this, this.getTimestamp(true));
        this.myValidFurtherRequestors.add(requestor);
        this.revalidateFurtherRequestors();
        FurtherRequestor furtherRequestor = requestor;
        if (furtherRequestor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl", "getFurtherRequestor"));
        }
        return furtherRequestor;
    }

    private void revalidateFurtherRequestors() {
        Iterator<FurtherRequestor> requestorIterator = this.myValidFurtherRequestors.iterator();
        while (requestorIterator.hasNext()) {
            FurtherRequestor each = requestorIterator.next();
            if (!each.isExpired()) continue;
            requestorIterator.remove();
            Disposer.dispose((Disposable)each);
        }
    }

    public void revalidateFocus(final @NotNull ExpirableRunnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/FocusManagerImpl", "revalidateFocus"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FocusManagerImpl.this.myFocusRevalidator = runnable;
                FocusManagerImpl.this.restartIdleAlarm();
            }
        });
    }

    public Component getFocusOwner() {
        FocusManagerImpl.assertDispatchThread();
        Component result = null;
        if (!ApplicationManager.getApplication().isActive()) {
            result = this.myLastFocusedAtDeactivation.get(this.getLastFocusedFrame());
        } else if (this.myRunContext != null) {
            result = (Component)this.myRunContext.getData(PlatformDataKeys.CONTEXT_COMPONENT.getName());
        }
        if (result == null) {
            result = this.isFocusBeingTransferred() ? null : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        boolean meaninglessOwner = UIUtil.isMeaninglessFocusOwner((Component)result);
        if (result == null && !this.isFocusBeingTransferred() || meaninglessOwner) {
            Component permOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (permOwner != null) {
                result = permOwner;
            }
            if (UIUtil.isMeaninglessFocusOwner((Component)result)) {
                result = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            }
        }
        return result;
    }

    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/wm/impl/FocusManagerImpl", "runOnOwnContext"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/FocusManagerImpl", "runOnOwnContext"));
        }
        FocusManagerImpl.assertDispatchThread();
        this.myRunContext = context;
        try {
            runnable.run();
        }
        finally {
            this.myRunContext = null;
        }
    }

    public Component getLastFocusedFor(IdeFrame frame) {
        FocusManagerImpl.assertDispatchThread();
        return this.myLastFocused.get(frame);
    }

    public void setLastFocusedAtDeactivation(@NotNull IdeFrame frame, @NotNull Component c) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/openapi/wm/impl/FocusManagerImpl", "setLastFocusedAtDeactivation"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/FocusManagerImpl", "setLastFocusedAtDeactivation"));
        }
        this.myLastFocusedAtDeactivation.put(frame, c);
    }

    public void toFront(JComponent c) {
        FocusManagerImpl.assertDispatchThread();
        if (c == null) {
            return;
        }
        final Window window = (Window)UIUtil.getParentOfType(Window.class, (Component)c);
        if (window != null && window.isShowing()) {
            this.doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    if (ApplicationManager.getApplication().isActive()) {
                        window.toFront();
                    }
                }
            });
        }
    }

    private void forceFinishFocusSettleDown(@NotNull FocusCommand cmd, @NotNull ActionCallback cmdCallback) {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/openapi/wm/impl/FocusManagerImpl", "forceFinishFocusSettleDown"));
        }
        if (cmdCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdCallback", "com/intellij/openapi/wm/impl/FocusManagerImpl", "forceFinishFocusSettleDown"));
        }
        this.rejectCommand(cmd, cmdCallback);
    }

    private void rejectCommand(@NotNull FocusCommand cmd, @NotNull ActionCallback callback) {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/openapi/wm/impl/FocusManagerImpl", "rejectCommand"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/wm/impl/FocusManagerImpl", "rejectCommand"));
        }
        this.resetCommand(cmd, true);
        this.resetUnforcedCommand(cmd);
        callback.setRejected();
    }

    @Nullable
    private static Component getComponent(@NotNull Map<IdeFrame, Component> map, IdeFrame frame) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/wm/impl/FocusManagerImpl", "getComponent"));
        }
        return map.get(frame);
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/wm/impl/FocusManagerImpl", "getFocusTargetFor"));
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(comp);
    }

    public Component getFocusedDescendantFor(Component comp) {
        Component focused = this.getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        List<JBPopup> popups = FocusTrackback.getChildPopups(comp);
        for (JBPopup each : popups) {
            if (!each.isFocused()) continue;
            return focused;
        }
        return null;
    }

    public boolean isFocusBeingTransferred() {
        return !this.isFocusTransferReady();
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        Component toFocus;
        block7: {
            Window[] windows;
            block6: {
                toFocus = null;
                if (this.myLastFocusedFrame == null) break block6;
                toFocus = this.myLastFocused.get(this.myLastFocusedFrame);
                if (toFocus != null && toFocus.isShowing()) break block7;
                toFocus = this.getFocusTargetFor(this.myLastFocusedFrame.getComponent());
                break block7;
            }
            for (Window each : windows = Window.getWindows()) {
                if (!each.isActive()) continue;
                if (each instanceof JFrame) {
                    toFocus = this.getFocusTargetFor(((JFrame)each).getRootPane());
                    break;
                }
                if (each instanceof JDialog) {
                    toFocus = this.getFocusTargetFor(((JDialog)each).getRootPane());
                    break;
                }
                if (!(each instanceof JWindow)) continue;
                toFocus = this.getFocusTargetFor(((JWindow)each).getRootPane());
                break;
            }
        }
        if (toFocus != null) {
            ActionCallback actionCallback = this.requestFocus(new FocusCommand.ByComponent(toFocus, (Throwable)new Exception()).setToInvalidateRequestors(false), forced);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl", "requestDefaultFocus"));
            }
            return actionCallback;
        }
        ActionCallback.Done done = new ActionCallback.Done();
        if (done == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl", "requestDefaultFocus"));
        }
        return done;
    }

    public boolean isFocusTransferEnabled() {
        if (Registry.is((String)"focus.fix.lost.cursor")) {
            return true;
        }
        return this.myApp.isActive() || !Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive");
    }

    private static void assertDispatchThread() {
        if (Registry.is((String)"actionSystem.assertFocusAccessFromEdt")) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
    }

    private class SetLastEffectiveRunnable
    extends EdtRunnable {
        private SetLastEffectiveRunnable() {
        }

        public void runEdt() {
            FocusManagerImpl.this.setLastEffectiveForcedRequest(null);
        }
    }

    private class AppListener
    implements ApplicationActivationListener {
        private AppListener() {
        }

        public void applicationDeactivated(IdeFrame ideFrame) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component parent = UIUtil.findUltimateParent((Component)owner);
            if (parent == ideFrame) {
                FocusManagerImpl.this.myLastFocusedAtDeactivation.put(ideFrame, owner);
            }
        }

        public void applicationActivated(IdeFrame ideFrame) {
            FocusCommand cmd = FocusManagerImpl.this.myFocusCommandOnAppActivation;
            ActionCallback callback = FocusManagerImpl.this.myCallbackOnActivation;
            FocusManagerImpl.this.myFocusCommandOnAppActivation = null;
            FocusManagerImpl.this.myCallbackOnActivation = null;
            if (cmd != null) {
                FocusManagerImpl.this.requestFocus(cmd, true).notify(callback);
            } else {
                this.focusLastFocusedComponent(ideFrame);
            }
        }

        private void focusLastFocusedComponent(IdeFrame ideFrame) {
            KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (mgr.getFocusOwner() == null) {
                Component c = FocusManagerImpl.getComponent(FocusManagerImpl.this.myLastFocusedAtDeactivation, ideFrame);
                if (c == null || !c.isShowing()) {
                    c = FocusManagerImpl.getComponent(FocusManagerImpl.this.myLastFocused, ideFrame);
                }
                boolean mouseEventAhead = IdeEventQueue.isMouseEventAhead(null);
                if (c != null && c.isShowing() && !mouseEventAhead) {
                    final LayoutFocusTraversalPolicyExt policy = LayoutFocusTraversalPolicyExt.findWindowPolicy(c);
                    if (policy != null) {
                        policy.setNoDefaultComponent(true, (Object)FocusManagerImpl.this);
                    }
                    FocusManagerImpl.this.requestFocus(c, false).doWhenProcessed(new Runnable(){

                        @Override
                        public void run() {
                            if (policy != null) {
                                policy.setNoDefaultComponent(false, (Object)FocusManagerImpl.this);
                            }
                        }
                    });
                }
            }
            FocusManagerImpl.this.myLastFocusedAtDeactivation.remove(ideFrame);
        }
    }

    class EdtAlarm {
        private final Set<EdtRunnable> myRequests = new HashSet<EdtRunnable>();

        EdtAlarm() {
        }

        public void cancelAllRequests() {
            for (EdtRunnable each : this.myRequests) {
                each.expire();
            }
            this.myRequests.clear();
        }

        public void addRequest(@NotNull EdtRunnable runnable, int delay) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/FocusManagerImpl$EdtAlarm", "addRequest"));
            }
            this.myRequests.add(runnable);
            FocusManagerImpl.this.myTimer.setUp((Runnable)runnable, (long)delay);
        }
    }

    private static class FurtherRequestor
    implements FocusRequestor {
        private final IdeFocusManager myManager;
        private final Expirable myExpirable;
        private Throwable myAllocation;
        private boolean myDisposed;

        private FurtherRequestor(@NotNull IdeFocusManager manager, @NotNull Expirable expirable) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor", "<init>"));
            }
            if (expirable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expirable", "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor", "<init>"));
            }
            this.myManager = manager;
            this.myExpirable = expirable;
            if (Registry.is((String)"ide.debugMode")) {
                this.myAllocation = new Exception();
            }
        }

        @NotNull
        public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor", "requestFocus"));
            }
            ActionCallback.Rejected result = this.isExpired() ? new ActionCallback.Rejected() : this.myManager.requestFocus(c, forced);
            result.doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)FurtherRequestor.this);
                }
            });
            ActionCallback.Rejected rejected = result;
            if (rejected == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor", "requestFocus"));
            }
            return rejected;
        }

        private boolean isExpired() {
            return this.myExpirable.isExpired() || this.myDisposed;
        }

        @NotNull
        public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor", "requestFocus"));
            }
            Object object = this.isExpired() ? new ActionCallback.Rejected() : this.myManager.requestFocus(command, forced);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor", "requestFocus"));
            }
            return object;
        }

        public void dispose() {
            this.myDisposed = true;
        }
    }

    private class KeyProcessorContext
    implements KeyEventProcessor.Context {
        private KeyProcessorContext() {
        }

        @NotNull
        public List<KeyEvent> getQueue() {
            List list = FocusManagerImpl.this.myToDispatchOnDone;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/FocusManagerImpl$KeyProcessorContext", "getQueue"));
            }
            return list;
        }

        public void dispatch(final @NotNull List<KeyEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/wm/impl/FocusManagerImpl$KeyProcessorContext", "dispatch"));
            }
            FocusManagerImpl.this.doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    FocusManagerImpl.this.myToDispatchOnDone.addAll(events);
                    FocusManagerImpl.this.restartIdleAlarm();
                }
            });
        }
    }

    private class IdleRunnable
    extends EdtRunnable {
        private IdleRunnable() {
        }

        public void runEdt() {
            if (FocusManagerImpl.this.canFlushIdleRequests()) {
                FocusManagerImpl.this.flushIdleRequests();
            } else {
                if (FocusManagerImpl.this.processFocusRevalidation() && FocusManagerImpl.this.isFocusTransferReady()) {
                    FocusManagerImpl.this.flushIdleRequests();
                }
                FocusManagerImpl.this.restartIdleAlarm();
            }
        }
    }
}

