/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.status.PresentationModeProgressPanel;
import com.intellij.openapi.wm.impl.status.ProcessPopup;
import com.intellij.openapi.wm.impl.status.StatusPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.RefreshFileSystemIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfoAndProgressPanel
extends JPanel
implements CustomStatusBarWidget {
    private final ProcessPopup myPopup;
    private final StatusPanel myInfoPanel = new StatusPanel();
    private final JPanel myRefreshAndInfoPanel = new JPanel();
    private final AnimatedIcon myProgressIcon;
    private final ArrayList<ProgressIndicatorEx> myOriginals = new ArrayList();
    private final ArrayList<TaskInfo> myInfos = new ArrayList();
    private final Map<InlineProgressIndicator, ProgressIndicatorEx> myInline2Original = new HashMap<InlineProgressIndicator, ProgressIndicatorEx>();
    private final MultiValuesMap<ProgressIndicatorEx, InlineProgressIndicator> myOriginal2Inlines = new MultiValuesMap();
    private final MergingUpdateQueue myUpdateQueue;
    private final Alarm myQueryAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private boolean myShouldClosePopupAndOnProcessFinish;
    private final Alarm myRefreshAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final AnimatedIcon myRefreshIcon;
    private String myCurrentRequestor;

    public InfoAndProgressPanel() {
        this.setOpaque(false);
        this.myRefreshIcon = new RefreshFileSystemIcon();
        this.myRefreshIcon.setPaintPassiveIcon(false);
        this.myRefreshAndInfoPanel.setLayout(new BorderLayout());
        this.myRefreshAndInfoPanel.setOpaque(false);
        this.myRefreshAndInfoPanel.add((Component)this.myRefreshIcon, "West");
        this.myRefreshAndInfoPanel.add((Component)this.myInfoPanel, "Center");
        this.myProgressIcon = new AsyncProcessIcon("Background process");
        this.myProgressIcon.setOpaque(false);
        this.myProgressIcon.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InfoAndProgressPanel.this.handle(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                InfoAndProgressPanel.this.handle(e);
            }
        });
        this.myProgressIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.myProgressIcon.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        this.myProgressIcon.setToolTipText(ActionsBundle.message((String)"action.ShowProcessWindow.double.click", (Object[])new Object[0]));
        this.myUpdateQueue = new MergingUpdateQueue("Progress indicator", 50, true, MergingUpdateQueue.ANY_COMPONENT);
        this.myPopup = new ProcessPopup(this);
        this.setRefreshVisible(false);
        this.restoreEmptyStatus();
    }

    private void handle(MouseEvent e) {
        if (UIUtil.isActionClick((MouseEvent)e, (int)501)) {
            if (!this.myPopup.isShowing()) {
                this.openProcessPopup(true);
            } else {
                this.hideProcessPopup();
            }
        } else if (e.isPopupTrigger()) {
            ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("BackgroundTasks");
            ActionManager.getInstance().createActionPopupMenu("unknown", group).getComponent().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @NotNull
    public String ID() {
        if ("InfoAndProgress" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "ID"));
        }
        return "InfoAndProgress";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getPresentation"));
        }
        return null;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "install"));
        }
    }

    public void dispose() {
        InlineProgressIndicator[] indicators;
        this.setRefreshVisible(false);
        for (InlineProgressIndicator indicator : indicators = this.getCurrentInlineIndicators().toArray(new InlineProgressIndicator[0])) {
            this.removeProgress(indicator);
        }
        this.myInline2Original.clear();
        this.myOriginal2Inlines.clear();
    }

    public JComponent getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<Pair<TaskInfo, ProgressIndicator>> getBackgroundProcesses() {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        // MONITORENTER : arrayList
        if (this.myOriginals.isEmpty()) {
            List<Pair<TaskInfo, ProgressIndicator>> list = Collections.emptyList();
            // MONITOREXIT : arrayList
            if (list != null) return list;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getBackgroundProcesses"));
        }
        ArrayList<Pair> result = new ArrayList<Pair>(this.myOriginals.size());
        int i = 0;
        while (true) {
            if (i >= this.myOriginals.size()) {
                List<Pair<TaskInfo, ProgressIndicator>> list = Collections.unmodifiableList(result);
                // MONITOREXIT : arrayList
                if (list != null) return list;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getBackgroundProcesses"));
            }
            result.add(Pair.create((Object)this.myInfos.get(i), (Object)this.myOriginals.get(i)));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgress(@NotNull ProgressIndicatorEx original, @NotNull TaskInfo info) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "addProgress"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "addProgress"));
        }
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            boolean veryFirst = !this.hasProgressIndicators();
            this.myOriginals.add(original);
            this.myInfos.add(info);
            InlineProgressIndicator expanded = this.createInlineDelegate(info, original, false);
            InlineProgressIndicator compact = this.createInlineDelegate(info, original, true);
            this.myPopup.addIndicator(expanded);
            this.myProgressIcon.resume();
            if (veryFirst && !this.myPopup.isShowing()) {
                this.buildInInlineIndicator(compact);
            } else {
                this.buildInProcessCount();
                if (this.myInfos.size() > 1 && Registry.is((String)"ide.windowSystem.autoShowProcessPopup")) {
                    this.openProcessPopup(false);
                }
            }
            this.runQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProgressIndicators() {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            return !this.myOriginals.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgress(@NotNull InlineProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "removeProgress"));
        }
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            if (!this.myInline2Original.containsKey(progress)) {
                return;
            }
            boolean last = this.myOriginals.size() == 1;
            boolean beforeLast = this.myOriginals.size() == 2;
            this.myPopup.removeIndicator(progress);
            ProgressIndicatorEx original = this.removeFromMaps(progress);
            if (this.myOriginals.contains(original)) {
                return;
            }
            if (last) {
                this.restoreEmptyStatus();
                if (this.myShouldClosePopupAndOnProcessFinish) {
                    this.hideProcessPopup();
                }
            } else if (this.myPopup.isShowing() || this.myOriginals.size() > 1) {
                this.buildInProcessCount();
            } else if (beforeLast) {
                this.buildInInlineIndicator(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            } else {
                this.restoreEmptyStatus();
            }
            this.runQuery();
        }
        Disposer.dispose((Disposable)progress);
    }

    private ProgressIndicatorEx removeFromMaps(@NotNull InlineProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "removeFromMaps"));
        }
        ProgressIndicatorEx original = this.myInline2Original.get(progress);
        this.myInline2Original.remove(progress);
        this.myOriginal2Inlines.remove((Object)original, (Object)progress);
        if (this.myOriginal2Inlines.get((Object)original) == null) {
            int originalIndex = this.myOriginals.indexOf(original);
            this.myOriginals.remove(originalIndex);
            this.myInfos.remove(originalIndex);
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProcessPopup(boolean requestFocus) {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            if (this.myPopup.isShowing()) {
                return;
            }
            if (this.hasProgressIndicators()) {
                this.myShouldClosePopupAndOnProcessFinish = true;
                this.buildInProcessCount();
            } else {
                this.myShouldClosePopupAndOnProcessFinish = false;
                this.restoreEmptyStatus();
            }
            this.myPopup.show(requestFocus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideProcessPopup() {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            if (!this.myPopup.isShowing()) {
                return;
            }
            if (this.myOriginals.size() == 1) {
                this.buildInInlineIndicator(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            } else if (!this.hasProgressIndicators()) {
                this.restoreEmptyStatus();
            } else {
                this.buildInProcessCount();
            }
            this.myPopup.hide();
        }
    }

    private void buildInProcessCount() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel progressCountPanel = new JPanel(new BorderLayout(0, 0));
        progressCountPanel.setOpaque(false);
        String processWord = this.myOriginals.size() == 1 ? " process" : " processes";
        LinkLabel label = new LinkLabel(this.myOriginals.size() + processWord + " running...", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                InfoAndProgressPanel.this.triggerPopupShowing();
            }
        });
        if (SystemInfo.isMac) {
            label.setFont((Font)JBUI.Fonts.label((float)11.0f));
        }
        label.setOpaque(false);
        Wrapper labelComp = new Wrapper((JComponent)label);
        labelComp.setOpaque(false);
        progressCountPanel.add((Component)labelComp, "Center");
        progressCountPanel.add((Component)this.myProgressIcon, "West");
        this.add((Component)this.myRefreshAndInfoPanel, "Center");
        progressCountPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)4));
        this.add((Component)progressCountPanel, "East");
        this.revalidate();
        this.repaint();
    }

    private void buildInInlineIndicator(@NotNull InlineProgressIndicator inline) {
        if (inline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inline", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "buildInInlineIndicator"));
        }
        this.removeAll();
        this.setLayout((LayoutManager)((Object)new InlineLayout()));
        this.add(this.myRefreshAndInfoPanel);
        JPanel inlinePanel = new JPanel(new BorderLayout());
        inline.getComponent().setBorder((Border)JBUI.Borders.empty((int)1, (int)0, (int)0, (int)2));
        JComponent inlineComponent = inline.getComponent();
        inlineComponent.setOpaque(false);
        inlinePanel.add((Component)inlineComponent, "Center");
        inlinePanel.add((Component)this.myProgressIcon, "West");
        inline.updateProgressNow();
        inlinePanel.setOpaque(false);
        this.add(inlinePanel);
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.PRESENTATION_MODE || !uiSettings.SHOW_STATUS_BAR && Registry.is((String)"ide.show.progress.without.status.bar")) {
            final JRootPane pane = this.myInfoPanel.getRootPane();
            assert (pane != null);
            final PresentationModeProgressPanel panel = new PresentationModeProgressPanel(inline);
            MyInlineProgressIndicator delegate = new MyInlineProgressIndicator(true, inline.getInfo(), inline){

                @Override
                protected void updateProgress() {
                    super.updateProgress();
                    panel.update();
                }
            };
            Disposer.register((Disposable)inline, (Disposable)delegate);
            Component anchor = InfoAndProgressPanel.getAnchor(pane);
            JBPopupFactory.getInstance().createBalloonBuilder(panel.getProgressPanel()).setFadeoutTime(0L).setFillColor(Gray.TRANSPARENT).setShowCallout(false).setBorderColor(Gray.TRANSPARENT).setBorderInsets((Insets)JBUI.emptyInsets()).setAnimationCycle(0).setCloseButtonEnabled(false).setHideOnClickOutside(false).setDisposable((Disposable)inline).setHideOnFrameResize(false).setHideOnKeyOutside(false).setBlockClicksThroughBalloon(true).setHideOnAction(false).createBalloon().show((PositionTracker)new PositionTracker<Balloon>(anchor){

                public RelativePoint recalculateLocation(Balloon object) {
                    Component c = InfoAndProgressPanel.getAnchor(pane);
                    return new RelativePoint(c, new Point(c.getWidth() - 150, c.getHeight() - 45));
                }
            }, Balloon.Position.above);
        }
    }

    @NotNull
    private static Component getAnchor(@NotNull JRootPane pane) {
        if (pane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pane", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getAnchor"));
        }
        JComponent tabWrapper = UIUtil.findComponentOfType((JComponent)pane, TabbedPaneWrapper.TabWrapper.class);
        if (tabWrapper != null) {
            JComponent jComponent = tabWrapper;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getAnchor"));
            }
            return jComponent;
        }
        JComponent splitters = UIUtil.findComponentOfType((JComponent)pane, EditorsSplitters.class);
        if (splitters != null) {
            JComponent jComponent = splitters;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getAnchor"));
            }
            return jComponent;
        }
        FileEditorManagerEx ex = FileEditorManagerEx.getInstanceEx(ProjectUtil.guessCurrentProject((JComponent)pane));
        Object object = ex == null ? pane : ex.getSplitters();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getAnchor"));
        }
        return object;
    }

    public Couple<String> setText(@Nullable String text, @Nullable String requestor) {
        if (StringUtil.isEmpty((String)text) && !Comparing.equal((String)requestor, (String)this.myCurrentRequestor) && !"Internal log requestor".equals(requestor)) {
            return Couple.of((Object)this.myInfoPanel.getText(), (Object)this.myCurrentRequestor);
        }
        boolean logMode = this.myInfoPanel.updateText("Internal log requestor".equals(requestor) ? "" : text);
        this.myCurrentRequestor = logMode ? "Internal log requestor" : requestor;
        return Couple.of((Object)text, (Object)requestor);
    }

    public void setRefreshVisible(final boolean visible) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                InfoAndProgressPanel.this.myRefreshAlarm.cancelAllRequests();
                InfoAndProgressPanel.this.myRefreshAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (visible) {
                            InfoAndProgressPanel.this.myRefreshIcon.resume();
                        } else {
                            InfoAndProgressPanel.this.myRefreshIcon.suspend();
                        }
                        InfoAndProgressPanel.this.myRefreshIcon.revalidate();
                        InfoAndProgressPanel.this.myRefreshIcon.repaint();
                    }
                }, visible ? 100 : 300);
            }
        });
    }

    public void setRefreshToolTipText(String tooltip) {
        this.myRefreshIcon.setToolTipText(tooltip);
    }

    public BalloonHandler notifyByBalloon(MessageType type, String htmlBody, @Nullable Icon icon, @Nullable HyperlinkListener listener) {
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlBody.replace("\n", "<br>"), icon != null ? icon : type.getDefaultIcon(), type.getPopupBackground(), listener).createBalloon();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoAndProgressPanel comp = InfoAndProgressPanel.this;
                if (comp.isShowing()) {
                    int offset = ((Component)comp).getHeight() / 2;
                    Point point = new Point(((Component)comp).getWidth() - offset, ((Component)comp).getHeight() - offset);
                    balloon.show(new RelativePoint((Component)comp, point), Balloon.Position.above);
                } else {
                    JRootPane rootPane = SwingUtilities.getRootPane(comp);
                    if (rootPane != null && rootPane.isShowing()) {
                        Container contentPane = rootPane.getContentPane();
                        Rectangle bounds = contentPane.getBounds();
                        Point target = UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)JBUI.size((int)1, (int)1));
                        target.y = bounds.height - 3;
                        balloon.show(new RelativePoint((Component)contentPane, target), Balloon.Position.above);
                    }
                }
            }
        });
        return new BalloonHandler(){

            public void hide() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        balloon.hide();
                    }
                });
            }
        };
    }

    @NotNull
    private InlineProgressIndicator createInlineDelegate(@NotNull TaskInfo info, @NotNull ProgressIndicatorEx original, boolean compact) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "createInlineDelegate"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "createInlineDelegate"));
        }
        Collection inlines = this.myOriginal2Inlines.get((Object)original);
        if (inlines != null) {
            for (InlineProgressIndicator eachInline : inlines) {
                if (eachInline.isCompact() != compact) continue;
                InlineProgressIndicator inlineProgressIndicator = eachInline;
                if (inlineProgressIndicator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "createInlineDelegate"));
                }
                return inlineProgressIndicator;
            }
        }
        MyInlineProgressIndicator inline = new MyInlineProgressIndicator(compact, info, original);
        this.myInline2Original.put(inline, original);
        this.myOriginal2Inlines.put((Object)original, (Object)inline);
        if (compact) {
            inline.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }
            });
        }
        MyInlineProgressIndicator myInlineProgressIndicator = inline;
        if (myInlineProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "createInlineDelegate"));
        }
        return myInlineProgressIndicator;
    }

    private void triggerPopupShowing() {
        if (this.myPopup.isShowing()) {
            this.hideProcessPopup();
        } else {
            this.openProcessPopup(true);
        }
    }

    private void restoreEmptyStatus() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myRefreshAndInfoPanel, "Center");
        this.myProgressIcon.suspend();
        Container iconParent = this.myProgressIcon.getParent();
        if (iconParent != null) {
            iconParent.remove((Component)this.myProgressIcon);
        }
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
    }

    public boolean isProcessWindowOpen() {
        return this.myPopup.isShowing();
    }

    public void setProcessWindowOpen(boolean open) {
        if (open) {
            this.openProcessPopup(true);
        } else {
            this.hideProcessPopup();
        }
    }

    private void runQuery() {
        if (this.getRootPane() == null) {
            return;
        }
        Set<InlineProgressIndicator> indicators = this.getCurrentInlineIndicators();
        if (indicators.isEmpty()) {
            return;
        }
        for (InlineProgressIndicator each : indicators) {
            each.updateProgress();
        }
        this.myQueryAlarm.cancelAllRequests();
        this.myQueryAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                InfoAndProgressPanel.this.runQuery();
            }
        }, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Set<InlineProgressIndicator> getCurrentInlineIndicators() {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        // MONITORENTER : arrayList
        Set<InlineProgressIndicator> set = this.myInline2Original.keySet();
        // MONITOREXIT : arrayList
        if (set != null) return set;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel", "getCurrentInlineIndicators"));
    }

    private class MyInlineProgressIndicator
    extends InlineProgressIndicator {
        private ProgressIndicatorEx myOriginal;

        public MyInlineProgressIndicator(@NotNull boolean compact, @NotNull TaskInfo task, ProgressIndicatorEx original) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$MyInlineProgressIndicator", "<init>"));
            }
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$MyInlineProgressIndicator", "<init>"));
            }
            super(compact, task);
            this.myOriginal = original;
            original.addStateDelegate(this);
            this.addStateDelegate(new AbstractProgressIndicatorExBase(){

                @Override
                public void cancel() {
                    super.cancel();
                    MyInlineProgressIndicator.this.updateProgress();
                }
            });
        }

        @Override
        public void stop() {
            super.stop();
            this.updateProgress();
        }

        @Override
        protected boolean isFinished() {
            TaskInfo info = this.getInfo();
            return info == null || this.isFinished(info);
        }

        @Override
        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$MyInlineProgressIndicator", "finish"));
            }
            super.finish(task);
            this.queueRunningUpdate(new Runnable(){

                @Override
                public void run() {
                    InfoAndProgressPanel.this.removeProgress(MyInlineProgressIndicator.this);
                }
            });
        }

        @Override
        public void dispose() {
            super.dispose();
            this.myOriginal = null;
        }

        @Override
        protected void cancelRequest() {
            this.myOriginal.cancel();
        }

        @Override
        protected void queueProgressUpdate(final Runnable update) {
            InfoAndProgressPanel.this.myUpdateQueue.queue(new Update(this, false, 1){

                public void run() {
                    update.run();
                }
            });
        }

        @Override
        protected void queueRunningUpdate(final Runnable update) {
            InfoAndProgressPanel.this.myUpdateQueue.queue(new Update(new Object(), false, 0){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(update);
                }
            });
        }
    }

    private static class InlineLayout
    extends AbstractLayoutManager {
        private int myProgressWidth;

        private InlineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result = new Dimension();
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Dimension prefSize = parent.getComponent(i).getPreferredSize();
                result.width += prefSize.width;
                result.height = Math.max(prefSize.height, result.height);
            }
            return result;
        }

        public void layoutContainer(Container parent) {
            assert (parent.getComponentCount() == 2);
            Component infoPanel = parent.getComponent(0);
            Component progressPanel = parent.getComponent(1);
            int progressPrefWidth = progressPanel.getPreferredSize().width;
            Dimension size = parent.getSize();
            int maxProgressWidth = (int)((double)size.width * 0.8);
            int minProgressWidth = (int)((double)size.width * 0.5);
            if (progressPrefWidth > this.myProgressWidth) {
                this.myProgressWidth = progressPrefWidth;
            }
            if (this.myProgressWidth > maxProgressWidth) {
                this.myProgressWidth = maxProgressWidth;
            }
            if (this.myProgressWidth < minProgressWidth) {
                this.myProgressWidth = minProgressWidth;
            }
            infoPanel.setBounds(0, 0, size.width - this.myProgressWidth, size.height);
            progressPanel.setBounds(size.width - this.myProgressWidth, 0, this.myProgressWidth, size.height);
        }
    }
}

