/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectsWelcomeScreenActionBase;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class NewRecentProjectPanel
extends RecentProjectPanel {
    public NewRecentProjectPanel(WelcomeScreen screen) {
        super(screen);
        ListWithFilter panel;
        this.setBorder(null);
        this.setBackground(FlatWelcomeFrame.getProjectsBackground());
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)this, JScrollPane.class);
        if (scrollPane != null) {
            scrollPane.setBackground(FlatWelcomeFrame.getProjectsBackground());
            int width = 300;
            int height = 460;
            scrollPane.setSize((Dimension)JBUI.size((int)300, (int)460));
            scrollPane.setMinimumSize((Dimension)JBUI.size((int)300, (int)460));
            scrollPane.setPreferredSize((Dimension)JBUI.size((int)300, (int)460));
        }
        if ((panel = (ListWithFilter)UIUtil.findComponentOfType((JComponent)this, ListWithFilter.class)) != null) {
            panel.setBackground(FlatWelcomeFrame.getProjectsBackground());
        }
    }

    @Override
    protected Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JList list = (JList)UIUtil.findComponentOfType((JComponent)this, JList.class);
        if (list != null) {
            list.updateUI();
        }
    }

    @Override
    protected JBList createList(AnAction[] recentProjectActions, Dimension size) {
        final JBList list = super.createList(recentProjectActions, size);
        list.setBackground(FlatWelcomeFrame.getProjectsBackground());
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object selected = list.getSelectedValue();
                ProjectGroup group = selected instanceof ProjectGroupActionGroup ? ((ProjectGroupActionGroup)((Object)selected)).getGroup() : null;
                int keyCode = e.getKeyCode();
                if (keyCode == 39) {
                    if (group != null) {
                        if (!group.isExpanded()) {
                            group.setExpanded(true);
                            ListModel model = ((NameFilteringListModel)list.getModel()).getOriginalModel();
                            int index = list.getSelectedIndex();
                            RecentProjectsWelcomeScreenActionBase.rebuildRecentProjectDataModel((DefaultListModel)model);
                            list.setSelectedIndex(group.getProjects().isEmpty() ? index : index + 1);
                        }
                    } else {
                        Component next;
                        FocusTraversalPolicy policy;
                        FlatWelcomeFrame frame = (FlatWelcomeFrame)UIUtil.getParentOfType(FlatWelcomeFrame.class, (Component)list);
                        if (frame != null && (policy = frame.getFocusTraversalPolicy()) != null && (next = policy.getComponentAfter(frame, (Component)list)) != null) {
                            next.requestFocus();
                        }
                    }
                } else if (keyCode == 37 && group != null && group.isExpanded()) {
                    group.setExpanded(false);
                    int index = list.getSelectedIndex();
                    ListModel model = ((NameFilteringListModel)list.getModel()).getOriginalModel();
                    RecentProjectsWelcomeScreenActionBase.rebuildRecentProjectDataModel((DefaultListModel)model);
                    list.setSelectedIndex(index);
                }
            }
        });
        list.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group;
                int index = list.locationToIndex(new Point(x, y));
                if (index != -1 && Arrays.binarySearch(list.getSelectedIndices(), index) < 0) {
                    list.setSelectedIndex(index);
                }
                if ((group = (ActionGroup)ActionManager.getInstance().getAction("WelcomeScreenRecentProjectActionGroup")) != null) {
                    ActionManager.getInstance().createActionPopupMenu("WelcomeScreen", group).getComponent().show(comp, x, y);
                }
            }
        });
        return list;
    }

    @Override
    protected boolean isUseGroups() {
        return FlatWelcomeFrame.isUseProjectGroups();
    }

    @Override
    protected ListCellRenderer createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectPanel.RecentProjectItemRenderer(this.myPathShortener){
            private GridBagConstraints nameCell;
            private GridBagConstraints pathCell;
            private GridBagConstraints closeButtonCell;
            JComponent spacer;
            {
                this.spacer = new NonOpaquePanel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(JBUI.scale((int)22), super.getPreferredSize().height);
                    }
                };
            }

            private void initConstraints() {
                this.nameCell = new GridBagConstraints();
                this.pathCell = new GridBagConstraints();
                this.closeButtonCell = new GridBagConstraints();
                this.nameCell.gridx = 0;
                this.nameCell.gridy = 0;
                this.nameCell.weightx = 1.0;
                this.nameCell.weighty = 1.0;
                this.nameCell.anchor = 23;
                this.nameCell.insets = JBUI.insets((int)6, (int)5, (int)1, (int)5);
                this.pathCell.gridx = 0;
                this.pathCell.gridy = 1;
                this.pathCell.insets = JBUI.insets((int)1, (int)5, (int)6, (int)5);
                this.pathCell.anchor = 25;
                this.closeButtonCell.gridx = 1;
                this.closeButtonCell.gridy = 0;
                this.closeButtonCell.anchor = 24;
                this.closeButtonCell.insets = JBUI.insets((int)7, (int)7, (int)7, (int)7);
                this.closeButtonCell.gridheight = 2;
            }

            @Override
            protected Color getListBackground(boolean isSelected, boolean hasFocus) {
                return isSelected ? FlatWelcomeFrame.getListSelectionColor(hasFocus) : FlatWelcomeFrame.getProjectsBackground();
            }

            @Override
            protected Color getListForeground(boolean isSelected, boolean hasFocus) {
                return UIUtil.getListForeground((isSelected && hasFocus ? 1 : 0) != 0);
            }

            @Override
            protected void layoutComponents() {
                this.setLayout(new GridBagLayout());
                this.initConstraints();
                this.add((Component)this.myName, this.nameCell);
                this.add((Component)this.myPath, this.pathCell);
            }

            @Override
            public Component getListCellRendererComponent(JList list, final Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Color fore = this.getListForeground(isSelected, list.hasFocus());
                final Color back = this.getListBackground(isSelected, list.hasFocus());
                final JLabel name = new JLabel();
                final JLabel path = new JLabel();
                name.setForeground(fore);
                path.setForeground(isSelected ? fore : UIUtil.getInactiveTextColor());
                this.setBackground(back);
                return new JPanel(){
                    {
                        this.setLayout(new BorderLayout());
                        this.setBackground(back);
                        boolean isGroup = value instanceof ProjectGroupActionGroup;
                        boolean isInsideGroup = false;
                        boolean isLastInGroup = false;
                        if (value instanceof ReopenProjectAction) {
                            String path2 = ((ReopenProjectAction)((Object)value)).getProjectPath();
                            for (ProjectGroup group : RecentProjectsManager.getInstance().getGroups()) {
                                List projects = group.getProjects();
                                if (!projects.contains(path2)) continue;
                                isInsideGroup = true;
                                isLastInGroup = path2.equals(projects.get(projects.size() - 1));
                                break;
                            }
                        }
                        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)7));
                        if (isInsideGroup) {
                            this.add((Component)spacer, "West");
                        }
                        if (isGroup) {
                            ProjectGroup group = ((ProjectGroupActionGroup)((Object)value)).getGroup();
                            name.setText(" " + group.getName());
                            name.setIcon(AllIcons.Nodes.Folder);
                            name.setFont(name.getFont().deriveFont(1));
                            this.add(name);
                            this.add((Component)new JLabel(group.isExpanded() ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon()), "East");
                        } else if (value instanceof ReopenProjectAction) {
                            NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            name.setText(((ReopenProjectAction)((Object)value)).getTemplatePresentation().getText());
                            path.setText(this.getTitle2Text((ReopenProjectAction)((Object)value), path, JBUI.scale((int)(isInsideGroup ? 80 : 60))));
                            p.add((Component)name, (Object)"North");
                            p.add((Component)path, (Object)"South");
                            Icon icon = RecentProjectsManagerBase.getProjectOrAppIcon(((ReopenProjectAction)((Object)value)).getProjectPath());
                            JLabel projectIcon = new JLabel("", icon, 2){

                                @Override
                                protected void paintComponent(Graphics g) {
                                    this.getIcon().paintIcon(this, g, 0, (this.getHeight() - this.getIcon().getIconHeight()) / 2);
                                }
                            };
                            projectIcon.setBorder((Border)JBUI.Borders.emptyRight((int)8));
                            projectIcon.setVerticalAlignment(0);
                            NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            panel.add((Component)p);
                            panel.add((Component)projectIcon, (Object)"West");
                            this.add((Component)panel);
                        }
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, JBUI.scale((int)44));
                    }
                };
            }
        };
    }

    @Override
    @Nullable
    protected JPanel createTitle() {
        return null;
    }
}

