/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.defaultFileTemplateUsage.FileHeaderChecker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.SaveProjectAsTemplateDialog;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateAction.class);
    private static final String PROJECT_TEMPLATE_XML = "project-template.xml";

    public void actionPerformed(AnActionEvent e) {
        final Project project = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        StorageScheme scheme = ((ProjectEx)project).getStateStore().getStorageScheme();
        if (scheme != StorageScheme.DIRECTORY_BASED) {
            Messages.showErrorDialog((Project)project, (String)"Project templates do not support old .ipr (file-based) format.\nPlease convert your project via File->Save as Directory-Based format.", (String)CommonBundle.getErrorTitle());
            return;
        }
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project, ".idea/description.html");
        final SaveProjectAsTemplateDialog dialog = new SaveProjectAsTemplateDialog(project, descriptionFile);
        if (dialog.showAndGet()) {
            final Module moduleToSave = dialog.getModuleToSave();
            final File file = dialog.getTemplateFile();
            final String description = dialog.getDescription();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Saving Project as Template", true, PerformInBackgroundOption.DEAF){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/platform/templates/SaveProjectAsTemplateAction$1", "run"));
                    }
                    SaveProjectAsTemplateAction.saveProject(project, file, moduleToSave, description, dialog.isReplaceParameters(), indicator);
                }

                public void onSuccess() {
                    Messages.showInfoMessage((String)(FileUtil.getNameWithoutExtension((File)file) + " was successfully created.\n" + "It's available now in Project Wizard"), (String)"Template Created");
                }

                public void onCancel() {
                    file.delete();
                }
            });
        }
    }

    public static VirtualFile getDescriptionFile(Project project, String path) {
        return VfsUtil.findRelativeFile((String)path, (VirtualFile)project.getBaseDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProject(final Project project, File zipFile, Module moduleToSave, String description, boolean replaceParameters, final ProgressIndicator indicator) {
        final Map<String, String> parameters = SaveProjectAsTemplateAction.computeParameters(project, replaceParameters);
        indicator.setText("Saving project...");
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        project.save();
                    }
                });
            }
        });
        indicator.setText("Processing project files...");
        ZipOutputStream stream = null;
        try {
            FileUtil.ensureExists((File)zipFile.getParentFile());
            stream = new ZipOutputStream(new FileOutputStream(zipFile));
            final VirtualFile dir = SaveProjectAsTemplateAction.getDirectoryToSave(project, moduleToSave);
            SaveProjectAsTemplateAction.writeFile(".idea/description.html", description, project, dir, stream, true);
            if (replaceParameters) {
                String text = SaveProjectAsTemplateAction.getInputFieldsText(parameters);
                SaveProjectAsTemplateAction.writeFile(".idea/project-template.xml", text, project, dir, stream, false);
            }
            ProjectFileIndex index = moduleToSave == null ? ProjectRootManager.getInstance((Project)project).getFileIndex() : ModuleRootManager.getInstance((Module)moduleToSave).getFileIndex();
            final ZipOutputStream finalStream = stream;
            index.iterateContent(new ContentIterator(){

                public boolean processFile(final VirtualFile virtualFile) {
                    if (!virtualFile.isDirectory()) {
                        String fileName = virtualFile.getName();
                        indicator.setText2(fileName);
                        try {
                            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)dir, (char)'/');
                            if (relativePath == null) {
                                throw new RuntimeException("Can't find relative path for " + virtualFile + " in " + dir);
                            }
                            boolean system = ".idea".equals(virtualFile.getParent().getName());
                            if (!(!system || fileName.equals("description.html") || fileName.equals(SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML) || fileName.equals("misc.xml") || fileName.equals("modules.xml") || fileName.equals("workspace.xml"))) {
                                return true;
                            }
                            ZipUtil.addFileToZip((ZipOutputStream)finalStream, (File)new File(virtualFile.getPath()), (String)(dir.getName() + "/" + relativePath), null, null, (ZipUtil.FileContentProcessor)new ZipUtil.FileContentProcessor(){

                                public InputStream getContent(File file) throws IOException {
                                    if (virtualFile.getFileType().isBinary() || SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML.equals(virtualFile.getName())) {
                                        return STANDARD.getContent(file);
                                    }
                                    String result = SaveProjectAsTemplateAction.getEncodedContent(virtualFile, project, parameters);
                                    return new ByteArrayInputStream(result.getBytes(CharsetToolkit.UTF8_CHARSET));
                                }
                            });
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    indicator.checkCanceled();
                    return true;
                }
            });
        }
        catch (Exception ex) {
            try {
                LOG.error((Throwable)ex);
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)project, (String)"Can't save project as template", (String)"Internal Error");
                    }
                });
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(stream);
                throw throwable;
            }
            StreamUtil.closeStream((Closeable)stream);
        }
        StreamUtil.closeStream((Closeable)stream);
    }

    private static void writeFile(String path, final String text, Project project, VirtualFile dir, ZipOutputStream stream, boolean overwrite) throws IOException {
        final VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project, path);
        if (descriptionFile == null) {
            stream.putNextEntry(new ZipEntry(dir.getName() + "/" + path));
            stream.write(text.getBytes());
            stream.closeEntry();
        } else if (overwrite) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VfsUtil.saveText((VirtualFile)descriptionFile, (String)text);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
    }

    public static Map<String, String> computeParameters(final Project project, boolean replaceParameters) {
        final HashMap<String, String> parameters = new HashMap<String, String>();
        if (replaceParameters) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ProjectTemplateParameterFactory[] extensions;
                    for (ProjectTemplateParameterFactory extension : extensions = (ProjectTemplateParameterFactory[])Extensions.getExtensions((ExtensionPointName)ProjectTemplateParameterFactory.EP_NAME)) {
                        String value = extension.detectParameterValue(project);
                        if (value == null) continue;
                        parameters.put(value, extension.getParameterId());
                    }
                }
            });
        }
        return parameters;
    }

    public static String getEncodedContent(VirtualFile virtualFile, Project project, Map<String, String> parameters) throws IOException {
        String text = VfsUtilCore.loadText((VirtualFile)virtualFile);
        FileTemplate template = FileTemplateManager.getInstance(project).getDefaultTemplate("File Header");
        String templateText = template.getText();
        Pattern pattern = FileHeaderChecker.getTemplatePattern(template, project, (TIntObjectHashMap<String>)new TIntObjectHashMap());
        String result = SaveProjectAsTemplateAction.convertTemplates(text, pattern, templateText);
        result = ProjectTemplateFileProcessor.encodeFile(result, virtualFile, project);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            result = result.replace(entry.getKey(), "${" + entry.getValue() + "}");
        }
        return result;
    }

    private static VirtualFile getDirectoryToSave(Project project, @Nullable Module module) {
        if (module == null) {
            return project.getBaseDir();
        }
        VirtualFile moduleFile = module.getModuleFile();
        assert (moduleFile != null);
        return moduleFile.getParent();
    }

    public static String convertTemplates(String input, Pattern pattern, String template) {
        Matcher matcher = pattern.matcher(input);
        int start = matcher.matches() ? matcher.start(1) : -1;
        StringBuilder builder = new StringBuilder(input.length() + 10);
        for (int i = 0; i < input.length(); ++i) {
            char c;
            if (start == i) {
                builder.append(template);
                i = matcher.end(1);
            }
            if ((c = input.charAt(i)) == '$' || c == '#') {
                builder.append('\\');
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static String getInputFieldsText(Map<String, String> parameters) {
        Element element = new Element("template");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            Element field = new Element("input-field");
            field.setText(entry.getValue());
            field.setAttribute("default", entry.getKey());
            element.addContent(field);
        }
        return JDOMUtil.writeElement((Element)element);
    }

    public void update(AnActionEvent e) {
        Project project = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabled(project != null && !project.isDefault());
    }
}

