/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.ObjectStubTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return (StubTreeLoader)ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    public String getStubAstMismatchDiagnostics(@NotNull VirtualFile file, @NotNull PsiFile psiFile, @NotNull ObjectStubTree stubTree, @Nullable Document prevCachedDocument) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        String msg = "";
        msg = msg + "\n file=" + psiFile;
        msg = msg + ", file.class=" + psiFile.getClass();
        msg = msg + ", file.lang=" + psiFile.getLanguage();
        msg = msg + ", modStamp=" + psiFile.getModificationStamp();
        msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
        msg = msg + "\n document before=" + prevCachedDocument;
        ObjectStubTree latestIndexedStub = this.readFromVFile(psiFile.getProject(), file);
        msg = msg + "\nlatestIndexedStub=" + latestIndexedStub;
        if (latestIndexedStub != null) {
            msg = msg + "\n   same size=" + (stubTree.getPlainList().size() == latestIndexedStub.getPlainList().size());
            msg = msg + "\n   debugInfo=" + latestIndexedStub.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg = msg + "\n viewProvider=" + viewProvider;
        msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg = msg + "; file stamp: " + file.getModificationStamp();
        msg = msg + "; file modCount: " + file.getModificationCount();
        msg = msg + "; file length: " + file.getLength();
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg = msg + "; doc stamp: " + document.getModificationStamp();
            msg = msg + "; doc size: " + document.getTextLength();
            msg = msg + "; committed: " + PsiDocumentManager.getInstance((Project)psiFile.getProject()).isCommitted(document);
        }
        return msg;
    }
}

